/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.zh.ChineseTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.zh.ChineseSentenceTokenizer;
import org.languagetool.tokenizers.zh.ChineseWordTokenizer;

public class Chinese
extends Language {
    private Tagger tagger;
    private Tokenizer wordTokenizer;
    private SentenceTokenizer sentenceTokenizer;
    private String name = "Chinese";

    public String getShortName() {
        return "zh";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getCountries() {
        return new String[]{"CN"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Tao Lin")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this));
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new ChineseTagger();
        }
        return this.tagger;
    }

    public final Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new ChineseWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new ChineseSentenceTokenizer();
        }
        return this.sentenceTokenizer;
    }
}

