/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.zh;

import cn.com.cjf.CJFBeanFactory;
import cn.com.cjf.ChineseJF;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ictclas4j.segment.SegTag;
import org.languagetool.JLanguageTool;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.tokenizers.Tokenizer;

public class ChineseWordTokenizer
implements Tokenizer {
    private SegTag seg;
    private ChineseJF chinesdJF;

    private void init() {
        if (this.chinesdJF == null) {
            this.chinesdJF = CJFBeanFactory.getChineseJF();
        }
        if (this.seg == null) {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            InputStream coreDictIn = dataBroker.getFromResourceDirAsStream("/zh/coreDict.dct");
            InputStream bigramDictIn = dataBroker.getFromResourceDirAsStream("/zh/BigramDict.dct");
            InputStream personTaggerDctIn = dataBroker.getFromResourceDirAsStream("/zh/nr.dct");
            InputStream personTaggerCtxIn = dataBroker.getFromResourceDirAsStream("/zh/nr.ctx");
            InputStream transPersonTaggerDctIn = dataBroker.getFromResourceDirAsStream("/zh/tr.dct");
            InputStream transPersonTaggerCtxIn = dataBroker.getFromResourceDirAsStream("/zh/tr.ctx");
            InputStream placeTaggerDctIn = dataBroker.getFromResourceDirAsStream("/zh/ns.dct");
            InputStream placeTaggerCtxIn = dataBroker.getFromResourceDirAsStream("/zh/ns.ctx");
            InputStream lexTaggerCtxIn = dataBroker.getFromResourceDirAsStream("/zh/lexical.ctx");
            this.seg = new SegTag(1, coreDictIn, bigramDictIn, personTaggerDctIn, personTaggerCtxIn, transPersonTaggerDctIn, transPersonTaggerCtxIn, placeTaggerDctIn, placeTaggerCtxIn, lexTaggerCtxIn);
        }
    }

    public List<String> tokenize(String text) {
        String result;
        this.init();
        try {
            result = this.seg.split(this.chinesdJF.chineseFan2Jan(text)).getFinalResult();
            result = result.replace("\u59cb##\u59cb\u5e74/t", "\u5e74/t");
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        String[] list = result.split(" ");
        return Arrays.asList(list);
    }
}

