/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;

public class UkrainianWordRepeatRule
extends WordRepeatRule {
    private static final Pattern DATE_TIME_NUM_PATTERN = Pattern.compile("date|time|number.*");
    private static final HashSet<String> REPEAT_ALLOWED_SET = new HashSet<String>(Arrays.asList("\u0441\u0442."));
    private static final HashSet<String> REPEAT_ALLOWED_CAPS_SET = new HashSet<String>(Arrays.asList("\u0414\u0436\u0435\u0439", "\u0411\u0456", "\u0421\u0456", "\u041b\u0430"));

    public UkrainianWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
    }

    public String getId() {
        return "UKRAINIAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        AnalyzedTokenReadings analyzedTokenReadings = tokens[position];
        String token = analyzedTokenReadings.getToken();
        if (position > 2 && token.equals("\u0434\u043e\u0431\u0440\u0430") && tokens[position - 2].getToken().equalsIgnoreCase("\u0432\u0456\u0434")) {
            return true;
        }
        if (position > 1 && token.equals("\u0449\u043e") && tokens[position - 2].getToken().equalsIgnoreCase("\u0442\u043e\u043c\u0443")) {
            return true;
        }
        if (position > 3 && token.equals("\u043d\u0456") && tokens[position - 2].getToken().equals(",") && tokens[position - 3].getToken().equalsIgnoreCase("\u0442\u0430\u043a")) {
            return true;
        }
        if (REPEAT_ALLOWED_SET.contains(token.toLowerCase())) {
            return true;
        }
        if (REPEAT_ALLOWED_CAPS_SET.contains(token)) {
            return true;
        }
        if (PosTagHelper.hasPosTag(analyzedTokenReadings, DATE_TIME_NUM_PATTERN)) {
            return true;
        }
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || this.isInitial(analyzedToken, tokens, position) || posTag.equals("SENT_END")) continue;
            return false;
        }
        return true;
    }

    private boolean isInitial(AnalyzedToken analyzedToken, AnalyzedTokenReadings[] tokens, int position) {
        return analyzedToken.getPOSTag().contains(IPOSTag.abbr.getText()) || analyzedToken.getToken().length() == 1 && Character.isUpperCase(analyzedToken.getToken().charAt(0)) && position < tokens.length - 1 && tokens[position + 1].getToken().equals(".");
    }

    protected RuleMatch createRuleMatch(String prevToken, String token, int prevPos, int pos, String msg, AnalyzedSentence sentence) {
        boolean doubleI;
        boolean bl = doubleI = prevToken.equals("\u0406") && token.equals("\u0456");
        if (doubleI) {
            msg = (String)msg + " \u0430\u0431\u043e, \u043c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0435\u0440\u0448\u0430 \u0406 \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u043e\u044e.";
        }
        RuleMatch ruleMatch = super.createRuleMatch(prevToken, token, prevPos, pos, (String)msg, sentence);
        if (doubleI) {
            ArrayList<String> replacements = new ArrayList<String>(ruleMatch.getSuggestedReplacements());
            replacements.add("I \u0456");
            ruleMatch.setSuggestedReplacements(replacements);
        }
        return ruleMatch;
    }
}

