/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.SearchHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenAgreementNounVerbExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementNounVerbExceptionHelper.class);
    private static final Set<String> MASC_FEM_SET = TokenAgreementNounVerbExceptionHelper.extendSet(ExtraDictionaryLoader.loadSet("/uk/masc_fem.txt"), "\u0435\u043a\u0441-");
    private static final Pattern INF_ARGREEMENT_PATTERN = Pattern.compile("(\u043d\u0435)?(\u0437\u0434\u0430\u0442\u043d\u0438\u0439|\u0437\u043c\u0443\u0448\u0435\u043d\u0438\u0439|\u0437?\u0433[\u0456\u043e]\u0434\u043d\u0438\u0439|\u0437\u043e\u0431\u043e\u0432'\u044f\u0437\u0430\u043d\u0438\u0439|\u043f\u043e\u0432\u0438\u043d\u043d\u0438\u0439|\u0433\u043e\u0442\u043e\u0432\u0438\u0439|\u0434\u043e\u0441\u0442\u043e\u0439\u043d\u0438\u0439|\u043f\u043e\u043a\u043b\u0438\u043a\u0430\u043d\u0438\u0439|\u0441\u043f\u0440\u043e\u043c\u043e\u0436\u043d\u0438\u0439|\u0440\u0430\u0434\u0438\u0439|\u043d\u0430\u043b\u0430\u0448\u0442\u043e\u0432\u0430\u043d\u0438\u0439|\u0437\u0430\u0446\u0456\u043a\u0430\u0432\u043b\u0435\u043d\u0438\u0439|\u043f\u043e\u0432\u0438\u043d\u043d\u043e|\u0437\u043c\u043e\u0433\u0430|\u0441\u0442\u0430\u043d|\u043c\u043e\u0436\u043d\u0430)");
    private static final Collection<String> GEO_QUALIFIERS = new HashSet<String>(Arrays.asList("\u0441\u0435\u043b\u043e", "\u0441\u0435\u043b\u0438\u0449\u0435", "\u043c\u0456\u0441\u0442\u043e", "\u043c\u0456\u0441\u0442\u0435\u0447\u043a\u043e", "\u0445\u0443\u0442\u0456\u0440", "\u0440\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430", "\u0434\u0435\u0440\u0436\u0430\u0432\u0430", "\u0433\u043e\u0440\u0430", "\u043f\u043b\u0430\u043d\u0435\u0442\u0430", "\u043c\u0456\u043a\u0440\u043e\u0440\u0430\u0439\u043e\u043d", "\u0440\u0430\u0439\u0446\u0435\u043d\u0442\u0440", "\u0437\u0430\u043f\u043e\u0432\u0456\u0434\u043d\u0438\u043a", "\u043c\u0438\u0441", "\u043c.", "\u0441.", "\u043f.", "\u0448\u0442\u0430\u0442", "\u043e\u043a\u0440\u0443\u0433", "\u0433\u0440\u0430\u0444\u0441\u0442\u0432\u043e", "\u0432\u0456\u0440\u0443\u0441", "\u0443\u0440\u0430\u0433\u0430\u043d"));

    private TokenAgreementNounVerbExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int nounPos, int verbPos, List<VerbInflectionHelper.Inflection> nounInflections, List<VerbInflectionHelper.Inflection> verbInflections, List<AnalyzedToken> nounTokenReadings, List<AnalyzedToken> verbTokenReadings) {
        int pos;
        Set<String> prepGovernedCases;
        int nextVerbPos;
        int prevVerbIdx;
        int foundIdx;
        if (PosTagHelper.hasPosTag(tokens[verbPos], PosTagHelper.VERB_INF_PATTERN)) {
            if (CaseGovernmentHelper.hasCaseGovernment(tokens[nounPos], "v_inf")) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0441\u0438\u043b\u0430").mBefore(tokens, nounPos) > 0) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u043f\u0440\u043e\u0442\u0438").mBefore(tokens, nounPos) > 0) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (Arrays.asList("\u0445\u0442\u043e\u0441\u044c", "\u0434\u0435\u0445\u0442\u043e").contains(tokens[nounPos].getCleanToken().toLowerCase())) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (Arrays.asList("\u043d\u0430\u043c\u0430\u0433\u0430\u044e\u0447\u0438\u0441\u044c").contains(tokens[verbPos - 1].getCleanToken().toLowerCase())) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTagPart(tokens[nounPos], "predic") && Arrays.asList("\u0431\u0443\u043b\u043e", "\u0431\u0443\u0434\u0435").contains(tokens[verbPos].getCleanToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043f\u0440\u0430\u0432\u0434\u0430").contains(tokens[nounPos].getToken().toLowerCase())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u043f\u0456\u0434 \u0442\u0440\u0438 \u0447\u043e\u0440\u0442\u0438").mBefore(tokens, nounPos) > 0) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0448\u0442\u0443\u043a\u0430").mBefore(tokens, nounPos) > 0) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u0431\u0456\u0441\u0438\u043a\u0438").mBefore(tokens, nounPos) > 0) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u0431\u0443\u0434\u044c \u044f\u043a\u043e\u0433\u043e").mAfter(tokens, verbPos) >= 1) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0441\u043a\u0430\u0437\u0430\u0442\u0438 \u0431").mAfter(tokens, verbPos - 1) >= 1) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u043f\u0440\u043e\u0442\u0438").mBefore(tokens, verbPos - 1) > 0) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u0432\u043e\u043d\u043e", "\u0440\u0435\u0448\u0442\u0430")) && PosTagHelper.hasPosTagPart(tokens[verbPos], ":impers")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u0413\u0430\u0437\u0430"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun:.*:p:v_naz(?!.*pron).*")) && LemmaHelper.hasLemma(tokens[nounPos - 1], Arrays.asList("\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438"), Pattern.compile("numr:p:v_zna"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        List<String> V_PREZYDENTY_PREP_LIST = Arrays.asList("\u0432", "\u0443", "\u043c\u0456\u0436", "\u043c\u0435\u0436\u0438", "\u043f\u043e\u043c\u0456\u0436", "\u043d\u0430");
        if (nounPos > 1 && PosTagHelper.hasPosTagStart(tokens[nounPos], "noun:anim:p:v_naz") && LemmaHelper.hasLemma(tokens[nounPos - 1], V_PREZYDENTY_PREP_LIST)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 2 && PosTagHelper.hasPosTagStart(tokens[nounPos], "noun:anim:p:v_naz") && PosTagHelper.hasPosTagStart(tokens[nounPos - 1], "adj:p:v_zna:rinanim") && LemmaHelper.hasLemma(tokens[nounPos - 2], V_PREZYDENTY_PREP_LIST)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.isCapitalized(tokens[verbPos].getToken()) && LemmaHelper.isCapitalized(tokens[nounPos].getToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun:anim:.:v_naz:prop:[fl]name.*")) && Arrays.asList("\u0456\u043c'\u044f", "\u043f\u0440\u0456\u0437\u0432\u0438\u0449\u0435", "\u043f\u0440\u0456\u0437\u0432\u0438\u0441\u044c\u043a\u043e").contains(tokens[nounPos - 1].getCleanToken().toLowerCase())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos > 2 && LemmaHelper.isCapitalized(tokens[nounPos].getToken()) && LemmaHelper.isCapitalized(tokens[nounPos - 1].getToken()) && !Collections.disjoint(VerbInflectionHelper.getNounInflections(tokens[nounPos - 1].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (StringUtils.isAllUpperCase((CharSequence)tokens[verbPos].getToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && tokens[nounPos].getToken().equals("\u042f")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos > 2 && verbPos < tokens.length - 1 && tokens[verbPos].getToken().equals("\u0434\u0430\u0432\u0430\u0439")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && verbPos < tokens.length - 1 && tokens[verbPos].getToken().equals("\u043c\u043e\u0436\u0435") && !tokens[verbPos - 1].getToken().equals("\u043d\u0435") && !PosTagHelper.hasPosTag(tokens[verbPos + 1], PosTagHelper.VERB_INF_PATTERN)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (!(nounPos <= 1 || !PosTagHelper.hasPosTag(tokens[verbPos], PosTagHelper.VERB_INF_PATTERN) || (foundIdx = LemmaHelper.reverseSearchIdx(tokens, nounPos - 1, 6, INF_ARGREEMENT_PATTERN, null)) < 0 || PosTagHelper.hasPosTagStart(tokens[foundIdx], "adj") && Collections.disjoint(InflectionHelper.getNounInflections(tokens[nounPos].getReadings()), InflectionHelper.getAdjInflections(tokens[foundIdx].getReadings())))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (!(verbPos >= tokens.length - 1 || !PosTagHelper.hasPosTag(tokens[verbPos], PosTagHelper.VERB_INF_PATTERN) || (foundIdx = LemmaHelper.forwardLemmaSearchIdx(tokens, verbPos + 1, 7, INF_ARGREEMENT_PATTERN, null)) < 0 || PosTagHelper.hasPosTagStart(tokens[foundIdx], "adj") && Collections.disjoint(InflectionHelper.getNounInflections(nounTokenReadings), InflectionHelper.getAdjInflections(tokens[foundIdx].getReadings())))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTag(tokens[verbPos], PosTagHelper.VERB_INF_PATTERN) && (prevVerbIdx = LemmaHelper.reverseSearchIdx(tokens, nounPos - 1, 7, null, Pattern.compile("verb.*"))) >= 0 && !Collections.disjoint(VerbInflectionHelper.getVerbInflections(tokens[prevVerbIdx].getReadings()), VerbInflectionHelper.getNounInflections(tokens[nounPos].getReadings()))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[verbPos], PosTagHelper.VERB_INF_PATTERN) && (nextVerbPos = new SearchHelper.Match().ignoreInserts().limit(8).target(SearchHelper.Condition.postag(Pattern.compile("verb.*"))).mAfter(tokens, verbPos + 1)) >= 0 && !Collections.disjoint(VerbInflectionHelper.getVerbInflections(tokens[nextVerbPos].getReadings()), VerbInflectionHelper.getNounInflections(tokens[nounPos].getReadings()))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && verbPos < tokens.length - 1 && tokens[nounPos].getToken().equals("\u0446\u0435") && LemmaHelper.DASHES_PATTERN.matcher(tokens[nounPos - 1].getToken()).matches()) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (tokens[nounPos].getToken().equals("\u0446\u0435") && PosTagHelper.hasPosTagPart(verbTokenReadings, "impers")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun.*:p:v_naz.*")) && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*?past:n.*")) && (Pattern.compile("\\d+[234]").matcher(tokens[nounPos - 1].getCleanToken()).matches() || Arrays.asList("\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438").contains(tokens[nounPos - 1].getCleanToken()))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*:[fp](:.*|$)")) && new SearchHelper.Match().target(SearchHelper.Condition.token("\u043f\u0430\u0440\u0430")).skip(SearchHelper.Condition.token(TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_PATTERN).negate()).mBefore(tokens, nounPos - 1) > 0) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*:p(:.*|$)"))) {
            int pos1;
            int pos3;
            int pos0left;
            if (nounPos > 2 && (tokens[nounPos - 1].getToken().equals("/") || tokens[nounPos - 2].getToken().equals("/"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[nounPos - 1].getToken()) && PosTagHelper.hasPosTag(tokens[nounPos - 2], PosTagHelper.NOUN_V_NAZ_PATTERN)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 3 && TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[nounPos - 2].getToken()) && PosTagHelper.hasPosTag(tokens[nounPos - 3], PosTagHelper.NOUN_V_NAZ_PATTERN) && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[nounPos - 1].getReadings()), InflectionHelper.getNounInflections(tokens[nounPos].getReadings()))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            int pos0right = pos0left = new SearchHelper.Match().ignoreInserts().limit(7).target(SearchHelper.Condition.token(TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_PATTERN)).skip(SearchHelper.Condition.postag(Pattern.compile("(noun.*?v_naz|(adj|numr):.:v_naz|adv|part).*"))).mBefore(tokens, nounPos - 1);
            if (pos0left > 0 && TokenAgreementNounVerbExceptionHelper.isNonPluralA(tokens, pos0left)) {
                pos0left = -1;
            }
            if (pos0left > 1 && tokens[pos0left - 1].getToken().equals(",")) {
                --pos0left;
            }
            if (pos0left > 1) {
                if (pos0right > 2) {
                    List<String> osobysto;
                    if (pos0left < tokens.length - 1 && LemmaHelper.hasLemma(tokens[pos0right + 1], "\u0456\u043d\u0448\u0438\u0439") && LemmaHelper.hasLemma(tokens[pos0left - 1], "\u0442\u043e\u0439")) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (PosTagHelper.hasPosTagPart(tokens[pos0left - 1], "conj")) {
                        --pos0left;
                    }
                    if ((osobysto = Arrays.asList("\u043e\u0441\u043e\u0431\u0438\u0441\u0442\u043e", "\u0437\u043e\u043a\u0440\u0435\u043c\u0430", "\u0437\u0430\u0433\u0430\u043b\u043e\u043c")).contains(tokens[pos0left - 1].getCleanToken())) {
                        --pos0left;
                    }
                    if (osobysto.contains(tokens[verbPos - 1].getCleanToken())) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (tokens[pos0left - 1].getToken().equals(")")) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (PosTagHelper.hasPosTag(tokens[pos0left - 1], PosTagHelper.NOUN_V_NAZ_PATTERN)) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (verbPos > 6 && PosTagHelper.hasPosTagPart(tokens[pos0left - 1], "adv") && PosTagHelper.hasPosTagPart(tokens[pos0left - 2], "conj")) {
                        pos0left -= 2;
                    }
                    while (pos0left > 2 && tokens[pos0left - 1].getToken().matches("[,\u00bb\u201c\u201d\"]")) {
                        --pos0left;
                    }
                }
                if (PosTagHelper.hasPosTagStart(tokens[pos0left - 1], "noun") || PosTagHelper.hasPosTagStart(tokens[pos0left - 1], "number:latin") || LemmaHelper.isPossiblyProperNoun(tokens[pos0left - 1])) {
                    TokenAgreementNounVerbExceptionHelper.logException();
                    return true;
                }
                if (PosTagHelper.hasPosTag(tokens[pos0left - 1], PosTagHelper.ADJ_V_NAZ_PATTERN)) {
                    TokenAgreementNounVerbExceptionHelper.logException();
                    return true;
                }
            }
            if ((pos3 = LemmaHelper.tokenSearch(tokens, verbPos - 2, (String)null, Pattern.compile("\u0442\u0430\u043a\u043e\u0436"), Pattern.compile("(noun|adj:.:v_naz|adv|part).*"), LemmaHelper.Dir.REVERSE)) > 1) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 5) {
                String lowerCasePrevToken = tokens[nounPos - 1].getToken().toLowerCase();
                if (Arrays.asList("\u0449\u043e", "\u043d\u0435").contains(lowerCasePrevToken) && LemmaHelper.tokenSearch(tokens, nounPos - 3, (String)null, Pattern.compile("(?iu)" + lowerCasePrevToken), Pattern.compile("(noun|adj).*"), LemmaHelper.Dir.REVERSE) > nounPos - 7) {
                    TokenAgreementNounVerbExceptionHelper.logException();
                    return true;
                }
            }
            if ((pos1 = LemmaHelper.tokenSearch(tokens, nounPos - 1, (String)null, Pattern.compile(","), Pattern.compile("adj.*"), LemmaHelper.Dir.REVERSE)) > 1 && PosTagHelper.hasPosTag(tokens[pos1 - 1], PosTagHelper.NOUN_V_NAZ_PATTERN) || pos1 > 2 && PosTagHelper.hasPosTag(tokens[pos1 - 1], "noun.*:v_rod.*") && PosTagHelper.hasPosTag(tokens[pos1 - 2], PosTagHelper.NOUN_V_NAZ_PATTERN)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 4 && LemmaHelper.isCapitalized(tokens[nounPos].getToken()) && (PosTagHelper.hasPosTagStart(tokens[nounPos - 1], "noun:anim") || LemmaHelper.isInitial(tokens[nounPos - 1])) && TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_WITH_COMMA.contains(tokens[nounPos - 2].getToken()) && LemmaHelper.isCapitalized(tokens[nounPos - 3].getToken()) && (PosTagHelper.hasPosTagStart(tokens[nounPos - 4], "noun:anim") || LemmaHelper.isInitial(tokens[nounPos - 1]))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            int idx = new SearchHelper.Match().target(SearchHelper.Condition.token(TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLURAL_PATTERN)).ignoreInserts().skip(SearchHelper.Condition.postag(Pattern.compile("(noun|adj).*?v_(naz|rod).*")), SearchHelper.Condition.token(Pattern.compile("\u0456?\u0437|\u0437\u0456|\u0432\u0456\u0434|\u043d\u0430|\u043d\u0430\u0432\u0456\u0442\u044c|\u0442\u0430\u043a\u043e\u0436|\u043f\u043e\u0442\u0456\u043c|\u0437\u0433\u043e\u0434\u043e\u043c"))).mBefore(tokens, nounPos - 1);
            if (idx > 0 && TokenAgreementNounVerbExceptionHelper.isNonPluralA(tokens, idx)) {
                idx = -1;
            }
            if (idx > 1 && (PosTagHelper.hasPosTag(tokens[idx - 1], PosTagHelper.NOUN_V_NAZ_PATTERN) || LemmaHelper.isCapitalized(tokens[idx - 1].getCleanToken()) || LemmaHelper.hasLemma(tokens[idx + 1], Arrays.asList("\u043d\u0430\u0432\u0456\u0442\u044c", "\u0442\u0430\u043a\u043e\u0436", "\u043f\u043e\u0442\u0456\u043c", "\u0437\u0433\u043e\u0434\u043e\u043c")) || LemmaHelper.hasLemma(tokens[idx - 1], Arrays.asList("\u043f\u043e\u0442\u0456\u043c", "\u0437\u0433\u043e\u0434\u043e\u043c")))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(tokens[nounPos], "numr") && !LemmaHelper.hasLemma(tokens[nounPos], "\u043e\u0434\u0438\u043d") || LemmaHelper.hasLemma(tokens[nounPos], Arrays.asList("\u0441\u043e\u0442\u043d\u044f", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u0434\u0435\u0441\u044f\u0442\u043e\u043a"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 1 && PosTagHelper.hasPosTagPart(tokens[nounPos - 1], "number") && (!tokens[nounPos - 1].getToken().endsWith("1") || tokens[nounPos - 1].getToken().endsWith("11"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(tokens[nounPos - 1], "num") && tokens[nounPos].getToken().equals("\u0447\u043e\u043b\u043e\u0432\u0456\u043a") && LemmaHelper.tokenSearch(tokens, 1, "noun:anim:f:.*", Pattern.compile("\u0436\u0456\u043d\u043a[\u0430\u0438]"), Pattern.compile(".*"), LemmaHelper.Dir.FORWARD) == -1) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 1 && (tokens[nounPos - 1].getToken().endsWith("+1") || LemmaHelper.tokenSearch(tokens, verbPos - 2, (String)null, Pattern.compile("\u043f\u043b\u044e\u0441"), Pattern.compile("(numr|adj).*.:v_naz.*"), LemmaHelper.Dir.REVERSE) > 0)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && LemmaHelper.hasLemma(tokens[nounPos - 2], "\u0440\u0435\u0448\u0442\u0430") && tokens[nounPos - 1].getToken() != null && tokens[nounPos - 1].getToken().matches(".+1")) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && LemmaHelper.hasLemma(tokens[nounPos], "\u043a\u043e\u0436\u043d\u0438\u0439") && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*(past:p|:p:3).*"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && tokens[nounPos - 1].getToken().matches("\u0430?\u043d\u0456|\u0436\u043e\u0434\u043d.*|\u043d\u0430\u0432\u0456\u0442\u044c")) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && tokens[verbPos - 1].getToken().equals("\u043d\u0435") && LemmaHelper.reverseSearch(tokens, nounPos - 1, 5, Pattern.compile("\u0430?\u043d\u0456"), null)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 3 && tokens[verbPos - 1].getToken().equals("\u043d\u0435") && tokens[nounPos - 2].getToken().matches("\u0430?\u043d\u0456") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[nounPos - 1].getReadings()), InflectionHelper.getNounInflections(tokens[nounPos].getReadings()))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (nounPos > 3 && PosTagHelper.hasPosTagPart(tokens[nounPos], ":prop") && PosTagHelper.hasPosTag(tokens[nounPos - 1], Pattern.compile("noun.*:v_rod.*")) && !Collections.disjoint(VerbInflectionHelper.getNounInflections(tokens[nounPos - 2].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1) {
            if (PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun:inanim:[mnf]:v_naz:prop:geo.*")) && PosTagHelper.hasPosTag(tokens[nounPos - 1], Pattern.compile("noun:inanim:[mnf]:v_(?!naz)(?!.*&pron).*"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (LemmaHelper.isPossiblyProperNoun(tokens[nounPos]) && LemmaHelper.hasLemma(tokens[nounPos - 1], GEO_QUALIFIERS)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (nounPos > 2 && LemmaHelper.isPossiblyProperNoun(tokens[nounPos]) && LemmaHelper.isPossiblyProperNoun(tokens[nounPos - 1]) && LemmaHelper.hasLemma(tokens[nounPos - 2], GEO_QUALIFIERS)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (nounPos > 3 && PosTagHelper.hasPosTagPart(tokens[nounPos], "v_naz:prop") && PosTagHelper.hasPosTag(tokens[nounPos - 1], "adj:.:v_naz.*") && PosTagHelper.hasPosTag(tokens[nounPos - 2], Pattern.compile("noun.*:v_(rod|zna|mis).*"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTagPart(tokens[nounPos], ":prop") && PosTagHelper.hasPosTag(tokens[verbPos], "verb.*:impers.*")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 3 && PosTagHelper.hasPosTag(tokens[nounPos], Pattern.compile("noun:inanim:.:v_naz:prop.*")) && PosTagHelper.hasPosTag(tokens[nounPos - 1], Pattern.compile("noun:inanim:.*")) && PosTagHelper.hasPosTag(tokens[nounPos - 2], Pattern.compile("adj:.*")) && PosTagHelper.hasPosTagPart(tokens[nounPos - 3], "prep") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases = CaseGovernmentHelper.getCaseGovernments(tokens[nounPos - 3], IPOSTag.prep.name()), tokens[nounPos - 1]) && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases, tokens[nounPos - 2])) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos < tokens.length - 1 && tokens[verbPos].getCleanToken().equals("\u0431\u0443\u043b\u043e") && (pos = LemmaHelper.tokenSearch(tokens, verbPos + 1, "verb:", null, Pattern.compile("adv.*"), LemmaHelper.Dir.FORWARD)) >= 0 && !Collections.disjoint(VerbInflectionHelper.getNounInflections(tokens[nounPos].getReadings()), VerbInflectionHelper.getVerbInflections(tokens[pos].getReadings()))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[nounPos], ":prop") && tokens[verbPos].getCleanToken().equals("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[verbPos + 1], "verb.*:impers.*")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && PosTagHelper.hasPosTag(tokens[nounPos - 1], Pattern.compile("noun:inanim:.:v_naz.*")) && !PosTagHelper.hasPosTagPart(tokens[nounPos - 1], ":&pron") && !PosTagHelper.hasPosTag(tokens[nounPos], "noun.*pron.*") && !Collections.disjoint(VerbInflectionHelper.getNounInflections(tokens[nounPos - 1].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(nounTokenReadings, "noun:anim:m:v_naz") && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*:f(:.*|$)")) && TokenAgreementNounVerbExceptionHelper.hasMascFemLemma(nounTokenReadings)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043f\u043e\u0440\u0430").contains(tokens[nounPos].getCleanToken().toLowerCase()) && Arrays.asList("\u0431\u0443\u043b\u043e").contains(tokens[verbPos].getCleanToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        List<String> pseudoPluralNouns = Arrays.asList("\u0440\u0435\u0448\u0442\u0430", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430", "\u0447\u0430\u0441\u0442\u043a\u0430", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430", "\u0442\u0440\u0435\u0442\u0438\u043d\u0430", "\u0447\u0432\u0435\u0440\u0442\u044c");
        if (pseudoPluralNouns.contains(tokens[nounPos].getCleanToken().toLowerCase()) && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile(".*:[pn](:.*|$)"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 2 && LemmaHelper.hasLemma(tokens[nounPos - 1], "\u043d\u0456\u0436")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (nounPos > 1 && tokens[nounPos].getToken().equalsIgnoreCase("\u0442\u0438") && PosTagHelper.hasPosTag(tokens[verbPos], Pattern.compile("noun.*?v_kly.*"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (verbPos < tokens.length - 2 && tokens[verbPos].getToken().equals("\u0432\u0456\u0437\u044c\u043c\u0438") && LemmaHelper.hasLemma(tokens[verbPos + 1], Arrays.asList("\u0456", "\u0439", "\u0442\u0430"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        int vPos = verbPos;
        if (verbPos > 3 && PosTagHelper.hasPosTag(tokens[verbPos - 1], Pattern.compile("noun:inanim:.:v_naz:prop.*"))) {
            Set<String> prepGovernedCases2;
            String token = tokens[nounPos - 1].getToken();
            if (LemmaHelper.isCapitalized(token) && PosTagHelper.hasPosTagStart(tokens[nounPos - 1], "adj")) {
                --vPos;
            }
            if (PosTagHelper.hasPosTagStart(tokens[vPos - 2], "noun:inanim") && PosTagHelper.hasPosTagPart(tokens[vPos - 3], "prep") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2 = CaseGovernmentHelper.getCaseGovernments(tokens[vPos - 3], IPOSTag.prep.name()), tokens[vPos - 2])) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (nounPos > 1 && PosTagHelper.hasPosTagPart(tokens[nounPos - 1], "adj") && PosTagHelper.hasPosTag(verbTokenReadings, PosTagHelper.VERB_INF_PATTERN) && CaseGovernmentHelper.hasCaseGovernment(tokens[nounPos - 1], "v_inf") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[nounPos - 1].getReadings()), InflectionHelper.getNounInflections(nounTokenReadings))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(tokens[nounPos], PosTagHelper.NOUN_V_NAZ_PATTERN) && LemmaHelper.tokenSearch(tokens, nounPos - 1, (String)null, Pattern.compile("[\u042f\u044f]\u043a"), PosTagHelper.ADJ_V_NAZ_PATTERN, LemmaHelper.Dir.REVERSE) != -1) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        return false;
    }

    static boolean isNonPluralA(AnalyzedTokenReadings[] tokens, int pos) {
        return (tokens[pos].getToken().equals("\u0430") || tokens[pos].getToken().equals("a")) && !LemmaHelper.hasLemma(tokens[pos + 1], Arrays.asList("\u0442\u0430\u043a\u043e\u0436", "\u043f\u043e\u0442\u0456\u043c", "\u043f\u0456\u0437\u043d\u0456\u0448\u0435"));
    }

    static boolean hasMascFemLemma(List<AnalyzedToken> nounTokenReadings) {
        String token = nounTokenReadings.get(0).getToken();
        if (token.endsWith("\u043e\u043b\u043e\u0433") || token.endsWith("\u0437\u043d\u0430\u0432\u0435\u0446\u044c")) {
            return true;
        }
        for (AnalyzedToken analyzedToken : nounTokenReadings) {
            String lemma;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !posTag.contains("noun:anim:m:v_naz") || !TokenAgreementNounVerbExceptionHelper.isInMascFemSet(lemma = analyzedToken.getLemma()) && (!lemma.contains("-") || !TokenAgreementNounVerbExceptionHelper.isInMascFemSet(lemma.replaceFirst("-.*", "")))) continue;
            return true;
        }
        return false;
    }

    private static boolean isInMascFemSet(String lemma) {
        return MASC_FEM_SET.contains(lemma.replace('\u2018', '-'));
    }

    private static Set<String> extendSet(Set<String> loadSet, String string) {
        Set extraSet = loadSet.stream().map(line -> "\u0435\u043a\u0441-" + line).collect(Collectors.toSet());
        loadSet.addAll(extraSet);
        return loadSet;
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

