/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.uk.PosTagHelper;

public abstract class LemmaHelper {
    private static final String IGNORE_CHARS = "\u00ad\u0301";
    public static final Set<String> CITY_AVENU = new HashSet<String>(Arrays.asList("\u0441\u0456\u0442\u0456", "\u0441\u0438\u0442\u0456", "\u0441\u0442\u0440\u0456\u0442", "\u0441\u0442\u0440\u0438\u0442", "\u0440\u0456\u0432\u0435\u0440", "\u0440\u0438\u0432\u0435\u0440", "\u0430\u0432\u0435\u043d\u044e", "\u0448\u0442\u0440\u0430\u0441\u0435", "\u0448\u0442\u0440\u0430\u0441\u0441\u0435", "\u0441\u044c\u043e\u0440\u043a\u043b", "\u0441\u043a\u0432\u0435\u0440"));
    public static final List<String> MONTH_LEMMAS = Arrays.asList("\u0441\u0456\u0447\u0435\u043d\u044c", "\u043b\u044e\u0442\u0438\u0439", "\u0431\u0435\u0440\u0435\u0437\u0435\u043d\u044c", "\u043a\u0432\u0456\u0442\u0435\u043d\u044c", "\u0442\u0440\u0430\u0432\u0435\u043d\u044c", "\u0447\u0435\u0440\u0432\u0435\u043d\u044c", "\u043b\u0438\u043f\u0435\u043d\u044c", "\u0441\u0435\u0440\u043f\u0435\u043d\u044c", "\u0432\u0435\u0440\u0435\u0441\u0435\u043d\u044c", "\u0436\u043e\u0432\u0442\u0435\u043d\u044c", "\u043b\u0438\u0441\u0442\u043e\u043f\u0430\u0434", "\u0433\u0440\u0443\u0434\u0435\u043d\u044c");
    public static final List<String> DAYS_OF_WEEK = Arrays.asList("\u043f\u043e\u043d\u0435\u0434\u0456\u043b\u043e\u043a", "\u0432\u0456\u0432\u0442\u043e\u0440\u043e\u043a", "\u0441\u0435\u0440\u0435\u0434\u0430", "\u0447\u0435\u0442\u0432\u0435\u0440", "\u043f'\u044f\u0442\u043d\u0438\u0446\u044f", "\u0441\u0443\u0431\u043e\u0442\u0430", "\u043d\u0435\u0434\u0456\u043b\u044f");
    public static final List<String> TIME_LEMMAS = Arrays.asList("\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u043a\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430-\u0434\u0432\u0456", "\u0445\u0432\u0438\u043b\u0438\u043d\u043a\u0430-\u0434\u0440\u0443\u0433\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u043a\u0430", "\u043f\u0456\u0432\u0433\u043e\u0434\u0438\u043d\u0438", "\u0433\u043e\u0434\u0438\u043d\u0430-\u0434\u0440\u0443\u0433\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430-\u0434\u0432\u0456", "\u0447\u0430\u0441", "\u0434\u0435\u043d\u044c", "\u0434\u0435\u043d\u044c-\u0434\u0440\u0443\u0433\u0438\u0439", "\u043f\u0456\u0432\u0434\u043d\u044f", "\u043d\u0456\u0447", "\u043d\u0456\u0447\u0435\u043d\u044c\u043a\u0430", "\u0432\u0435\u0447\u0456\u0440", "\u0440\u0430\u043d\u043e\u043a", "\u0442\u0438\u0436\u0434\u0435\u043d\u044c", "\u0442\u0438\u0436\u0434\u0435\u043d\u044c-\u0434\u0432\u0430", "\u0442\u0438\u0436\u0434\u0435\u043d\u044c-\u0434\u0440\u0443\u0433\u0438\u0439", "\u043c\u0456\u0441\u044f\u0446\u044c", "\u043c\u0456\u0441\u044f\u0446\u044c-\u0434\u0432\u0430", "\u043c\u0456\u0441\u044f\u0446\u044c-\u0434\u0440\u0443\u0433\u0438\u0439", "\u043c\u0456\u0441\u044f\u0446\u044c-\u043f\u0456\u0432\u0442\u043e\u0440\u0430", "\u0434\u043e\u0431\u0430", "\u043c\u0438\u0442\u044c", "\u0445\u0432\u0438\u043b\u044c\u043a\u0430", "\u0440\u0456\u043a", "\u0440\u0456\u043a-\u0434\u0432\u0430", "\u0440\u0456\u043a-\u043f\u0456\u0432\u0442\u043e\u0440\u0430", "\u043f\u0456\u0432\u0440\u043e\u043a\u0443", "\u043f\u0456\u0432\u0440\u043e\u043a\u0443-\u0440\u0456\u043a", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u0440\u0456\u0447\u0447\u044f", "\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u043f\u0456\u0432\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f", "\u043f\u0456\u0432\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f", "\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u0442\u044f", "\u043f\u0456\u0432\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u0442\u044f", "\u043a\u0432\u0430\u0440\u0442\u0430\u043b", "\u0433\u043e\u0434\u043e\u0447\u043e\u043a", "\u043b\u0456\u0442\u043e", "\u0437\u0438\u043c\u0430", "\u0432\u0435\u0441\u043d\u0430", "\u043e\u0441\u0456\u043d\u044c", "\u0442\u0430\u0439\u043c", "\u043c\u0438\u0442\u044c", "\u043f\u0435\u0440\u0456\u043e\u0434", "\u0442\u0435\u0440\u043c\u0456\u043d", "\u0441\u0435\u0437\u043e\u043d", "\u0434\u0435\u043a\u0430\u0434\u0430", "\u043a\u0430\u0434\u0435\u043d\u0446\u0456\u044f", "\u0440\u0430\u0443\u043d\u0434", "\u0441\u0435\u0437\u043e\u043d");
    public static final List<String> DISTANCE_LEMMAS = Arrays.asList("\u043c\u0456\u043b\u0456\u043c\u0435\u0442\u0440", "\u0441\u0430\u043d\u0442\u0438\u043c\u0435\u0442\u0440", "\u043c\u0435\u0442\u0440", "\u043a\u0456\u043b\u043e\u043c\u0435\u0442\u0440", "\u043a\u0456\u043b\u043e\u0433\u0440\u0430\u043c", "\u043a\u0456\u043b\u043e\u0433\u0440\u0430\u043c\u2013\u043f\u0456\u0432\u0442\u043e\u0440\u0430", "\u0433\u0435\u043a\u0442\u0430\u0440", "\u043c\u0438\u043b\u044f", "\u0430\u0440\u0448\u0438\u043d", "\u0434\u0435\u0446\u0438\u043c\u0435\u0442\u0440", "\u0432\u0435\u0440\u0441\u0442\u0432\u0430", "\u0432\u0435\u0440\u0441\u0442\u0430", "\u0433\u0440\u0430\u043c", "\u043b\u0456\u0442\u0440", "\u0444\u0443\u043d\u0442", "\u0442\u043e\u043d\u043d\u0430", "\u0446\u0435\u043d\u0442\u043d\u0435\u0440");
    public static final List<String> PSEUDO_NUM_LEMMAS = Arrays.asList("\u0434\u0435\u0441\u044f\u0442\u043e\u043a", "\u0434\u0435\u0441\u044f\u0442\u043e\u043a-\u0434\u0440\u0443\u0433\u0438\u0439", "\u0441\u043e\u0442\u043d\u044f", "\u0441\u043e\u0442\u043a\u0430", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u043f'\u044f\u0442\u0456\u0440\u043a\u0430", "\u043f\u0430\u0440\u0430", "\u0442\u0440\u0435\u0442\u0438\u043d\u0430", "\u0447\u0432\u0435\u0440\u0442\u044c", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430", "\u0434\u044e\u0436\u0438\u043d\u0430", "\u0436\u043c\u0435\u043d\u044f", "\u0436\u043c\u0435\u043d\u044c\u043a\u0430", "\u043a\u0443\u043f\u0430", "\u043a\u0443\u043f\u043a\u0430", "\u043f\u0430\u0440\u043e\u0447\u043a\u0430", "\u043e\u0431\u0435\u0440\u0435\u043c\u043e\u043a", "\u0431\u0435\u0437\u043b\u0456\u0447");
    static final Pattern ADV_QUANT_PATTERN = Pattern.compile("\u0431\u0456\u043b\u044c\u0448\u0435|\u043c\u0435\u043d\u0448\u0435|\u0447\u0438\u043c\u0430\u043b\u043e|\u0431\u0430\u0433\u0430\u0442\u043e|\u043c\u0430\u043b\u043e|\u0437\u0430\u0431\u0430\u0433\u0430\u0442\u043e|\u0437\u0430\u043c\u0430\u043b\u043e|\u043d\u0435\u043c\u0430\u043b\u043e|\u0431\u0430\u0433\u0430\u0442\u0435\u043d\u044c\u043a\u043e|\u0447\u0438\u043c\u0430\u043b\u0435\u043d\u044c\u043a\u043e|\u0441\u0442\u0456\u043b\u044c\u043a\u0438|\u043e\u0431\u043c\u0430\u043b\u044c|\u0432\u0434\u043e\u0441\u0442\u0430\u043b\u044c|\u0443\u0434\u043e\u0441\u0442\u0430\u043b\u044c|\u0442\u0440\u043e\u0445\u0438|\u0442\u0440\u043e\u0448\u043a\u0438|\u0434\u043e\u0441\u0438\u0442\u044c|\u0434\u043e\u0441\u0442\u0430\u0442\u043d\u044c\u043e|\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043d\u044c\u043e|\u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043d\u044c\u043e|\u0431\u0430\u0433\u0430\u0446\u044c\u043a\u043e|\u0447\u0438\u043c\u0431\u0456\u043b\u044c\u0448\u0435|\u043f\u043e\u0431\u0456\u043b\u044c\u0448\u0435|\u043f\u043e\u0440\u0456\u0432\u043d\u0443|\u0431\u0456\u043b\u044c\u0448\u0456\u0441\u0442\u044c|\u0442\u0440\u0456\u0448\u043a\u0438|\u043f\u0440\u0435\u0434\u043e\u0441\u0438\u0442\u044c|\u043f\u043e\u0432\u043d\u043e|\u043f\u043e\u0432\u043d\u0456\u0441\u0456\u043d\u044c\u043a\u043e|\u043c\u0456\u043b\u044c\u0439\u043e\u043d|\u0442\u0438\u0441\u044f\u0447\u0430|\u0441\u043e\u0442\u043d\u044f|\u043c\u0456\u043b\u044c\u044f\u0440\u0434|\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d|\u0434\u0435\u0441\u044f\u0442\u043e\u043a|\u043d\u0443\u043b\u044c|\u0431\u0435\u0437\u043b\u0456\u0447|\u043a\u0456\u043b\u044c\u043a\u0430|\u0434\u0435\u043a\u0456\u043b\u044c\u043a\u0430|\u043f\u0430\u0440\u0430|\u043f\u0430\u0440\u043e\u0447\u043a\u0430|\u043a\u0443\u043f\u0430|\u043a\u0443\u043f\u043a\u0430|\u0431\u0435\u0437\u043b\u0456\u0447|\u043c\u0456\u043d\u0456\u043c\u0443\u043c|\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c");
    public static final List<String> MONEY_LEMMAS = Arrays.asList("\u0433\u0440\u0438\u0432\u043d\u044f", "\u043a\u043e\u043f\u0456\u0439\u043a\u0430");
    public static final Set<String> TIME_PLUS_LEMMAS = new HashSet<String>();
    public static final Pattern TIME_PLUS_LEMMAS_PATTERN;
    public static final List<String> TIME_LEMMAS_SHORT;
    static final Pattern PART_INSERT_PATTERN;
    static final Set<String> PLUS_MINUS;
    private static final Pattern QUOTES;
    static final Pattern DASHES_PATTERN;
    static final Pattern QUOTES_PATTERN;

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Collection<String> lemmas) {
        List readings = analyzedTokenReadings.getReadings();
        return LemmaHelper.hasLemma((List<AnalyzedToken>)readings, lemmas);
    }

    public static boolean hasLemma(List<AnalyzedToken> readings, Collection<String> lemmas) {
        for (AnalyzedToken analyzedToken : readings) {
            if (!lemmas.contains(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(List<AnalyzedToken> readings, Pattern lemmaRegex) {
        for (AnalyzedToken analyzedToken : readings) {
            if (!lemmaRegex.matcher(analyzedToken.getLemma()).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, List<String> lemmas, String partPos) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            for (String lemma : lemmas) {
                if (!lemma.equals(analyzedToken.getLemma()) || analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().contains(partPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Collection<String> lemmas, Pattern posRegex) {
        if (!analyzedTokenReadings.hasReading()) {
            return false;
        }
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            if (analyzedToken.getPOSTag() == null || !posRegex.matcher(analyzedToken.getPOSTag()).matches() || !lemmas.contains(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemmaBase(AnalyzedTokenReadings analyzedTokenReadings, Collection<String> lemmas, Pattern posRegex) {
        if (!analyzedTokenReadings.hasReading()) {
            return false;
        }
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            if (analyzedToken.getPOSTag() == null || !posRegex.matcher(analyzedToken.getPOSTag()).matches()) continue;
            String lemma = analyzedToken.getLemma();
            if (lemmas.contains(lemma)) {
                return true;
            }
            int idx = lemma.indexOf(45);
            if (idx <= 2 || idx >= lemma.length() - 1 || !lemmas.contains(lemma.substring(0, idx))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, String lemma) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            if (!lemma.equals(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Pattern pattern) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            String lemma = analyzedToken.getLemma();
            if (lemma == null || !pattern.matcher(lemma).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Pattern pattern, Pattern posTagRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            String lemma = analyzedToken.getLemma();
            if (lemma == null || !pattern.matcher(lemma).matches() || posTagRegex == null || analyzedToken.getPOSTag() == null || !posTagRegex.matcher(analyzedToken.getPOSTag()).matches()) continue;
            return true;
        }
        return false;
    }

    static boolean reverseSearch(AnalyzedTokenReadings[] tokens, int pos, int depth, Pattern lemma, Pattern postag) {
        return LemmaHelper.reverseSearchIdx(tokens, pos, depth, lemma, postag) >= 0;
    }

    static int reverseSearchIdx(AnalyzedTokenReadings[] tokens, int pos, int depth, Pattern lemma, Pattern postag) {
        for (int i = pos; i > pos - depth && i >= 0; --i) {
            if (lemma != null && !LemmaHelper.hasLemma(tokens[i], lemma) || postag != null && !PosTagHelper.hasPosTag(tokens[i], postag)) continue;
            return i;
        }
        return -1;
    }

    static int forwardLemmaSearchIdx(AnalyzedTokenReadings[] tokens, int pos, int depth, Pattern lemma, Pattern postag) {
        for (int i = pos; i < pos + depth && i < tokens.length; ++i) {
            if (lemma != null && !LemmaHelper.hasLemma(tokens[i], lemma) || postag != null && !PosTagHelper.hasPosTag(tokens[i], postag)) continue;
            return i;
        }
        return -1;
    }

    static boolean forwardPosTagSearch(AnalyzedTokenReadings[] tokens, int pos, String posTag, int maxSkip) {
        for (int i = pos; i < tokens.length && i <= pos + maxSkip; ++i) {
            if (!PosTagHelper.hasPosTagPart(tokens[i], posTag)) continue;
            return true;
        }
        return false;
    }

    static int tokenSearch(AnalyzedTokenReadings[] tokens, int pos, String posTag, Pattern token, Pattern posTagsToIgnore, Dir dir) {
        int step = dir == Dir.FORWARD ? 1 : -1;
        for (int i = pos; i < tokens.length && i > 0; i += step) {
            AnalyzedTokenReadings currToken = tokens[i];
            if ((posTag == null || PosTagHelper.hasPosTagPart(currToken, posTag)) && (token == null || token.matcher(currToken.getCleanToken()).matches())) {
                return i;
            }
            if (posTagsToIgnore != null && !PosTagHelper.hasPosTag(currToken, posTagsToIgnore) && !QUOTES.matcher(currToken.getCleanToken()).matches()) break;
        }
        return -1;
    }

    static int tokenSearch(AnalyzedTokenReadings[] tokens, int pos, Pattern posTag, Pattern token, Pattern posTagsToIgnore, Dir dir) {
        int step = dir == Dir.FORWARD ? 1 : -1;
        for (int i = pos; i < tokens.length && i > 0; i += step) {
            if ((posTag == null || PosTagHelper.hasPosTag(tokens[i], posTag)) && (token == null || token.matcher(tokens[i].getCleanToken()).matches())) {
                return i;
            }
            if (posTagsToIgnore != null && !PosTagHelper.hasPosTag(tokens[i], posTagsToIgnore) && !QUOTES.matcher(tokens[i].getCleanToken()).matches()) break;
        }
        return -1;
    }

    static boolean revSearch(AnalyzedTokenReadings[] tokens, int startPos, Pattern lemma, String postagRegex) {
        return LemmaHelper.revSearchIdx(tokens, startPos, lemma, postagRegex) != -1;
    }

    static int revSearchIdx(AnalyzedTokenReadings[] tokens, int startPos, Pattern lemma, String postagRegex) {
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "part.*")) {
            --startPos;
        }
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "adv(:.*)?|.*pron.*")) {
            --startPos;
        }
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "part.*")) {
            --startPos;
        }
        if (startPos > 0) {
            if (lemma != null && !LemmaHelper.hasLemma(tokens[startPos], lemma)) {
                return -1;
            }
            if (postagRegex != null && !PosTagHelper.hasPosTag(tokens[startPos], postagRegex)) {
                return -1;
            }
            return startPos;
        }
        return -1;
    }

    public static boolean isAllUppercaseUk(String word) {
        int sz = word.length();
        for (int i = 0; i < sz; ++i) {
            char ch = word.charAt(i);
            if (ch == '-' || ch == '\u2013' || ch == '\'' || ch == '\u0301' || ch == '\u00ad' || Character.isUpperCase(ch)) continue;
            return false;
        }
        return true;
    }

    public static String capitalizeProperName(String word) {
        char[] chars = new char[word.length()];
        int prevChar = 45;
        for (int i = 0; i < chars.length; ++i) {
            char ch = word.charAt(i);
            chars[i] = prevChar == 45 ? ch : Character.toLowerCase(ch);
            prevChar = ch == '\u2013' ? 45 : (int)ch;
        }
        return new String(chars);
    }

    public static boolean isCapitalized(String word) {
        if (word == null || word.length() < 2) {
            return false;
        }
        char char0 = word.charAt(0);
        if (!Character.isUpperCase(char0)) {
            return false;
        }
        if (char0 >= 'A' && char0 <= 'Z' && Character.isLowerCase(word.charAt(1))) {
            return true;
        }
        boolean prevDash = false;
        int sz = word.length();
        for (int i = 1; i < sz; ++i) {
            boolean dash;
            char ch = word.charAt(i);
            if (IGNORE_CHARS.indexOf(ch) >= 0) continue;
            boolean bl = dash = ch == '-' || ch == '\u2013';
            if (dash) {
                if (i == sz - 2 && Character.isDigit(word.charAt(i + 1))) {
                    return true;
                }
                prevDash = dash;
                continue;
            }
            if (ch != '\'' && ch != '\u0301' && ch != '\u00ad' && prevDash != Character.isUpperCase(ch)) {
                return false;
            }
            prevDash = false;
        }
        return true;
    }

    static boolean isPossiblyProperNoun(AnalyzedTokenReadings analyzedTokenReadings) {
        return LemmaHelper.isCapitalized(analyzedTokenReadings.getCleanToken());
    }

    public static boolean isInitial(AnalyzedTokenReadings analyzedTokenReadings) {
        return analyzedTokenReadings.getCleanToken().endsWith(".") && analyzedTokenReadings.getCleanToken().matches("[\u0410-\u042f\u0406\u0407\u0404\u0490A-Z]\\.");
    }

    public static boolean isDash(AnalyzedTokenReadings analyzedTokenReadings) {
        return analyzedTokenReadings.getCleanToken() != null && DASHES_PATTERN.matcher(analyzedTokenReadings.getCleanToken()).matches();
    }

    static {
        TIME_LEMMAS_SHORT = Arrays.asList("\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430", "\u0440\u0456\u043a");
        PART_INSERT_PATTERN = Pattern.compile("\u0431\u043e\u0434\u0430\u0439|\u0431\u0443\u0446\u0456\u043c(\u0442\u043e)?|\u0433\u0435\u0442\u044c|\u0434\u0435\u0434\u0430\u043b\u0456|\u0434\u0435\u0441\u044c|\u0456\u0449\u0435|\u043b\u0435\u0434\u0432\u0435|\u043c\u043e\u0432(\u0431\u0438(\u0442\u043e)?)?|\u043d\u0430\u0432\u0456\u0442\u044c|\u043d\u0430\u0447\u0435(\u0431(\u0442\u043e)?)?|\u043d\u0435\u043d\u0430\u0447\u0435(\u0431\u0442\u043e)?|\u043d\u0435\u043c\u043e\u0432(\u0431\u0438(\u0442\u043e)?)?|\u043d\u0456\u0431\u0438(\u0442\u043e)?|\u043f\u043e\u043f\u0440\u043e\u0441\u0442\u0443|\u043f\u0440\u043e\u0441\u0442\u043e(-\u043d\u0430\u043f\u0440\u043e\u0441\u0442\u043e)?|\u0441\u043f\u0440\u0430\u0432\u0434\u0456|\u0443\u0441\u044c\u043e\u0433\u043e-\u043d\u0430-\u0432\u0441\u044c\u043e\u0433\u043e|\u0445\u0430\u0439|\u0445\u043e\u0447\u0430?|\u044f\u043a\u0440\u0430\u0437|\u0436|\u0431\u0438?");
        PLUS_MINUS = new HashSet<String>(Arrays.asList("\u043f\u043b\u044e\u0441", "\u043c\u0456\u043d\u0443\u0441", "\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c", "\u043c\u0456\u043d\u0456\u043c\u0443\u043c"));
        TIME_PLUS_LEMMAS.addAll(TIME_LEMMAS);
        TIME_PLUS_LEMMAS.addAll(DISTANCE_LEMMAS);
        TIME_PLUS_LEMMAS.addAll(DAYS_OF_WEEK);
        TIME_PLUS_LEMMAS.addAll(MONTH_LEMMAS);
        TIME_PLUS_LEMMAS.addAll(PSEUDO_NUM_LEMMAS);
        TIME_PLUS_LEMMAS.addAll(MONEY_LEMMAS);
        TIME_PLUS_LEMMAS.addAll(Arrays.asList("\u0432\u0438\u0445\u0456\u0434\u043d\u0438\u0439", "\u0443\u0457\u043a-\u0435\u043d\u0434", "\u0443\u0457\u043a\u0435\u043d\u0434", "\u0432\u0456\u043a\u0435\u043d\u0434", "\u0432\u0456\u0434\u0441\u043e\u0442\u043e\u043a", "\u0440\u0430\u0437", "\u043a\u0440\u043e\u043a"));
        TIME_PLUS_LEMMAS_PATTERN = Pattern.compile(StringUtils.join(TIME_PLUS_LEMMAS, (String)"|"));
        QUOTES = Pattern.compile("[\u00ab\u00bb\u201e\u201c\u201c]");
        DASHES_PATTERN = Pattern.compile("[\u2010-\u2015-]");
        QUOTES_PATTERN = Pattern.compile("[\\p{Pi}\\p{Pf}]");
    }

    static enum Dir {
        FORWARD,
        REVERSE;

    }
}

