/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;

class SimpleDisambiguator {
    final Map<String, TokenMatcher> DISAMBIG_REMOVE_MAP = SimpleDisambiguator.loadMap("/uk/disambig_remove.txt");
    final Map<String, List<String>> DISAMBIG_DUPS_MAP = SimpleDisambiguator.loadMapDups("/uk/disambig_dups.txt");

    SimpleDisambiguator() {
    }

    private static Map<String, TokenMatcher> loadMap(String path) {
        HashMap<String, TokenMatcher> result = new HashMap<String, TokenMatcher>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            line = line.replaceFirst(" *#.*", "");
            String[] parts = line.trim().split(" ", 2);
            String[] matchers = parts[1].split("\\|");
            ArrayList<MatcherEntry> matcherEntries = new ArrayList<MatcherEntry>();
            for (String string : matchers) {
                String[] matcherParts = string.split(" ");
                matcherEntries.add(new MatcherEntry(matcherParts[0], matcherParts[1]));
            }
            result.put(parts[0], new TokenMatcher(matcherEntries));
        }
        return result;
    }

    private static Map<String, List<String>> loadMapDups(String path) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            line = line.replaceFirst(" *#.*", "");
            String[] parts = line.trim().split(" ");
            result.put(parts[0], Arrays.asList(parts).subList(1, parts.length));
        }
        return result;
    }

    public void removeRareForms(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            int idx;
            String lowerToken;
            TokenMatcher tokenMatcher;
            String token = tokens[i].getCleanToken();
            if (StringUtils.isEmpty((CharSequence)token)) continue;
            if (Character.isLowerCase(token.charAt(0))) {
                token = token.toLowerCase();
            }
            if ((tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(token)) == null && (tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(lowerToken = token.toLowerCase())) == null && (idx = token.lastIndexOf(45)) > 0 && token.matches(".*-(\u0442\u043e|\u043e\u0442|\u0442\u0430\u043a\u0438|\u0431\u043e|\u043d\u043e)")) {
                String mainToken = token.substring(0, idx);
                tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(mainToken);
            }
            List analyzedTokens = tokens[i].getReadings();
            if (tokenMatcher != null) {
                for (int j = analyzedTokens.size() - 1; j >= 0; --j) {
                    AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokens.get(j);
                    if (!tokenMatcher.matches(analyzedToken)) continue;
                    tokens[i].removeReading(analyzedToken, "dis_remove_rare");
                }
            }
            Set lemmas = analyzedTokens.stream().map(t -> t.getLemma()).filter(l -> l != null).distinct().collect(Collectors.toSet());
            lemmas.retainAll(this.DISAMBIG_DUPS_MAP.keySet());
            if (lemmas.size() <= 0) continue;
            Set lemmasToRemove = lemmas.stream().map(l -> this.DISAMBIG_DUPS_MAP.get(l)).flatMap(Collection::stream).collect(Collectors.toSet());
            for (int j = analyzedTokens.size() - 1; j >= 0; --j) {
                AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokens.get(j);
                if (!lemmasToRemove.contains(analyzedToken.getLemma())) continue;
                tokens[i].removeReading(analyzedToken, "dis_remove_dups");
            }
        }
    }

    static class TokenMatcher {
        private final List<MatcherEntry> matchers;

        public TokenMatcher(List<MatcherEntry> matchers) {
            this.matchers = matchers;
        }

        public boolean matches(AnalyzedToken analyzedToken) {
            for (MatcherEntry matcher : this.matchers) {
                if (!matcher.matches(analyzedToken)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "TokenMatcher " + this.matchers;
        }
    }

    private static class MatcherEntry {
        private final String lemma;
        private final Pattern tagRegex;

        public MatcherEntry(String lemma, String tagRegex) {
            this.lemma = lemma;
            this.tagRegex = Pattern.compile(tagRegex);
        }

        public boolean matches(AnalyzedToken analyzedToken) {
            return ("*".equals(this.lemma) || this.lemma.equals(analyzedToken.getLemma())) && !analyzedToken.hasNoTag() && this.tagRegex.matcher(analyzedToken.getPOSTag()).matches();
        }

        public String toString() {
            return "MatcherEntry [lemma=" + this.lemma + ", tagRegex=" + this.tagRegex + "]";
        }
    }
}

