/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.SearchHelper;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementPrepNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementPrepNounExceptionHelper.class);
    private static final Set<String> NAMES = new HashSet<String>(Arrays.asList("\u0456\u043c'\u044f", "\u043f\u0440\u0456\u0437\u0432\u0438\u0449\u0435"));
    private static final Pattern PART_INSERT_PATTERN = Pattern.compile("\u0431\u043e\u0434\u0430\u0439|\u0431\u0443\u0446\u0456\u043c(\u0442\u043e)?|\u0433\u0435\u0442\u044c|\u0434\u0435\u0434\u0430\u043b\u0456|\u0434\u0435\u0441\u044c|\u0456\u0449\u0435|\u043b\u0435\u0434\u0432\u0435|\u043c\u043e\u0432(\u0431\u0438(\u0442\u043e)?)?|\u043d\u0430\u0432\u0456\u0442\u044c|\u043d\u0430\u0447\u0435(\u0431(\u0442\u043e)?)?|\u043d\u0435\u043d\u0430\u0447\u0435(\u0431\u0442\u043e)?|\u043d\u0435\u043c\u043e\u0432(\u0431\u0438(\u0442\u043e)?)?|\u043d\u0456\u0431\u0438(\u0442\u043e)?|\u043f\u043e\u043f\u0440\u043e\u0441\u0442\u0443|\u043f\u0440\u043e\u0441\u0442\u043e(-\u043d\u0430\u043f\u0440\u043e\u0441\u0442\u043e)?|\u0441\u043f\u0440\u0430\u0432\u0434\u0456|\u0443\u0441\u044c\u043e\u0433\u043e-\u043d\u0430-\u0432\u0441\u044c\u043e\u0433\u043e|\u0445\u0430\u0439|\u0445\u043e\u0447\u0430?|\u044f\u043a\u0440\u0430\u0437|\u0436|\u0431\u0438?");

    public static RuleException getExceptionInfl(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings prepTokenReadings, Set<String> posTagsToFind) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        String prep = prepTokenReadings.getCleanToken().toLowerCase();
        if (tokenReadings.getToken().equals("\u0434\u0438\u0432\u043e\u043c")) {
            return new RuleException(0);
        }
        if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("numr:.:v_naz.*"))) {
            return new RuleException(Type.exception);
        }
        if (prep.matches("\u0432|\u0443|\u043c\u0435\u0436\u0438|\u043c\u0456\u0436|\u043d\u0430") && PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun:anim:p:v_naz(?!:&).*"))) {
            return new RuleException(Type.exception);
        }
        if (prep.equals("\u043d\u0430")) {
            if (Character.isUpperCase(token.charAt(0)) && PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("noun.*?:.:v_rod.*")) || PosTagHelper.hasPosTag(tokenReadings, Pattern.compile(".*[fl]name.*")) && (i > 1 && NAMES.contains(tokens[i - 2].getAnalyzedToken(0).getToken()) || i > 2 && NAMES.contains(tokens[i - 3].getAnalyzedToken(0).getLemma()))) {
                return new RuleException(Type.exception);
            }
            if (token.equals("\u043c\u0430\u043d\u0435\u0440")) {
                return new RuleException(Type.exception);
            }
            if (token.equalsIgnoreCase("\u0431\u0456\u0441")) {
                return new RuleException(Type.exception);
            }
        }
        if (prep.equals("\u043f\u0440\u0438")) {
            if (token.equals("\u0457\u0445")) {
                return new RuleException(Type.skip);
            }
        } else if (prep.equals("\u0437") ? token.equals("\u0440\u0430\u043d\u0430") : (prep.equals("\u0432\u0456\u0434") ? token.equalsIgnoreCase("\u0430") || token.equals("\u0440\u0430\u043d\u0430") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u043c\u0430\u043b\u0430") : prep.equals("\u0434\u043e") && (token.equalsIgnoreCase("\u044f") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u0432\u0435\u043b\u0438\u043a\u0430")))) {
            return new RuleException(Type.exception);
        }
        if (tokens.length > i + 1) {
            if (LemmaHelper.isCapitalized(token) && LemmaHelper.CITY_AVENU.contains(tokens[i + 1].getAnalyzedToken(0).getToken().toLowerCase())) {
                return new RuleException(Type.exception);
            }
            if ((PosTagHelper.hasPosTagStart(tokens[i + 1], "num") || tokens[i + 1].getToken().equals("$")) && (token.equals("\u043c\u0456\u043d\u0443\u0441") || token.equals("\u043f\u043b\u044e\u0441") || token.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c") || token.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c"))) {
                return new RuleException(Type.exception);
            }
            if (PosTagHelper.hasPosTag(tokenReadings, "noun.*?:v_oru.*") && tokens[i + 1].hasPartialPosTag("adjp:pasv")) {
                return new RuleException(1);
            }
            if (token.equals("\u0441\u0432\u044f\u0442\u0430\u044f") && tokens[i + 1].getToken().equals("\u0441\u0432\u044f\u0442\u0438\u0445")) {
                return new RuleException(Type.exception);
            }
            if ((prep.equalsIgnoreCase("\u0447\u0435\u0440\u0435\u0437") || prep.equalsIgnoreCase("\u043d\u0430")) && (PosTagHelper.hasPosTagStart(tokenReadings, "noun:inanim:p:v_naz") || PosTagHelper.hasPosTagStart(tokenReadings, "noun:inanim:p:v_rod")) && (IPOSTag.isNum(tokens[i + 1].getAnalyzedToken(0).getPOSTag()) || i < tokens.length - 2 && LemmaHelper.hasLemma(tokens[i + 1], Arrays.asList("\u0437\u043e", "\u0437", "\u0456\u0437")) && tokens[i + 2].hasPartialPosTag("num"))) {
                return new RuleException(Type.exception);
            }
            if ((token.equals("\u0432\u0430\u043c\u0438") || token.equals("\u0442\u043e\u0431\u043e\u044e") || token.equals("\u0457\u043c\u0438")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u0436")) {
                return new RuleException(0);
            }
            if ((token.equals("\u0441\u043e\u0431\u0456") || token.equals("\u0439\u043e\u043c\u0443") || token.equals("\u0457\u043c")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u043f\u043e\u0434\u0456\u0431\u043d")) {
                return new RuleException(0);
            }
            if ((token.equals("\u0443\u0441\u0456\u043c") || token.equals("\u0432\u0441\u0456\u043c")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u0432\u0456\u0434\u043e\u043c")) {
                return new RuleException(0);
            }
            if (prep.equalsIgnoreCase("\u0434\u043e") && token.equals("\u0441\u0445\u0456\u0434") && tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u0441\u043e\u043d\u0446\u044f")) {
                return new RuleException(Type.exception);
            }
            if (tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u00ab") && tokens[i].getAnalyzedToken(0).getPOSTag().contains(":abbr")) {
                return new RuleException(Type.exception);
            }
            if (tokens.length > i + 2) {
                if (PosTagHelper.hasPosTag(tokenReadings, "adj:[mfn]:v_rod.*")) {
                    String genders = PosTagHelper.getGenders(tokenReadings, "adj:[mfn]:v_rod.*");
                    if (PosTagHelper.hasPosTag(tokens[i + 1], "noun.*?:[" + genders + "]:v_rod.*")) {
                        ++i;
                        return new RuleException(1);
                    }
                }
                if ((token.equals("\u043d\u0456\u043a\u043e\u043c\u0443") || token.equals("\u043d\u0456\u043a\u0438\u043c") || token.equals("\u043d\u0456\u0447\u0438\u043c") || token.equals("\u043d\u0456\u0447\u043e\u043c\u0443")) && tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u043d\u0435")) {
                    return new RuleException(Type.skip);
                }
            }
        }
        return new RuleException(Type.none);
    }

    public static RuleException getExceptionStrong(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings prepTokenReadings, Set<String> posTagsToFind) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        String prep = prepTokenReadings.getCleanToken().toLowerCase();
        if (i < tokens.length - 1 && tokenReadings.getToken().equals("\u043d\u0435") && PosTagHelper.hasPosTagStart(tokens[i + 1], "ad")) {
            return new RuleException(0);
        }
        if (tokenReadings.getToken().equals("\u0434\u0443\u0436\u0435")) {
            return new RuleException(0);
        }
        if (prep.equals("\u0434\u043e") && Arrays.asList("\u043d\u0430\u0432\u043f\u0430\u043a\u0438", "\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456", "\u0442\u0435\u043f\u0435\u0440", "\u043d\u0438\u043d\u0456", "\u0432\u0447\u043e\u0440\u0430", "\u0443\u0447\u043e\u0440\u0430").contains(token.toLowerCase())) {
            return new RuleException(Type.exception);
        }
        if ((prep.equals("\u043d\u0430") || prep.equals("\u0432\u0456\u0434")) && Arrays.asList("\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456", "\u0442\u0435\u043f\u0435\u0440", "\u043d\u0438\u043d\u0456", "\u0432\u0447\u043e\u0440\u0430", "\u0443\u0447\u043e\u0440\u0430", "\u0437\u0430\u0432\u0442\u0440\u0430", "\u0437\u0430\u0440\u0430\u0437").contains(token.toLowerCase())) {
            return new RuleException(Type.exception);
        }
        if (prep.equals("\u0437\u0430") && Arrays.asList("\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456", "\u0432\u0447\u043e\u0440\u0430", "\u0443\u0447\u043e\u0440\u0430").contains(token.toLowerCase())) {
            return new RuleException(Type.exception);
        }
        if (prep.equals("\u0432") && Arrays.asList("\u043d\u0456\u043a\u0443\u0434\u0438").contains(token.toLowerCase())) {
            return new RuleException(Type.exception);
        }
        if (prep.equals("\u0437\u0430\u043c\u0456\u0441\u0442\u044c") && new SearchHelper.Match().target(SearchHelper.Condition.postag(Pattern.compile("verb.*:inf.*"))).limit(4).skip(SearchHelper.Condition.token("\u043c\u043e\u0436\u043d\u0430").negate()).mAfter(tokens, i + 1) > 0) {
            return new RuleException(Type.exception);
        }
        if (Arrays.asList("\u0447\u0438\u043c\u0430\u043b\u043e", "\u043a\u0456\u043b\u044c\u043a\u0430", "\u0434\u0435\u043a\u0456\u043b\u044c\u043a\u0430", "\u044f\u043a\u043e\u043c\u043e\u0433\u0430").contains(token.toLowerCase())) {
            return new RuleException(Type.exception);
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0442\u0435").mBefore(tokens, i) > 0) {
            return new RuleException(Type.exception);
        }
        return new RuleException(Type.none);
    }

    public static RuleException getExceptionNonInfl(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings prepTokenReadings, Set<String> posTagsToFind) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String token = tokenReadings.getCleanToken();
        if (PosTagHelper.hasPosTagStart(tokenReadings, "part") && PART_INSERT_PATTERN.matcher(token.toLowerCase()).matches()) {
            return new RuleException(0);
        }
        if (token.matches("\u043b\u0438\u0448(\u0435(\u043d\u044c)?)?")) {
            return new RuleException(0);
        }
        if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("adv(?!p).*"))) {
            if (i < tokens.length - 1 && PosTagHelper.hasPosTagStart(tokens[i + 1], "adj") && PosTagHelper.hasPosTagPartAll(tokenReadings, "adv")) {
                return new RuleException(0);
            }
            return new RuleException(Type.exception);
        }
        if (tokens.length > i + 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("noun:(un)?anim:.:v_dav:&pron.*"))) {
            if (PosTagHelper.hasPosTagStart(tokens[i + 1], "adj") && CaseGovernmentHelper.hasCaseGovernment(tokens[i + 1], "v_dav")) {
                return new RuleException(1);
            }
            if (tokens.length > i + 2 && PosTagHelper.hasPosTagStart(tokens[i + 1], "adv") && PosTagHelper.hasPosTagStart(tokens[i + 2], "adj") && CaseGovernmentHelper.hasCaseGovernment(tokens[i + 2], "v_dav")) {
                return new RuleException(2);
            }
        }
        if (tokens.length > i + 2 && token.equals("\u043d\u0456\u0447\u043e\u0433\u043e") && tokens[i + 1].getToken().equals("\u043d\u0435") && PosTagHelper.hasPosTagStart(tokens[i + 2], "adj")) {
            return new RuleException(1);
        }
        return new RuleException(Type.none);
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }

    public static class RuleException {
        public final Type type;
        public final int skip;

        public RuleException(Type type) {
            this.type = type;
            this.skip = 0;
            if (type == Type.exception) {
                TokenAgreementPrepNounExceptionHelper.logException();
            }
        }

        public RuleException(int skip) {
            this.type = Type.skip;
            this.skip = skip;
        }
    }

    public static enum Type {
        none,
        exception,
        skip;

    }
}

