/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.rules.Example;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.uk.HiddenCharacterRule;
import org.languagetool.rules.uk.MissingHyphenRule;
import org.languagetool.rules.uk.MixedAlphabetsRule;
import org.languagetool.rules.uk.MorfologikUkrainianSpellerRule;
import org.languagetool.rules.uk.SimpleReplaceRenamedRule;
import org.languagetool.rules.uk.SimpleReplaceRule;
import org.languagetool.rules.uk.SimpleReplaceSoftRule;
import org.languagetool.rules.uk.SimpleReplaceSpelling1992Rule;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementNounVerbRule;
import org.languagetool.rules.uk.TokenAgreementNumrNounRule;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.TokenAgreementVerbNounRule;
import org.languagetool.rules.uk.TypographyRule;
import org.languagetool.rules.uk.UkrainianCommaWhitespaceRule;
import org.languagetool.rules.uk.UkrainianUppercaseSentenceStartRule;
import org.languagetool.rules.uk.UkrainianWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.uk.UkrainianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.uk.UkrainianHybridDisambiguator;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.uk.UkrainianWordTokenizer;

public class Ukrainian
extends Language {
    public static final Pattern IGNORED_CHARS = Pattern.compile("[\u00ad\u0301]");
    private static final List<String> RULE_FILES = Arrays.asList("grammar-spelling.xml", "grammar-grammar.xml", "grammar-barbarism.xml", "grammar-style.xml", "grammar-punctuation.xml");
    public static final Ukrainian DEFAULT_VARIANT = new Ukrainian();

    public Pattern getIgnoredCharactersRegex() {
        return IGNORED_CHARS;
    }

    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    public String getName() {
        return "Ukrainian";
    }

    public String getShortCode() {
        return "uk";
    }

    public String[] getCountries() {
        return new String[]{"UA"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new UkrainianTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return UkrainianSynthesizer.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new UkrainianHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new UkrainianWordTokenizer();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin"), new Contributor("Maksym Davydov")};
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikUkrainianSpellerRule(messages, this, null, null);
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        MorfologikUkrainianSpellerRule morfologikSpellerRule = new MorfologikUkrainianSpellerRule(messages, this, userConfig, altLanguages);
        return Arrays.asList(new Rule[]{new UkrainianCommaWhitespaceRule(messages, Example.wrong((String)"\u041c\u0438 \u043e\u0431\u0456\u0434\u0430\u043b\u0438 \u0431\u043e\u0440\u0449\u0435\u043c<marker> ,</marker> \u043f\u043b\u043e\u0432\u043e\u043c \u0456 \u0441\u0430\u043b\u0430\u0442\u043e\u043c,\u2014 \u0432\u0441\u0435 \u0441\u043c\u0430\u0447\u043d\u0435."), Example.fixed((String)"\u041c\u0438 \u043e\u0431\u0456\u0434\u0430\u043b\u0438 \u0431\u043e\u0440\u0449\u0435\u043c<marker>,</marker> \u043f\u043b\u043e\u0432\u043e\u043c \u0456 \u0441\u0430\u043b\u0430\u0442\u043e\u043c,\u2014 \u0432\u0441\u0435 \u0441\u043c\u0430\u0447\u043d\u0435")), new UkrainianUppercaseSentenceStartRule(messages, this, Example.wrong((String)"<marker>\u0440\u0435\u0447\u0435\u043d\u043d\u044f</marker> \u043c\u0430\u0454 \u043f\u043e\u0447\u0438\u043d\u0430\u0442\u0438\u0441\u044f \u0437 \u0432\u0435\u043b\u0438\u043a\u043e\u0457."), Example.fixed((String)"<marker>\u0420\u0435\u0447\u0435\u043d\u043d\u044f</marker> \u043c\u0430\u0454 \u043f\u043e\u0447\u0438\u043d\u0430\u0442\u0438\u0441\u044f \u0437 \u0432\u0435\u043b\u0438\u043a\u043e\u0457")), new MultipleWhitespaceRule(messages, (Language)this), new UkrainianWordRepeatRule(messages, this), new TypographyRule(messages), new HiddenCharacterRule(messages), morfologikSpellerRule, new MissingHyphenRule(messages, ((UkrainianTagger)this.getTagger()).getWordTagger()), new TokenAgreementVerbNounRule(messages), new TokenAgreementNounVerbRule(messages), new TokenAgreementAdjNounRule(messages, this), new TokenAgreementPrepNounRule(messages, this), new TokenAgreementNumrNounRule(messages, this), new MixedAlphabetsRule(messages), new SimpleReplaceSoftRule(messages), new SimpleReplaceRenamedRule(messages), this.getSpellingReplacementRule(messages), new SimpleReplaceRule(messages, morfologikSpellerRule)});
    }

    protected Rule getSpellingReplacementRule(ResourceBundle messages) throws IOException {
        return new SimpleReplaceSpelling1992Rule(messages);
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dirBase = dataBroker.getRulesDir() + "/" + this.getShortCode() + "/";
        for (String ruleFile : RULE_FILES) {
            ruleFileNames.add(dirBase + ruleFile);
        }
        return ruleFileNames;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        return Arrays.asList("piv_before_iotized_1992", "piv_with_proper_noun_1992");
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return false;
    }
}

