/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class LetterEndingForNumericHelper {
    private static final Map<String, List<RegexToCaseList>> NUMR_ENDING_MAP;

    LetterEndingForNumericHelper() {
    }

    public static String[] findTags(String leftWord, String rightWord) {
        if (NUMR_ENDING_MAP.containsKey(rightWord)) {
            return RegexToCaseList.getCaseTags(leftWord, NUMR_ENDING_MAP.get(rightWord));
        }
        return null;
    }

    static {
        HashMap<String, List<RegexToCaseList>> map2 = new HashMap<String, List<RegexToCaseList>>();
        map2.put("\u0439", Arrays.asList(RegexToCaseList.always(":m:v_naz", ":m:v_zna:rinanim", ":f:v_dav", ":f:v_mis")));
        map2.put("\u0438\u0439", Arrays.asList(RegexToCaseList.always(":m:v_naz", ":m:v_zna:rinanim")));
        map2.put("\u0456\u0439", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", ":f:v_dav", ":f:v_mis"), RegexToCaseList.always(":m:v_naz", ":m:v_zna:rinanim", ":f:v_dav", ":f:v_mis")));
        map2.put("\u0442\u0456\u0439", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", ":f:v_dav", ":f:v_mis"), RegexToCaseList.always(":m:v_naz", ":m:v_zna:rinanim", ":f:v_dav", ":f:v_mis")));
        map2.put("\u0433\u043e", Arrays.asList(RegexToCaseList.always(":m:v_rod", ":m:v_zna:ranim", ":n:v_rod")));
        map2.put("\u043c\u0443", Arrays.asList(RegexToCaseList.always(":m:v_dav", ":m:v_mis", ":n:v_dav", ":n:v_mis", ":f:v_zna")));
        map2.put("\u043c", Arrays.asList(RegexToCaseList.always(":m:v_oru", ":n:v_oru", ":p:v_dav")));
        map2.put("\u0438\u043c", Arrays.asList(RegexToCaseList.always(":m:v_oru", ":n:v_oru", ":p:v_dav")));
        map2.put("\u0456\u043c", Arrays.asList(RegexToCaseList.always(":m:v_oru", ":m:v_mis", ":n:v_oru", ":n:v_mis")));
        map2.put("\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0432\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0448\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0433\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0442\u044f", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0442\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u043c\u0430", Arrays.asList(RegexToCaseList.always(":f:v_naz")));
        map2.put("\u0457", Arrays.asList(RegexToCaseList.always(":f:v_rod")));
        map2.put("\u043e\u0457", Arrays.asList(RegexToCaseList.always(":f:v_rod")));
        map2.put("\u0442\u043e\u0457", Arrays.asList(RegexToCaseList.always(":f:v_rod")));
        map2.put("\u0443", Arrays.asList(RegexToCaseList.always(":f:v_zna")));
        map2.put("\u0448\u0443", Arrays.asList(RegexToCaseList.always(":f:v_zna")));
        map2.put("\u0433\u0443", Arrays.asList(RegexToCaseList.always(":f:v_zna")));
        map2.put("\u0442\u0443", Arrays.asList(RegexToCaseList.always(":f:v_zna")));
        map2.put("\u0442\u044e", Arrays.asList(RegexToCaseList.always(":f:v_zna")));
        map2.put("\u043e\u044e", Arrays.asList(RegexToCaseList.always(":f:v_oru")));
        map2.put("\u044e", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", ":f:v_oru"), RegexToCaseList.always(":f:v_zna", ":f:v_oru")));
        map2.put("\u0435", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0454", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0448\u0435", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0433\u0435", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0442\u0454", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0442\u0435", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u043c\u0435", Arrays.asList(RegexToCaseList.always(":n:v_naz", ":n:v_zna")));
        map2.put("\u0456", Arrays.asList(RegexToCaseList.always(":p:v_naz", ":p:v_zna:rinanim")));
        map2.put("\u0432\u0456", Arrays.asList(RegexToCaseList.always(":p:v_naz:bad", ":p:v_zna:rinanim:bad")));
        map2.put("\u0442\u0456", Arrays.asList(RegexToCaseList.always(":p:v_naz", ":p:v_zna:rinanim")));
        map2.put("\u043d\u0456", Arrays.asList(RegexToCaseList.always(":p:v_naz", ":p:v_zna:rinanim")));
        map2.put("\u0445", Arrays.asList(RegexToCaseList.always(":p:v_rod", ":p:v_zna:ranim", ":p:v_mis")));
        map2.put("\u0438\u0445", Arrays.asList(RegexToCaseList.always(":p:v_rod", ":p:v_zna:ranim", ":p:v_mis")));
        map2.put("\u043c\u0438", Arrays.asList(RegexToCaseList.always(":p:v_oru")));
        NUMR_ENDING_MAP = Collections.unmodifiableMap(map2);
    }

    static class RegexToCaseList {
        private final Pattern pattern;
        private final String[] cases;

        public RegexToCaseList(String regex, String ... cases) {
            this.pattern = regex != null ? Pattern.compile(regex) : null;
            this.cases = cases;
        }

        public static RegexToCaseList always(String ... cases) {
            return new RegexToCaseList(null, cases);
        }

        public static RegexToCaseList regex(String regex, String ... cases) {
            return new RegexToCaseList(regex, cases);
        }

        public static String[] getCaseTags(String leftWord, List<RegexToCaseList> caseLists) {
            for (RegexToCaseList regexToCaseList : caseLists) {
                if (regexToCaseList.pattern != null && !regexToCaseList.pattern.matcher(leftWord).matches()) continue;
                return regexToCaseList.cases;
            }
            System.err.println("Not found cases for " + leftWord);
            return new String[0];
        }
    }
}

