/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementNounVerbExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.TokenAgreementVerbNounRule;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenAgreementVerbNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementVerbNounExceptionHelper.class);
    private static final Pattern VCHYTY_PATTERN = Pattern.compile(".*\u0432\u0447[\u0430\u0438]\u0442\u0438(\u0441\u044f)?");
    private static final Pattern ADV_PREDICT_PATTERN = Pattern.compile("(adv|noninfl:&predic).*");

    private TokenAgreementVerbNounExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int verbPos, int nounAdjPos, TokenAgreementVerbNounRule.State state, List<VerbInflectionHelper.Inflection> verbInflections, List<VerbInflectionHelper.Inflection> nounAdjInflections, List<AnalyzedToken> verbTokenReadings, List<AnalyzedToken> nounTokenReadings) {
        String genders2;
        Pattern vRodDriverPattern;
        int xpos;
        int v2pos;
        if (tokens[nounAdjPos].getCleanToken().matches("[0-9]+-.+|\u0434\u043e\u0440\u043e\u0433\u043e\u044e|\u0442\u043e\u043b\u043a\u043e\u043c|\u0434\u0438\u0432\u043e\u043c|\u0447\u0432\u0435\u0440\u0442\u044c|\u0442\u0440\u0435\u0442\u0438\u043d\u0443|\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0443|\u0441\u0432\u044f\u0442\u0430\u044f")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:f:v_zna.*")) && tokens[nounAdjPos + 1].getCleanToken().equals("\u0434\u043e\u0440\u043e\u0433\u0443")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], "impers") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_oru.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Arrays.asList("\u0437\u0432\u0430\u0442\u0438\u0441\u044f", "\u043d\u0430\u0437\u0438\u0432\u0430\u0442\u0438\u0441\u044f")) && Character.isUpperCase(tokens[nounAdjPos].getCleanToken().charAt(0))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Arrays.asList("\u0442\u0440\u0438\u0432\u0430\u0442\u0438", "\u043f\u0440\u043e\u0442\u0440\u0438\u0432\u0430\u0442\u0438", "\u0439\u0442\u0438", "\u0456\u0442\u0438", "\u0445\u043e\u0434\u0438\u0442\u0438", "\u0457\u0445\u0430\u0442\u0438")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|numr|noun:inanim).*v_zna.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && tokens[nounAdjPos].getCleanToken().equals("\u0441\u0432\u0456\u0442") && LemmaHelper.hasLemma(tokens[nounAdjPos + 1], "\u0437\u0430") && tokens[nounAdjPos + 2].getCleanToken().equals("\u043e\u0447\u0456")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 3 && tokens[verbPos].getCleanToken().equalsIgnoreCase("\u0432\u043f\u0430\u043b\u043e") && "\u043d\u0456".equals(tokens[verbPos - 1].getCleanToken())) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 2 && tokens[verbPos].getCleanToken().equalsIgnoreCase("\u0441\u043a\u0430\u0437\u0430\u0442\u0438") && "\u043d\u0435".equals(tokens[verbPos - 1].getCleanToken()) && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_naz")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (state.cases.contains("v_rod") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("numr.*?v_zna.*|noun.*v_zna.*numr.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun|adj):.*:v_rod.*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 1], Pattern.compile("num.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun|adj):.*:v_rod.*")) && LemmaHelper.isDash(tokens[nounAdjPos + 1]) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("num.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun:inanim|adj):.:v_rod.*")) && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, (Pattern)null, Pattern.compile("\u043d\u0430"), Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 5 && v2pos < tokens.length - 1) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun.*v_(rod|zna).*")) && tokens[nounAdjPos + 1].getCleanToken().matches("\u043d\u0430|\u0437|\u0456\u0437|\u0437\u043e|\u043f\u0456\u0434") && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("number|numr.*v_zna.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun:.*v_rod.*")) && tokens[nounAdjPos + 1].getCleanToken().matches("\u043c\u0435\u043d\u0448\u0435|\u0431\u0456\u043b\u044c\u0448\u0435")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u044f\u043a", "\u043a\u0443\u0434\u0438", "\u0434\u0435", "\u0449\u043e", "\u0447\u043e\u0433\u043e", "\u0447\u0438")) && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|noun).*v_dav.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|noun).*v_dav.*")) && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u043d\u0456\u043a\u043e\u043b\u0438|\u043d\u0456\u043a\u0443\u0434\u0438|\u043d\u0456\u0447\u043e\u0433\u043e|\u043d\u0456\u0447\u0438\u043c|\u043d\u0456\u0434\u0435|\u043d\u0435\u043c\u0430\u0454?|\u043d\u0435")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|noun).*v_dav.*")) && tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u043d\u0456\u043a\u043e\u043b\u0438|\u043d\u0456\u043a\u0443\u0434\u0438|\u043d\u0456\u0447\u043e\u0433\u043e|\u043d\u0456\u0447\u0438\u043c|\u043d\u0435\u043c\u0430\u0454?|\u043d\u0435")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_dav.*")) && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u0432|\u0443|\u043d\u0430|\u0432\u0456\u0434|\u043f\u0456\u0434|\u043f\u043e|\u0434\u043e|\u0456?\u0437|\u0437[\u0456\u043e]|\u043d\u0430\u0434|\u0437-\u043f\u0456\u0434|\u043f\u0435\u0440\u0435\u0434|\u043f\u043e\u043f\u0456\u0434|\u043f\u043e\u0437\u0430|\u043d\u0430\u043f\u0435\u0440\u0435\u0440\u0456\u0437") && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("(noun|adj).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun.*?v_dav:&pron:(pers|refl).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_dav.*")) && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u043d\u0430\u0437\u0443\u0441\u0442\u0440\u0456\u0447|\u043d\u0430\u0432\u043f\u0435\u0440\u0435\u0439\u043c\u0438|\u043d\u0430\u0432\u0437\u0434\u043e\u0433\u0456\u043d|\u0443\u0441\u043b\u0456\u0434")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && tokens[nounAdjPos].getCleanToken().equalsIgnoreCase("\u0433\u0440\u0456\u0445")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemmaBase(tokens[nounAdjPos], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:.:v_(zna|rod|oru).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|numr).*v_(rod|zna|oru).*|noun.*v_(rod|zna|oru).*numr.*")) && LemmaHelper.hasLemma(tokens[nounAdjPos + 1], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:.:v_(rod|zna|oru).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|numr).*v_(rod|zna|oru).*")) && (tokens[nounAdjPos + 1].getCleanToken().matches("\u0436\u0435?") || PosTagHelper.hasPosTag(tokens[nounAdjPos + 1], Pattern.compile("(adj|numr).*v_(rod|zna|oru).*|number|noun.*v_(rod|zna|oru).*numr.*"))) && LemmaHelper.hasLemma(tokens[nounAdjPos + 2], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:.:v_(rod|zna|oru).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 3 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("numr.*v_zna.*")) && tokens[nounAdjPos + 1].getCleanToken().matches("\u0437") && tokens[nounAdjPos + 2].getCleanToken().matches("\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043e\u044e") && LemmaHelper.hasLemma(tokens[nounAdjPos + 3], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:.:v_(rod|zna).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && nounAdjPos < tokens.length - 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u043d\u0435") && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos + 1], "v_rod")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u0441\u043b\u0456\u0434") && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(state.verbAnalyzedTokenReadings, Pattern.compile("(\u043f\u043e)?\u043c\u0435\u043d\u0448\u0430\u0442\u0438|(\u043f\u043e)?\u0431\u0456\u043b\u044c\u0448\u0430\u0442\u0438|\u0441\u0442\u0430\u0442\u0438"), Pattern.compile("verb.*:[sn](:.*|$)")) && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile("(noun|adj).*v_rod.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().equals("\u043a\u043e\u043b\u044c\u043e\u0440\u0443") && PosTagHelper.hasPosTagStart(tokens[nounAdjPos], "adj:m:v_rod")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_kly") && PosTagHelper.hasPosTagPart(tokens[verbPos], "impr")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(nounTokenReadings, "noun:anim:m:v_naz") && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*:f(:.*|$)")) && TokenAgreementNounVerbExceptionHelper.hasMascFemLemma(nounTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_rod") && PosTagHelper.hasPosTag(state.verbTokenReadings, Pattern.compile("verb.*?(futr|past):(s:3.*|n($|:.+))"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (state.verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_rod") && (xpos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, (String)null, vRodDriverPattern = Pattern.compile("\u043d\u0435|(\u043d\u0430)?\u0441[\u043a\u0442]\u0456\u043b\u044c\u043a\u0438|(\u043d\u0430\u0439)?\u0431\u0456\u043b\u044c\u0448\u0435|(\u043d\u0430\u0439)?\u043c\u0435\u043d\u0448\u0435|(\u043d\u0435|\u0437\u0430)?\u0431\u0430\u0433\u0430\u0442\u043e|(\u043d\u0435|\u0447\u0438|\u0437\u0430)?\u043c\u0430\u043b\u043e|\u0442\u0440\u043e\u0445\u0438|\u0433\u043e\u0434\u0456|\u043d\u0435\u043c\u043e\u0436\u043b\u0438\u0432\u043e|\u0430?\u043d\u0456\u0436|\u0432\u0434\u043e\u0441\u0442\u0430\u043b\u044c", 66), Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && xpos >= state.verbPos - 4) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && CaseGovernmentHelper.hasCaseGovernment(state.verbAnalyzedTokenReadings, PosTagHelper.VERB_PATTERN, "v_inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 5 && TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 4 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.VERB_PATTERN, "v_inf")) {
            if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (tokens[v2pos - 1].getCleanToken().equals("\u043d\u0435")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && !LemmaHelper.hasLemma(tokens[verbPos], VCHYTY_PATTERN)) {
            v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD);
            while (v2pos >= 0 && v2pos <= state.nounPos + 4) {
                Set<String> cases = CaseGovernmentHelper.getCaseGovernments(tokens[v2pos], ADV_PREDICT_PATTERN);
                if (TokenAgreementPrepNounRule.hasVidmPosTag(cases, state.nounAdjIndirTokenReadings)) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                v2pos = LemmaHelper.tokenSearch(tokens, v2pos + 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD);
            }
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.ADJ_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
            String genders1 = PosTagHelper.getGenders(tokens[nounAdjPos], "(noun|adj).*v_naz.*");
            genders2 = PosTagHelper.getGenders(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN);
            if (genders1.matches(".*[" + genders2 + "].*")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTag(tokens[nounAdjPos], PosTagHelper.ADJ_V_NAZ_PATTERN) && CaseGovernmentHelper.hasCaseGovernment(tokens[nounAdjPos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.VERB_ADVP_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 5 && (CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.VERB_ADVP_PATTERN, "v_inf") || tokens[verbPos].getCleanToken().matches("(\u043f\u043e)?\u0457\u0441\u0442\u0438"))) {
            if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTag(tokens[v2pos], Pattern.compile("verb.*:p($|:.*)")) && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile(".*v_naz.*"))) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf")) {
            v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE);
            while (v2pos >= 0 && v2pos >= state.verbPos - 3) {
                if (PosTagHelper.hasPosTag(tokens[v2pos], Pattern.compile("noninfl.&predic.*")) && PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_naz")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                Set<String> cases = CaseGovernmentHelper.getCaseGovernments(tokens[v2pos], ADV_PREDICT_PATTERN);
                if (TokenAgreementPrepNounRule.hasVidmPosTag(cases, state.nounAdjIndirTokenReadings)) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                v2pos = LemmaHelper.tokenSearch(tokens, v2pos - 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE);
            }
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_naz") && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.ADJ_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
            String genders1 = PosTagHelper.getGenders(tokens[nounAdjPos], "(noun|adj|numr).*v_naz.*");
            genders2 = PosTagHelper.getGenders(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN);
            if (genders1.matches(".*[" + genders2 + "].*")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav") || PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_rod") || PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:.:v_naz.*"))) && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.NOUN_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.NOUN_V_NAZ_PATTERN, "v_inf")) {
            if (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav") && LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile(".*\u0432\u0447\u0438\u0442\u0438(\u0441\u044f)?"))) {
                return false;
            }
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && CaseGovernmentHelper.hasCaseGovernment(state.verbAnalyzedTokenReadings, PosTagHelper.VERB_PATTERN, "v_inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 3 && PosTagHelper.hasPosTagPart(tokens[v2pos], ":inf") && TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[verbPos], Pattern.compile("verb.*:p(:.*)?")) && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], ":v_naz")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:.:v_rod(?!.*pron).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 1], Pattern.compile("noun:.*v_rod(?!.*pron).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("(noun|adj)(?!.*pron).*"))) {
            List readings = tokens[nounAdjPos + 2].getReadings();
            List<AnalyzedToken> readingsVnaz = readings.stream().filter(r -> PosTagHelper.hasPosTagPart(r, "v_naz")).collect(Collectors.toList());
            List<VerbInflectionHelper.Inflection> nounAdjNazInflectionsVnaz = VerbInflectionHelper.getNounInflections(readingsVnaz);
            nounAdjNazInflectionsVnaz.addAll(VerbInflectionHelper.getAdjInflections(readingsVnaz));
            List<AnalyzedToken> readingsIndir = readings.stream().filter(r -> !PosTagHelper.hasPosTagPart(r, "v_naz")).collect(Collectors.toList());
            if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[verbPos], nounAdjNazInflectionsVnaz, readingsIndir)) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 2 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagStart(tokens[verbPos - 2], "verb") && (LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u0431", "\u0431\u0438")) || PosTagHelper.hasPosTag(tokens[verbPos - 1], Pattern.compile("adv(?!p).*")) || LemmaHelper.hasLemma(tokens[verbPos - 2], Arrays.asList("\u043c\u0430\u0442\u0438"), "verb"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static boolean agrees(AnalyzedTokenReadings verbTokenReadings, List<VerbInflectionHelper.Inflection> nounAdjNazInflections, List<AnalyzedToken> nounAdjIndirTokenReadings) {
        Set<String> cases;
        List<VerbInflectionHelper.Inflection> verbInflections;
        if (nounAdjNazInflections != null && nounAdjNazInflections.size() > 0 && !Collections.disjoint(verbInflections = VerbInflectionHelper.getVerbInflections(verbTokenReadings.getReadings()), nounAdjNazInflections)) {
            return true;
        }
        return nounAdjIndirTokenReadings.size() > 0 && (cases = CaseGovernmentHelper.getCaseGovernments(verbTokenReadings, PosTagHelper.VERB_ADVP_PATTERN)).size() > 0 && TokenAgreementPrepNounRule.hasVidmPosTag(cases, nounAdjIndirTokenReadings);
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

