/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.uk.InflectionHelper;

class VerbInflectionHelper {
    private static final Pattern VERB_INFLECTION_PATTERN = Pattern.compile(":([mfnps])(:([123])?|$)");
    private static final Pattern NOUN_INFLECTION_PATTERN = Pattern.compile("(?::((?:[iu]n)?anim))?:([mfnps]):(v_naz)");
    private static final Pattern ADJ_INFLECTION_PATTERN = Pattern.compile("(adj|numr):([mfnps]):(v_naz)");
    private static final Pattern NOUN_PERSON_PATTERN = Pattern.compile(":([123])");

    VerbInflectionHelper() {
    }

    static List<Inflection> getVerbInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> verbGenders = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            String posTag = token.getPOSTag();
            if (posTag == null || !posTag.startsWith("verb")) continue;
            if (posTag.contains(":inf")) {
                verbGenders.add(new Inflection("i", null));
                continue;
            }
            if (posTag.contains(":impers")) {
                verbGenders.add(new Inflection("o", null));
                continue;
            }
            Matcher matcher = VERB_INFLECTION_PATTERN.matcher(posTag);
            matcher.find();
            String gen = matcher.group(1);
            String person = matcher.group(3);
            verbGenders.add(new Inflection(gen, person));
        }
        return verbGenders;
    }

    static List<Inflection> getNounInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> slaveInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            Matcher matcher;
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !(matcher = NOUN_INFLECTION_PATTERN.matcher(posTag2)).find()) continue;
            String gen = matcher.group(2);
            Matcher matcherPerson = NOUN_PERSON_PATTERN.matcher(posTag2);
            String person = matcherPerson.find() ? matcherPerson.group(1) : null;
            slaveInflections.add(new Inflection(gen, person));
        }
        return slaveInflections;
    }

    static List<Inflection> getAdjInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> slaveInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            Matcher matcher;
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !(matcher = ADJ_INFLECTION_PATTERN.matcher(posTag2)).find()) continue;
            String gen = matcher.group(2);
            Matcher matcherPerson = NOUN_PERSON_PATTERN.matcher(posTag2);
            String person = matcherPerson.find() ? matcherPerson.group(1) : null;
            slaveInflections.add(new Inflection(gen, person));
        }
        return slaveInflections;
    }

    static boolean inflectionsOverlap(List<AnalyzedToken> verbTokenReadings, List<AnalyzedToken> nounTokenReadings) {
        return !Collections.disjoint(VerbInflectionHelper.getVerbInflections(verbTokenReadings), VerbInflectionHelper.getNounInflections(nounTokenReadings));
    }

    static class Inflection
    implements Comparable<Inflection> {
        final String gender;
        final String plural;
        final String person;

        Inflection(String gender, String person) {
            if (gender.equals("s") || gender.equals("p")) {
                this.gender = null;
                this.plural = gender;
            } else if (gender.equals("i")) {
                this.gender = gender;
                this.plural = gender;
            } else {
                this.gender = gender;
                this.plural = "s";
            }
            this.person = person;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Inflection other = (Inflection)obj;
            if (this.person != null && other.person != null && !this.person.equals(other.person)) {
                return false;
            }
            if (this.gender != null && other.gender != null && !this.gender.equals(other.gender)) {
                return false;
            }
            return this.plural.equals(other.plural);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
            result = 31 * result + (this.plural == null ? 0 : this.plural.hashCode());
            result = 31 * result + (this.person == null ? 0 : this.person.hashCode());
            return result;
        }

        public String toString() {
            return "Gender: " + this.gender + "/" + this.plural + "/" + this.person;
        }

        @Override
        public int compareTo(Inflection o) {
            Integer thisOrder = this.gender != null ? InflectionHelper.GEN_ORDER.get(this.gender) : Integer.valueOf(0);
            Integer otherOrder = o.gender != null ? InflectionHelper.GEN_ORDER.get(o.gender) : Integer.valueOf(0);
            int compared = thisOrder.compareTo(otherOrder);
            return compared;
        }
    }
}

