/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementNounVerbExceptionHelper;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementNounVerbRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementNounVerbRule.class);
    private static final Pattern NOUN_V_NAZ_PATTERN = Pattern.compile("noun.*:v_naz.*");

    public TokenAgreementNounVerbRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_NOUN_VERB_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0442\u0430 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430 \u0437\u0430 \u0440\u043e\u0434\u043e\u043c, \u0447\u0438\u0441\u043b\u043e\u043c \u0442\u0430 \u043e\u0441\u043e\u0431\u043e\u044e";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0437 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e\u043c";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        State state = null;
        block0: for (int i = 1; i < tokens.length; ++i) {
            Object token2;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String cleanToken = tokenReadings.getCleanToken();
            String posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag0 == null) {
                state = null;
                continue;
            }
            if (state == null && i == tokens.length - 1) continue;
            if (PosTagHelper.hasPosTag(tokenReadings, NOUN_V_NAZ_PATTERN) || Arrays.asList("\u044f\u043a\u0430").contains(cleanToken)) {
                state = new State();
                for (Object token2 : tokenReadings) {
                    String nounPosTag = token2.getPOSTag();
                    if (nounPosTag == null) continue;
                    if ("\u044f\u043a\u0438\u0439".equals(token2.getLemma()) && token2.getPOSTag().contains(":f:v_naz")) {
                        state.nounPos = i;
                        state.nounTokenReadings.add((AnalyzedToken)token2);
                        state.nounAnalyzedTokenReadings = tokenReadings;
                        continue;
                    }
                    if (i >= 3 && "\u0445\u0442\u043e".equalsIgnoreCase(cleanToken) && ",".equals(tokens[i - 1].getToken()) && Arrays.asList("\u0442\u0435").contains(((String)StringUtils.defaultIfEmpty((CharSequence)tokens[i - 2].getCleanToken(), (CharSequence)"")).toLowerCase()) && LemmaHelper.tokenSearch(tokens, i + 1, Pattern.compile("verb.*:f\\b.*"), null, Pattern.compile("part"), LemmaHelper.Dir.FORWARD) > 0) {
                        state = null;
                        continue block0;
                    }
                    if (i >= 3 && "\u0445\u0442\u043e".equalsIgnoreCase(cleanToken) && ",".equals(tokens[i - 1].getToken()) && Arrays.asList("\u0442\u0456", "\u0432\u0441\u0456").contains(((String)StringUtils.defaultIfEmpty((CharSequence)tokens[i - 2].getCleanToken(), (CharSequence)"")).toLowerCase()) && LemmaHelper.tokenSearch(tokens, i + 1, Pattern.compile("verb.*:p\\b.*"), null, Pattern.compile("part"), LemmaHelper.Dir.FORWARD) > 0) {
                        state.nounPos = i - 2;
                        state.nounTokenReadings.addAll(PosTagHelper.filter(tokens[i - 2].getReadings(), Pattern.compile("adj.*")));
                        state.nounAnalyzedTokenReadings = tokens[i - 2];
                        continue;
                    }
                    if (nounPosTag.startsWith("noun") && nounPosTag.contains("v_naz")) {
                        state.nounPos = i;
                        state.nounTokenReadings.add((AnalyzedToken)token2);
                        state.nounAnalyzedTokenReadings = tokenReadings;
                        continue;
                    }
                    if (nounPosTag.startsWith("noun") && nounPosTag.contains("v_kly") || PosTagHelper.isPredictOrInsert((AnalyzedToken)token2)) continue;
                    if (token2.getPOSTag().matches("adj:.:(v_naz|v_kly).*") || token2.getPOSTag().startsWith("adj:m:v_zna:rinanim") && !PosTagHelper.hasPosTagStart(tokens[i - 1], "prep") && !Arrays.asList("\u043a\u043e\u0436\u0435\u043d", "\u0456\u043d\u0448\u0438\u0439", "\u0441\u0442\u0430\u0440\u0438\u0439", "\u0447\u0435\u0440\u0433\u043e\u0432\u0438\u0439").contains(token2.getToken().toLowerCase())) {
                        state.adjTokenReadings.add((AnalyzedToken)token2);
                        continue;
                    }
                    state = null;
                    continue block0;
                }
                continue;
            }
            if (state == null || Arrays.asList("\u043d\u0435", "\u0431", "\u0431\u0438", "\u0431\u043e\u0434\u0430\u0439").contains(tokenReadings.getToken()) || PosTagHelper.hasPosTagPartAll(tokenReadings, "adv")) continue;
            ArrayList<AnalyzedToken> verbTokenReadings = new ArrayList<AnalyzedToken>();
            token2 = tokenReadings.iterator();
            while (token2.hasNext()) {
                AnalyzedToken token3 = (AnalyzedToken)token2.next();
                String verbPosTag = token3.getPOSTag();
                if (verbPosTag == null || verbPosTag.equals("SENT_END") || verbPosTag.equals("PARA_END")) continue;
                if (verbPosTag.startsWith("<")) {
                    verbTokenReadings.clear();
                    break;
                }
                if (verbPosTag.startsWith("verb")) {
                    verbTokenReadings.add(token3);
                    continue;
                }
                if (PosTagHelper.isPredictOrInsert(token3)) continue;
                verbTokenReadings.clear();
                break;
            }
            if (verbTokenReadings.isEmpty()) {
                state = null;
                continue;
            }
            logger.debug("=== Checking\n\t{}\n\t{}", state.nounTokenReadings, verbTokenReadings);
            List<VerbInflectionHelper.Inflection> masterInflections = VerbInflectionHelper.getNounInflections(state.nounTokenReadings);
            List<VerbInflectionHelper.Inflection> slaveInflections = VerbInflectionHelper.getVerbInflections(verbTokenReadings);
            logger.debug("\t\t{}\n\t{}", masterInflections, slaveInflections);
            if (Collections.disjoint(masterInflections, slaveInflections)) {
                if (TokenAgreementNounVerbExceptionHelper.isException(tokens, state.nounPos, i, masterInflections, slaveInflections, state.nounTokenReadings, verbTokenReadings)) {
                    state.nounTokenReadings.clear();
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(MessageFormat.format("=== Found noun/verb mismatch\n\t{0}\n\t{1}", state.nounAnalyzedTokenReadings.getToken() + ": " + masterInflections + " // " + state.nounAnalyzedTokenReadings, ((AnalyzedToken)verbTokenReadings.get(0)).getToken() + ": " + slaveInflections + " // " + verbTokenReadings));
                }
                String msg = String.format("\u041d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043e %s \u0437 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e\u043c: \"%s\" (%s) \u0456 \"%s\" (%s)", LemmaHelper.hasLemma(state.nounTokenReadings, Arrays.asList("\u044f\u043a\u0438\u0439")) ? "\u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a" : "\u0456\u043c\u0435\u043d\u043d\u0438\u043a", state.nounTokenReadings.get(0).getToken(), TokenAgreementNounVerbRule.formatInflections(masterInflections, true), ((AnalyzedToken)verbTokenReadings.get(0)).getToken(), TokenAgreementNounVerbRule.formatInflections(slaveInflections, false));
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, state.nounAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                ruleMatches.add(potentialRuleMatch);
            }
            state = null;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static String formatInflections(List<VerbInflectionHelper.Inflection> inflections, boolean noun) {
        Collections.sort(inflections);
        ArrayList<String> list = new ArrayList<String>();
        for (VerbInflectionHelper.Inflection inflection : inflections) {
            String str = "";
            if (inflection.gender != null) {
                str = PosTagHelper.GENDER_MAP.get(inflection.gender);
            } else {
                if (inflection.person != null) {
                    str = PosTagHelper.PERSON_MAP.get(inflection.person);
                }
                if (inflection.plural != null) {
                    if (str.length() > 0) {
                        str = str + " ";
                    }
                    str = str + PosTagHelper.GENDER_MAP.get(inflection.plural);
                }
            }
            list.add(str);
        }
        LinkedHashSet uniqeList = new LinkedHashSet(list);
        return StringUtils.join(uniqeList, (String)", ");
    }

    private static class State {
        int nounPos;
        List<AnalyzedToken> nounTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings nounAnalyzedTokenReadings = null;
        List<AnalyzedToken> adjTokenReadings = new ArrayList<AnalyzedToken>();

        private State() {
        }
    }
}

