/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.TaggedWord;

public final class PosTagHelper {
    private static final Pattern NUM_REGEX = Pattern.compile("(noun:(?:in)?anim|numr|adj|adjp.*):(.):v_.*");
    private static final Pattern CONJ_REGEX = Pattern.compile("(noun:(?:in)?anim|numr|adj|adjp.*):[mfnp]:(v_...).*");
    private static final Pattern GENDER_REGEX = NUM_REGEX;
    private static final Pattern GENDER_CONJ_REGEX = Pattern.compile("(noun:(?:in)?anim|adj|numr|adjp.*):(.:v_...).*");
    public static final Pattern ADJ_COMP_REGEX = Pattern.compile(":comp[bcs]");
    public static final Map<String, String> VIDMINKY_MAP;
    public static final Map<String, String> GENDER_MAP;
    public static final List<String> BASE_GENDERS;
    public static final Map<String, String> PERSON_MAP;
    public static final String NO_VIDMINOK_SUBSTR = ":nv";
    public static final Pattern NOUN_V_NAZ_PATTERN;
    public static final Pattern ADJ_V_NAZ_PATTERN;
    public static final Pattern VERB_INF_PATTERN;
    public static final Pattern ADJ_V_KLY_PATTERN;
    private static Pattern WORD_PATTERN;
    private static Pattern PREDICT_INSERT_PATTERN;

    private PosTagHelper() {
    }

    @Nullable
    public static String getGender(String posTag) {
        Matcher pos4matcher = GENDER_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static String getNum(String posTag) {
        Matcher pos4matcher = NUM_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            String group = pos4matcher.group(2);
            if (!group.equals("p")) {
                group = "s";
            }
            return group;
        }
        return null;
    }

    @Nullable
    public static String getConj(String posTag) {
        Matcher pos4matcher = CONJ_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    @Nullable
    public static String getGenderConj(String posTag) {
        Matcher pos4matcher = GENDER_CONJ_REGEX.matcher(posTag);
        if (pos4matcher.matches()) {
            return pos4matcher.group(2);
        }
        return null;
    }

    public static boolean hasPosTag(AnalyzedTokenReadings analyzedTokenReadings, Pattern posTagRegex) {
        return PosTagHelper.hasPosTag((Collection<AnalyzedToken>)analyzedTokenReadings.getReadings(), posTagRegex);
    }

    public static boolean hasPosTag(AnalyzedTokenReadings analyzedTokenReadings, String posTagRegex) {
        return PosTagHelper.hasPosTag((Collection<AnalyzedToken>)analyzedTokenReadings.getReadings(), posTagRegex);
    }

    public static boolean hasPosTag(Collection<AnalyzedToken> analyzedTokenReadings, Pattern posTagRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (!PosTagHelper.hasPosTag(analyzedToken, posTagRegex)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTag(Collection<AnalyzedToken> analyzedTokenReadings, String posTagRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (!PosTagHelper.hasPosTag(analyzedToken, posTagRegex)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTag(AnalyzedToken analyzedToken, String posTagRegex) {
        String posTag = analyzedToken.getPOSTag();
        return posTag != null && posTag.matches(posTagRegex);
    }

    public static boolean hasPosTagPart(AnalyzedToken analyzedToken, String posTagPart) {
        String posTag = analyzedToken.getPOSTag();
        return posTag != null && posTag.contains(posTagPart);
    }

    public static boolean hasPosTag(AnalyzedToken analyzedToken, Pattern posTagRegex) {
        String posTag = analyzedToken.getPOSTag();
        return posTag != null && posTagRegex.matcher(posTag).matches();
    }

    public static boolean hasPosTag(TaggedWord analyzedToken, Pattern posTagRegex) {
        String posTag = analyzedToken.getPosTag();
        return posTag != null && posTagRegex.matcher(posTag).matches();
    }

    public static boolean hasPosTagPart(AnalyzedTokenReadings analyzedTokenReadings, String posTagPart) {
        return PosTagHelper.hasPosTagPart(analyzedTokenReadings.getReadings(), posTagPart);
    }

    public static boolean hasPosTagPart(List<AnalyzedToken> analyzedTokenReadings, String posTagPart) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().contains(posTagPart)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTagPartAll(AnalyzedTokenReadings analyzedTokenReadings, String posTagPart) {
        return PosTagHelper.hasPosTagPartAll(analyzedTokenReadings.getReadings(), posTagPart);
    }

    public static boolean hasPosTagPartAll(List<AnalyzedToken> analyzedTokenReadings, String posTagPart) {
        boolean foundTag = false;
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (analyzedToken.getPOSTag() == null || analyzedToken.getPOSTag().equals("SENT_END") || analyzedToken.getPOSTag().equals("PARA_END")) continue;
            if (!analyzedToken.getPOSTag().contains(posTagPart)) {
                return false;
            }
            if (foundTag) continue;
            foundTag = analyzedToken.getPOSTag().contains(posTagPart);
        }
        return foundTag;
    }

    public static boolean hasPosTagStart(AnalyzedTokenReadings analyzedTokenReadings, String posTagPart) {
        return PosTagHelper.hasPosTagStart(analyzedTokenReadings.getReadings(), posTagPart);
    }

    public static boolean hasPosTagStart(List<AnalyzedToken> analyzedTokenReadings, String posTagPart) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            if (!PosTagHelper.hasPosTagStart(analyzedToken, posTagPart)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTagStart(AnalyzedToken analyzedToken, String posTagPart) {
        return analyzedToken.getPOSTag() != null && analyzedToken.getPOSTag().startsWith(posTagPart);
    }

    public static boolean hasPosTagPart2(List<TaggedWord> taggedWords, String posTagPart) {
        for (TaggedWord analyzedToken : taggedWords) {
            if (analyzedToken.getPosTag() == null || !analyzedToken.getPosTag().contains(posTagPart)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTag2(List<TaggedWord> taggedWords, Pattern pattern) {
        for (TaggedWord analyzedToken : taggedWords) {
            if (analyzedToken.getPosTag() == null || !pattern.matcher(analyzedToken.getPosTag()).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPosTagStart2(List<TaggedWord> taggedWords, String posTagPart) {
        for (TaggedWord analyzedToken : taggedWords) {
            if (analyzedToken.getPosTag() == null || !analyzedToken.getPosTag().startsWith(posTagPart)) continue;
            return true;
        }
        return false;
    }

    public static String getGenders(AnalyzedTokenReadings tokenReadings, String posTagRegex) {
        Pattern posTagPattern = Pattern.compile(posTagRegex);
        StringBuilder sb = new StringBuilder(4);
        for (AnalyzedToken tokenReading : tokenReadings) {
            String gender;
            String posTag = tokenReading.getPOSTag();
            if (posTag == null || !posTagPattern.matcher(posTag).matches() || sb.indexOf(gender = PosTagHelper.getGender(posTag)) != -1) continue;
            sb.append(gender);
        }
        return sb.toString();
    }

    @NotNull
    public static List<AnalyzedToken> generateTokensForNv(String word, String genders, String extraTags) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        for (char gen : genders.toCharArray()) {
            String posTagBase = "noun:inanim:" + gen + ":";
            for (String vidm : VIDMINKY_MAP.keySet()) {
                if (vidm.equals("v_kly")) continue;
                String posTag = posTagBase + vidm + NO_VIDMINOK_SUBSTR;
                if (extraTags != null) {
                    posTag = posTag + extraTags;
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
            }
        }
        return newAnalyzedTokens;
    }

    @NotNull
    public static String addIfNotContains(@NotNull String tag, @Nullable String addTag) {
        if (StringUtils.isNotEmpty((CharSequence)addTag) && !tag.contains(addTag)) {
            return tag + addTag;
        }
        return tag;
    }

    @NotNull
    public static String addIfNotContains(@NotNull String tag, String ... addTags) {
        for (String addTag : addTags) {
            if (tag.contains(addTag)) continue;
            tag = tag + addTag;
        }
        return tag;
    }

    @NotNull
    public static List<TaggedWord> addIfNotContains(@NotNull List<TaggedWord> taggedWords, @NotNull String addTag) {
        return PosTagHelper.addIfNotContains(taggedWords, addTag, null);
    }

    @NotNull
    public static List<TaggedWord> addIfNotContains(@NotNull List<TaggedWord> taggedWords, @NotNull String addTag, @Nullable String lemma) {
        return taggedWords.stream().map(w -> new TaggedWord(lemma != null ? lemma : w.getLemma(), PosTagHelper.addIfNotContains(w.getPosTag(), addTag))).collect(Collectors.toList());
    }

    @NotNull
    public static List<TaggedWord> adjust(@NotNull List<TaggedWord> taggedWords, @Nullable String lemmaPrefix, @Nullable String lemmaSuffix, String ... addTags) {
        return taggedWords.stream().map(w -> new TaggedWord(PosTagHelper.adjustLemma(w, lemmaPrefix, lemmaSuffix), PosTagHelper.addIfNotContains(PosTagHelper.cleanExtraTags(w.getPosTag()), addTags))).collect(Collectors.toList());
    }

    private static String adjustLemma(TaggedWord w, String lemmaPrefix, String lemmaSuffix) {
        String lemma = w.getLemma();
        if (lemmaPrefix != null) {
            lemma = lemmaPrefix + lemma;
        }
        if (lemmaSuffix != null) {
            lemma = lemma + lemmaSuffix;
        }
        return lemma;
    }

    private static String cleanExtraTags(String tag) {
        if (tag != null) {
            tag = tag.replaceAll(":(comp.|&&?adjp:.*?(:(im)?perf)+)", "");
        }
        return tag;
    }

    public static List<AnalyzedToken> filter(List<AnalyzedToken> analyzedTokens, Pattern posTag) {
        return analyzedTokens.stream().filter(token -> PosTagHelper.hasPosTag(token, posTag)).collect(Collectors.toList());
    }

    public static List<TaggedWord> filter2(List<TaggedWord> analyzedTokens, Pattern posTag) {
        return analyzedTokens.stream().filter(token -> PosTagHelper.hasPosTag(token, posTag)).collect(Collectors.toList());
    }

    public static List<TaggedWord> filter2Negative(List<TaggedWord> analyzedTokens, Pattern posTag) {
        return analyzedTokens.stream().filter(token -> !PosTagHelper.hasPosTag(token, posTag)).collect(Collectors.toList());
    }

    public static boolean isUnknownWord(AnalyzedTokenReadings analyzedTokenReadings) {
        return analyzedTokenReadings.getAnalyzedToken(0).hasNoTag() && WORD_PATTERN.matcher(analyzedTokenReadings.getToken()).matches();
    }

    public static boolean isPredictOrInsert(AnalyzedToken token) {
        return PREDICT_INSERT_PATTERN.matcher(token.getPOSTag()).matches();
    }

    public static boolean hasPosTagAndToken(AnalyzedTokenReadings tokens, Pattern postag, Pattern token) {
        return tokens.getReadings().stream().anyMatch(t -> t.getPOSTag() != null && postag.matcher(t.getPOSTag()).matches() && t.getToken() != null && token.matcher(t.getToken()).matches());
    }

    public static boolean hasMaleUA(AnalyzedTokenReadings tokenReadings) {
        return PosTagHelper.hasPosTagAndToken(tokenReadings, Pattern.compile("noun:inanim:m:v_dav(?!:nv).*"), Pattern.compile(".*[\u0443\u044e]"));
    }

    static {
        BASE_GENDERS = Arrays.asList("m", "f", "n", "p");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("v_naz", "\u043d\u0430\u0437\u0438\u0432\u043d\u0438\u0439");
        map.put("v_rod", "\u0440\u043e\u0434\u043e\u0432\u0438\u0439");
        map.put("v_dav", "\u0434\u0430\u0432\u0430\u043b\u044c\u043d\u0438\u0439");
        map.put("v_zna", "\u0437\u043d\u0430\u0445\u0456\u0434\u043d\u0438\u0439");
        map.put("v_oru", "\u043e\u0440\u0443\u0434\u043d\u0438\u0439");
        map.put("v_mis", "\u043c\u0456\u0441\u0446\u0435\u0432\u0438\u0439");
        map.put("v_kly", "\u043a\u043b\u0438\u0447\u043d\u0438\u0439");
        VIDMINKY_MAP = Collections.unmodifiableMap(map);
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
        map2.put("m", "\u0447.\u0440.");
        map2.put("f", "\u0436.\u0440.");
        map2.put("n", "\u0441.\u0440.");
        map2.put("p", "\u043c\u043d.");
        map2.put("s", "\u043e\u0434\u043d.");
        map2.put("i", "\u0456\u043d\u0444.");
        map2.put("o", "\u0431\u0435\u0437\u043e\u0441. \u0444\u043e\u0440\u043c\u0430");
        GENDER_MAP = Collections.unmodifiableMap(map2);
        LinkedHashMap<String, String> map3 = new LinkedHashMap<String, String>();
        map3.put("1", "1-\u0430 \u043e\u0441\u043e\u0431\u0430");
        map3.put("2", "2-\u0430 \u043e\u0441\u043e\u0431\u0430");
        map3.put("3", "3-\u044f \u043e\u0441\u043e\u0431\u0430");
        map3.put("s", "\u043e\u0434\u043d.");
        map3.put("p", "\u043c\u043d.");
        PERSON_MAP = Collections.unmodifiableMap(map3);
        NOUN_V_NAZ_PATTERN = Pattern.compile("noun.*:v_naz.*");
        ADJ_V_NAZ_PATTERN = Pattern.compile("adj:.:v_naz.*");
        VERB_INF_PATTERN = Pattern.compile("verb.*:inf.*");
        ADJ_V_KLY_PATTERN = Pattern.compile("adj:.:v_kly.*");
        WORD_PATTERN = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u0491a-z'-]+", 66);
        PREDICT_INSERT_PATTERN = Pattern.compile("noninfl:&(predic|insert).*");
    }
}

