/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementAdjNounRule
extends Rule {
    static final List<String> FAKE_FEM_LIST = Arrays.asList("\u0441\u0442\u0443\u043f\u0456\u043d\u044c", "\u0441\u0442\u0435\u043f\u0456\u043d\u044c", "\u043f\u0440\u043e\u0434\u0430\u0436", "\u0441\u043e\u0431\u0430\u043a\u0430", "\u0434\u0440\u0456\u0431", "\u044f\u0440\u043c\u0430\u0440\u043e\u043a", "\u043d\u0435\u0436\u0438\u0442\u044c", "\u0440\u0443\u043a\u043e\u043f\u0438\u0441", "\u043d\u0430\u043a\u0438\u043f", "\u043d\u0430\u0441\u0438\u043f", "\u043f\u0443\u0442\u044c");
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementAdjNounRule.class);
    static final Pattern ADJ_INFLECTION_PATTERN = Pattern.compile(":([mfnp]):(v_...)(:r(in)?anim)?");
    static final Pattern NOUN_INFLECTION_PATTERN = Pattern.compile("((?:[iu]n)?anim):([mfnps]):(v_...)");
    private final Ukrainian ukrainian = new Ukrainian();

    public TokenAgreementAdjNounRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_ADJ_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0456\u0432, \u0440\u043e\u0434\u0443 \u0456 \u0447\u0438\u0441\u043b\u0430 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        State state = new State();
        block2: for (int i = 1; i < tokens.length; ++i) {
            Iterator token2;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag0 == null) {
                state.reset();
                continue;
            }
            if (!state.isEmpty() ? !(!PosTagHelper.hasPosTagPartAll(tokenReadings, "adv") && !Arrays.asList("\u0434\u0443\u0436\u0435", "\u043d\u0435\u0431\u0430\u0433\u0430\u0442\u043e", "\u0431\u0430\u0433\u0430\u0442\u043e").contains(tokenReadings.getCleanToken()) || i < tokens.length - 1 && PosTagHelper.hasPosTagStart(tokens[i], "prep") && TokenAgreementPrepNounRule.hasVidmPosTag(CaseGovernmentHelper.getCaseGovernments(tokens[i], IPOSTag.prep.name()), tokens[i + 1])) && PosTagHelper.hasPosTagPart(state.adjTokenReadings, "adjp") : i == tokens.length - 1) continue;
            if (PosTagHelper.hasPosTagStart(tokens[i], "adj")) {
                state.reset();
                if (PosTagHelper.hasPosTagPart(tokens[i], ":nv") || PosTagHelper.hasPosTagPart(tokens[i], "&pron") || PosTagHelper.hasPosTagPart(tokens[i], "<")) continue;
                if (LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u043f\u043e\u0434\u0456\u0431\u043d\u0438\u0439"), ":n:")) {
                    state.reset();
                    break;
                }
                for (Iterator token2 : tokenReadings) {
                    String adjPosTag = token2.getPOSTag();
                    if (adjPosTag == null) continue;
                    if (adjPosTag.startsWith("adj")) {
                        state.adjPos = i;
                        state.adjTokenReadings.add((AnalyzedToken)token2);
                        state.adjAnalyzedTokenReadings = tokenReadings;
                        continue;
                    }
                    if (LemmaHelper.hasLemma(tokenReadings, Arrays.asList("\u0434\u0440\u0443\u0433\u0438\u0439"), "adj:f:") && (i + 1 >= tokens.length || LemmaHelper.hasLemma(tokens[i + 1], FAKE_FEM_LIST, "noun:inanim:m:") || PosTagHelper.isPredictOrInsert((AnalyzedToken)token2))) continue;
                    state.reset();
                    continue block2;
                }
                continue;
            }
            if (state.isEmpty()) continue;
            if (PosTagHelper.hasPosTagPart(tokens[i], ":nv") || PosTagHelper.hasPosTagPart(tokens[i], "&pron") || PosTagHelper.hasPosTagPart(tokens[i], "<")) {
                state.reset();
                continue;
            }
            ArrayList<AnalyzedToken> nounTokenReadings = new ArrayList<AnalyzedToken>();
            token2 = tokenReadings.iterator();
            while (token2.hasNext()) {
                AnalyzedToken token3 = (AnalyzedToken)token2.next();
                String nounPosTag = token3.getPOSTag();
                if (nounPosTag == null) continue;
                if (nounPosTag.startsWith("noun") && !nounPosTag.contains(":nv")) {
                    nounTokenReadings.add(token3);
                    continue;
                }
                if (nounPosTag.equals("SENT_END") || nounPosTag.equals("PARA_END") || PosTagHelper.isPredictOrInsert(token3)) continue;
                nounTokenReadings.clear();
                break;
            }
            if (nounTokenReadings.isEmpty()) {
                state.reset();
                continue;
            }
            logger.debug("=== Checking:\n\t{}\n\t{}", state.adjTokenReadings, nounTokenReadings);
            List<InflectionHelper.Inflection> masterInflections = InflectionHelper.getAdjInflections(state.adjTokenReadings);
            List<InflectionHelper.Inflection> slaveInflections = InflectionHelper.getNounInflections(nounTokenReadings, "v_zna:var");
            if (Collections.disjoint(masterInflections, slaveInflections)) {
                if (TokenAgreementAdjNounExceptionHelper.isException(tokens, state.adjPos, i, masterInflections, slaveInflections, state.adjTokenReadings, nounTokenReadings)) {
                    state.reset();
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(MessageFormat.format("=== Found:\n\t{0}\n\t", state.adjAnalyzedTokenReadings.getToken() + ": " + masterInflections + " // " + state.adjAnalyzedTokenReadings, ((AnalyzedToken)nounTokenReadings.get(0)).getToken() + ": " + slaveInflections + " // " + nounTokenReadings));
                }
                String msg = String.format("\u041f\u043e\u0442\u0435\u043d\u0446\u0456\u0439\u043d\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430: \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a \u043d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u0438\u0439 \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c: \"%s\": [%s] \u0456 \"%s\": [%s]", state.adjTokenReadings.get(0).getToken(), TokenAgreementAdjNounRule.formatInflections(masterInflections, true), ((AnalyzedToken)nounTokenReadings.get(0)).getToken(), TokenAgreementAdjNounRule.formatInflections(slaveInflections, false));
                if (PosTagHelper.hasPosTagPart(state.adjTokenReadings, ":m:v_rod") && tokens[i].getToken().matches(".*[\u0443\u044e]") && PosTagHelper.hasPosTag(nounTokenReadings, "noun.*?:m:v_dav.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0432\u0436\u0438\u0442\u043e \u043d\u0435\u0432\u043d\u043e\u0440\u043c\u043e\u0432\u0430\u043d\u0438\u0439 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0447.\u0440. \u0437 \u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u043d\u044f\u043c -\u0443/-\u044e \u0437\u0430\u043c\u0456\u0441\u0442\u044c -\u0430/-\u044f (\u0442\u0430\u043a\u0430 \u0442\u0435\u043d\u0434\u0435\u043d\u0446\u0456\u044f \u0454 \u0432 \u0441\u0443\u0447\u0430\u0441\u043d\u0456\u0439 \u043c\u043e\u0432\u0456)?";
                } else if (state.adjAnalyzedTokenReadings.getToken().contains("-") && Pattern.compile(".*([23]-\u0454|[02-9]-\u0430|[0-9]-\u043c\u0430)").matcher(state.adjAnalyzedTokenReadings.getToken()).matches()) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0432\u0436\u0438\u0442\u043e \u0437\u0430\u0439\u0432\u0435 \u043b\u0456\u0442\u0435\u0440\u043d\u0435 \u043d\u0430\u0440\u043e\u0449\u0435\u043d\u043d\u044f \u043f\u0456\u0441\u043b\u044f \u043a\u0456\u043b\u044c\u043a\u0456\u0441\u043d\u043e\u0433\u043e \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a\u0430?";
                } else if (state.adjAnalyzedTokenReadings.getToken().startsWith("\u043d\u0435") && PosTagHelper.hasPosTag(nounTokenReadings, "noun.*?:v_oru.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0442\u0443\u0442 \u00ab\u043d\u0435\u00bb \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u043e\u043a\u0440\u0435\u043c\u043e?";
                } else if (!PosTagHelper.hasPosTag(state.adjTokenReadings, "adj.*?v_mis.*") && PosTagHelper.hasPosTag(nounTokenReadings, "noun.*?v_mis.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043e \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u043d\u0430/\u0432/\u0443...?";
                }
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, state.adjAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                Synthesizer ukrainianSynthesizer = this.ukrainian.getSynthesizer();
                ArrayList<String> suggestions = new ArrayList<String>();
                try {
                    String suggestion;
                    String[] synthesized;
                    String vidmTag;
                    String genderTag;
                    for (InflectionHelper.Inflection adjInflection : masterInflections) {
                        genderTag = ":" + adjInflection.gender + ":";
                        vidmTag = adjInflection._case;
                        if (adjInflection._case.equals("v_kly") || !adjInflection.gender.equals("p") && !PosTagHelper.hasPosTagPart(nounTokenReadings, genderTag)) continue;
                        for (AnalyzedToken nounToken : nounTokenReadings) {
                            if (adjInflection.animMatters() && !nounToken.getPOSTag().contains(":" + adjInflection.animTag)) continue;
                            String newNounPosTag = nounToken.getPOSTag().replaceFirst(":.:v_...", genderTag + vidmTag);
                            for (String s : synthesized = ukrainianSynthesizer.synthesize(nounToken, newNounPosTag, false)) {
                                suggestion = state.adjAnalyzedTokenReadings.getToken() + " " + s;
                                if (suggestions.contains(suggestion)) continue;
                                suggestions.add(suggestion);
                            }
                        }
                    }
                    for (InflectionHelper.Inflection nounInflection : slaveInflections) {
                        genderTag = ":" + nounInflection.gender + ":";
                        vidmTag = nounInflection._case;
                        if (nounInflection.animMatters()) {
                            vidmTag = vidmTag + ":r" + nounInflection.animTag;
                        }
                        for (AnalyzedToken adjToken : state.adjTokenReadings) {
                            String newAdjTag = adjToken.getPOSTag().replaceFirst(":.:v_...(:r(in)?anim)?", genderTag + vidmTag);
                            for (String s : synthesized = ukrainianSynthesizer.synthesize(adjToken, newAdjTag, false)) {
                                suggestion = s + " " + tokenReadings.getToken();
                                if (suggestions.contains(suggestion)) continue;
                                suggestions.add(suggestion);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (suggestions.size() > 0) {
                    potentialRuleMatch.setSuggestedReplacements(suggestions);
                }
                ruleMatches.add(potentialRuleMatch);
            }
            state.reset();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static String formatInflections(List<InflectionHelper.Inflection> inflections, boolean adj) {
        Collections.sort(inflections);
        LinkedHashMap map = new LinkedHashMap();
        for (InflectionHelper.Inflection inflection : inflections) {
            if (!map.containsKey(inflection.gender)) {
                map.put(inflection.gender, new ArrayList());
            }
            String caseStr = PosTagHelper.VIDMINKY_MAP.get(inflection._case);
            if (adj && inflection.animTag != null) {
                caseStr = caseStr + " (" + (inflection.animTag.equals("anim") ? "\u0456\u0441\u0442." : "\u043d\u0435\u0456\u0441\u0442.") + ")";
            }
            ((List)map.get(inflection.gender)).add(caseStr);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String genderStr = PosTagHelper.GENDER_MAP.get(entry.getKey());
            List caseValues = (List)entry.getValue();
            list.add(genderStr + ": " + StringUtils.join((Iterable)caseValues, (String)", "));
        }
        return StringUtils.join(list, (String)", ");
    }

    private static class State {
        int adjPos;
        List<AnalyzedToken> adjTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings adjAnalyzedTokenReadings = null;

        private State() {
        }

        public boolean isEmpty() {
            return this.adjTokenReadings.isEmpty();
        }

        public void reset() {
            this.adjTokenReadings.clear();
            this.adjAnalyzedTokenReadings = null;
        }
    }
}

