/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.tagging.uk.PosTagHelper;

public class SimpleReplaceSpelling1992Rule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> WRONG_WORDS = SimpleReplaceSpelling1992Rule.loadFromPath((String)"/uk/replace_spelling_2019.txt");
    private static final Map<String, String> dashPrefixes1992 = ExtraDictionaryLoader.loadMap("/uk/dash_prefixes.txt");

    protected Map<String, List<String>> getWrongWords() {
        return WRONG_WORDS;
    }

    public SimpleReplaceSpelling1992Rule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE_SPELLING_1992";
    }

    public String getDescription() {
        return "\u041f\u043e\u0448\u0443\u043a \u0441\u043b\u0456\u0432, \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0445 \u0437\u0430 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u043e\u043c 1992";
    }

    public String getShort() {
        return "\u0421\u043b\u043e\u0432\u043e, \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0435 \u0437\u0430 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u043e\u043c 1992";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        RuleMatch[] match = super.match(sentence);
        if (match.length == 0) {
            match = this.findTagged1922(sentence);
        }
        return match;
    }

    private RuleMatch[] findTagged1922(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String[] parts;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            if (!PosTagHelper.hasPosTagPartAll(tokenReadings, "ua_1992")) continue;
            RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getEndPos(), this.getShort(), this.getShort());
            String token = tokenReadings.getToken();
            if (token.contains("-") && (parts = token.split("-", 2)).length > 1 && dashPrefixes1992.containsKey(parts[0])) {
                potentialRuleMatch.addSuggestedReplacement(token.substring(0, parts[0].length()) + token.substring(parts[0].length() + 1));
            }
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "\u00ab" + tokenStr + "\u00bb \u2014 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u043d\u044f \u043d\u0435 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0454 \u0447\u0438\u043d\u043d\u0456\u0439 \u0432\u0435\u0440\u0441\u0456\u0457 \u043f\u0440\u0430\u0432\u043e\u043f\u0438\u0441\u0443, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: " + StringUtils.join(replacements, (String)",") + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    static {
        dashPrefixes1992.entrySet().removeIf(entry -> !((String)entry.getValue()).equals(":ua_1992"));
    }
}

