/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounExceptionHelper;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;

public class TokenAgreementPrepNounRule
extends Rule {
    private static final List<String> Z_ZI_IZ = Arrays.asList("\u0437", "\u0437\u0456", "\u0456\u0437");
    private static final Pattern NOUN_ANIM_V_NAZ_PATTERN = Pattern.compile("noun:anim:.:v_naz.*");
    private static final String VIDMINOK_SUBSTR = ":v_";
    private static final Pattern VIDMINOK_REGEX = Pattern.compile(":(v_[a-z]+)");
    private static final String reqAnimInanimRegex = ":r(?:in)?anim";
    private static final Pattern REQ_ANIM_INANIM_PATTERN = Pattern.compile(":r(?:in)?anim");
    private final Ukrainian ukrainian = new Ukrainian();

    public TokenAgreementPrepNounRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_PREP_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u0456";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        AnalyzedTokenReadings prepTokenReadings = null;
        block16: for (int i = 1; i < tokens.length; ++i) {
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag == null || posTag.contains(IPOSTag.unknown.getText())) {
                prepTokenReadings = null;
                continue;
            }
            String thisToken = tokenReadings.getToken();
            if (i > 1 && thisToken.length() == 1 && Character.isUpperCase(thisToken.charAt(0)) && tokenReadings.isWhitespaceBefore() && tokens[i - 1].getToken().matches(".*[\u0430-\u044f\u0456\u0457\u0454\u04910-9]")) {
                prepTokenReadings = null;
                continue;
            }
            AnalyzedToken multiwordReqToken = TokenAgreementPrepNounRule.getMultiwordToken(tokenReadings);
            if (multiwordReqToken != null) {
                if (Z_ZI_IZ.contains(tokenReadings.getCleanToken().toLowerCase()) && multiwordReqToken.getLemma().startsWith("\u0437\u0433\u0456\u0434\u043d\u043e ")) {
                    posTag = multiwordReqToken.getPOSTag();
                    prepTokenReadings = tokenReadings;
                    continue;
                }
                if (posTag.startsWith(IPOSTag.prep.name())) {
                    prepTokenReadings = null;
                    continue;
                }
                String mwPosTag = multiwordReqToken.getPOSTag();
                if (mwPosTag.contains("adv") || mwPosTag.contains("insert")) continue;
                prepTokenReadings = null;
                continue;
            }
            String token = tokenReadings.getCleanToken();
            if (posTag.startsWith(IPOSTag.prep.name())) {
                String prep = token.toLowerCase();
                if (prep.equals("\u0437\u0430") && LemmaHelper.reverseSearch(tokens, i, 4, Pattern.compile("\u0449\u043e"), null)) {
                    prepTokenReadings = null;
                    continue;
                }
                if (prep.equals("\u043f\u043e\u043d\u0430\u0434")) continue;
                if (prep.equals("\u0448\u043b\u044f\u0445\u043e\u043c") || prep.equals("\u043e\u0434")) {
                    prepTokenReadings = null;
                    continue;
                }
                if (tokens.length > i + 1 && (prep.equals("\u043e\u043a\u0440\u0456\u043c") || prep.equals("\u043a\u0440\u0456\u043c")) && tokens[i + 1].getToken().equalsIgnoreCase("\u044f\u043a")) {
                    prepTokenReadings = null;
                    continue;
                }
                prepTokenReadings = tokenReadings;
                continue;
            }
            if (prepTokenReadings == null) continue;
            LinkedHashSet<String> posTagsToFind = new LinkedHashSet<String>();
            String prep = prepTokenReadings.getAnalyzedToken(0).getLemma();
            if (prep.equalsIgnoreCase("\u0437\u0430\u043c\u0456\u0441\u0442\u044c")) {
                posTagsToFind.add("v_naz");
            }
            Set<String> expectedCases = CaseGovernmentHelper.getCaseGovernments(prepTokenReadings, IPOSTag.prep.name());
            if (Z_ZI_IZ.contains(prep.toLowerCase()) && i >= 3 && tokens[i - 2].getCleanToken().equalsIgnoreCase("\u0437\u0433\u0456\u0434\u043d\u043e")) {
                expectedCases = new HashSet<String>(Arrays.asList("v_oru"));
            }
            expectedCases.remove("v_inf");
            posTagsToFind.addAll(expectedCases);
            TokenAgreementPrepNounExceptionHelper.RuleException exception = TokenAgreementPrepNounExceptionHelper.getExceptionStrong(tokens, i, prepTokenReadings, posTagsToFind);
            switch (exception.type) {
                case exception: {
                    prepTokenReadings = null;
                    continue block16;
                }
                case skip: {
                    i += exception.skip;
                    continue block16;
                }
                default: {
                    if (PosTagHelper.hasPosTagPart(tokenReadings, VIDMINOK_SUBSTR)) {
                        if (TokenAgreementPrepNounRule.hasVidmPosTag(posTagsToFind, tokenReadings)) {
                            prepTokenReadings = null;
                            continue block16;
                        }
                        exception = TokenAgreementPrepNounExceptionHelper.getExceptionNonInfl(tokens, i, prepTokenReadings, posTagsToFind);
                        switch (exception.type) {
                            case exception: {
                                prepTokenReadings = null;
                                continue block16;
                            }
                            case skip: {
                                i += exception.skip;
                                continue block16;
                            }
                        }
                        exception = TokenAgreementPrepNounExceptionHelper.getExceptionInfl(tokens, i, prepTokenReadings, posTagsToFind);
                        switch (exception.type) {
                            case exception: {
                                prepTokenReadings = null;
                                continue block16;
                            }
                            case skip: {
                                i += exception.skip;
                                continue block16;
                            }
                        }
                        RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, prepTokenReadings, posTagsToFind, sentence, tokens, i);
                        ruleMatches.add(potentialRuleMatch);
                    } else {
                        exception = TokenAgreementPrepNounExceptionHelper.getExceptionNonInfl(tokens, i, prepTokenReadings, posTagsToFind);
                        switch (exception.type) {
                            case exception: {
                                prepTokenReadings = null;
                                continue block16;
                            }
                            case skip: {
                                i += exception.skip;
                                continue block16;
                            }
                        }
                    }
                    prepTokenReadings = null;
                }
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    static boolean hasVidmPosTag(Collection<String> posTagsToFind, AnalyzedTokenReadings tokenReadings) {
        boolean vidminokFound = false;
        for (AnalyzedToken token : tokenReadings) {
            String posTag = token.getPOSTag();
            if (posTag == null) {
                if (tokenReadings.getReadingsLength() != 1) continue;
                return true;
            }
            if (posTag.contains(":nv")) {
                return true;
            }
            if (!posTag.contains(VIDMINOK_SUBSTR)) continue;
            vidminokFound = true;
            for (String posTagToFind : posTagsToFind) {
                if (!posTag.contains(posTagToFind)) continue;
                return true;
            }
        }
        return !vidminokFound;
    }

    /*
     * WARNING - void declaration
     */
    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, AnalyzedTokenReadings prepTokenReadings, Set<String> posTagsToFind, AnalyzedSentence sentence, AnalyzedTokenReadings[] tokens, int i) throws IOException {
        void var13_22;
        String[] synthesized;
        String tokenString = tokenReadings.getToken();
        Synthesizer ukrainianSynthesizer = this.ukrainian.getSynthesizer();
        ArrayList<String> suggestions = new ArrayList<String>();
        String requiredPostTagsRegEx = ":(" + String.join((CharSequence)"|", posTagsToFind) + ")";
        for (Object analyzedToken : tokenReadings.getReadings()) {
            String string = analyzedToken.getPOSTag();
            if (string == null) continue;
            String requiredPostTagsRegExToApply = requiredPostTagsRegEx;
            Matcher matcher = REQ_ANIM_INANIM_PATTERN.matcher(string);
            requiredPostTagsRegExToApply = matcher.find() ? requiredPostTagsRegExToApply + matcher.group(0) : requiredPostTagsRegExToApply + "(?::r(?:in)?anim)?";
            String posTag = string.replaceFirst(":v_[a-z]+", requiredPostTagsRegExToApply);
            try {
                synthesized = ukrainianSynthesizer.synthesize((AnalyzedToken)analyzedToken, posTag, true);
                suggestions.addAll(Arrays.asList(synthesized));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (suggestions.size() > 0) {
            suggestions = new ArrayList(new LinkedHashSet(suggestions));
        }
        ArrayList<String> reqVidminkyNames = new ArrayList<String>();
        for (String string : posTagsToFind) {
            reqVidminkyNames.add(PosTagHelper.VIDMINKY_MAP.get(string));
        }
        ArrayList<String> foundVidminkyNames = new ArrayList<String>();
        for (AnalyzedToken token : tokenReadings) {
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !posTag2.contains(VIDMINOK_SUBSTR)) continue;
            String vidmName = PosTagHelper.VIDMINKY_MAP.get(posTag2.replaceFirst("^.*" + VIDMINOK_REGEX + ".*$", "$1"));
            if (foundVidminkyNames.contains(vidmName)) {
                if (!posTag2.contains(":p:")) continue;
                vidmName = vidmName + " (\u043c\u043d.)";
                foundVidminkyNames.add(vidmName);
                continue;
            }
            foundVidminkyNames.add(vidmName);
        }
        String string = MessageFormat.format("\u041f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab{0}\u00bb \u0432\u0438\u043c\u0430\u0433\u0430\u0454 \u0456\u043d\u0448\u043e\u0433\u043e \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0430: {1}, \u0430 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e: {2}", prepTokenReadings.getToken(), String.join((CharSequence)", ", reqVidminkyNames), String.join((CharSequence)", ", foundVidminkyNames));
        if (tokenString.equals("\u0457\u0445") && requiredPostTagsRegEx != null) {
            String string2 = string + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0442\u0443\u0442 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u0456\u0439\u043d\u0438\u0439 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab\u0457\u0445\u043d\u0456\u0439\u00bb?";
            try {
                String newYihPostag = "adj:p" + requiredPostTagsRegEx + ".*";
                String[] synthesized2 = ukrainianSynthesizer.synthesize(new AnalyzedToken("\u0457\u0445\u043d\u0456\u0439", "adj:m:v_naz:&pron:pos", "\u0457\u0445\u043d\u0456\u0439"), newYihPostag, true);
                suggestions.addAll(Arrays.asList(synthesized2));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (prepTokenReadings.getToken().equalsIgnoreCase("\u043e")) {
            for (AnalyzedToken token : tokenReadings.getReadings()) {
                if (!PosTagHelper.hasPosTag(token, NOUN_ANIM_V_NAZ_PATTERN)) continue;
                String string3 = string + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0442\u0443\u0442 \u00ab\u043e\u00bb \u2014 \u0446\u0435 \u0432\u0438\u0433\u0443\u043a \u0456 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043a\u043b\u0438\u0447\u043d\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a?";
                try {
                    String newPostag = token.getPOSTag().replace("v_naz", "v_kly");
                    for (String string4 : synthesized = ukrainianSynthesizer.synthesize(token, newPostag, false)) {
                        if (string4.equals(token.getToken()) || suggestions.contains(string4)) continue;
                        suggestions.add(string4);
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (PosTagHelper.hasPosTagStart(tokens[i - 1], "adv")) {
            String mergedToken = prepTokenReadings.getCleanToken() + tokens[i - 1].getCleanToken();
            List mergedTagged = this.ukrainian.getTagger().tag(Arrays.asList(mergedToken));
            if (PosTagHelper.hasPosTagStart((AnalyzedTokenReadings)mergedTagged.get(0), "adv")) {
                String string5 = string + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u0456 \u043f\u0440\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a \u043c\u0430\u044e\u0442\u044c \u0431\u0443\u0442\u0438 \u043e\u0434\u043d\u0438\u043c \u0441\u043b\u043e\u0432\u043e\u043c?";
            }
        }
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getEndPos(), (String)var13_22, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(suggestions);
        return potentialRuleMatch;
    }

    @Nullable
    private static AnalyzedToken getMultiwordToken(AnalyzedTokenReadings analyzedTokenReadings) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !posTag.startsWith("<")) continue;
            return analyzedToken;
        }
        return null;
    }
}

