/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.uk.PosTagHelper;

public abstract class LemmaHelper {
    public static final Set<String> CITY_AVENU = new HashSet<String>(Arrays.asList("\u0441\u0456\u0442\u0456", "\u0441\u0438\u0442\u0456", "\u0441\u0442\u0440\u0456\u0442", "\u0441\u0442\u0440\u0438\u0442", "\u0440\u0456\u0432\u0435\u0440", "\u0440\u0438\u0432\u0435\u0440", "\u0430\u0432\u0435\u043d\u044e", "\u0448\u0442\u0440\u0430\u0441\u0435", "\u0448\u0442\u0440\u0430\u0441\u0441\u0435", "\u0441\u044c\u043e\u0440\u043a\u043b", "\u0441\u043a\u0432\u0435\u0440"));
    public static final List<String> MONTH_LEMMAS = Arrays.asList("\u0441\u0456\u0447\u0435\u043d\u044c", "\u043b\u044e\u0442\u0438\u0439", "\u0431\u0435\u0440\u0435\u0437\u0435\u043d\u044c", "\u043a\u0432\u0456\u0442\u0435\u043d\u044c", "\u0442\u0440\u0430\u0432\u0435\u043d\u044c", "\u0447\u0435\u0440\u0432\u0435\u043d\u044c", "\u043b\u0438\u043f\u0435\u043d\u044c", "\u0441\u0435\u0440\u043f\u0435\u043d\u044c", "\u0432\u0435\u0440\u0435\u0441\u0435\u043d\u044c", "\u0436\u043e\u0432\u0442\u0435\u043d\u044c", "\u043b\u0438\u0441\u0442\u043e\u043f\u0430\u0434", "\u0433\u0440\u0443\u0434\u0435\u043d\u044c");
    public static final List<String> DAYS_OF_WEEK = Arrays.asList("\u043f\u043e\u043d\u0435\u0434\u0456\u043b\u043e\u043a", "\u0432\u0456\u0432\u0442\u043e\u0440\u043e\u043a", "\u0441\u0435\u0440\u0435\u0434\u0430", "\u0447\u0435\u0442\u0432\u0435\u0440", "\u043f'\u044f\u0442\u043d\u0438\u0446\u044f", "\u0441\u0443\u0431\u043e\u0442\u0430", "\u043d\u0435\u0434\u0456\u043b\u044f");
    public static final List<String> TIME_LEMMAS = Arrays.asList("\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430", "\u0434\u0435\u043d\u044c", "\u0442\u0438\u0436\u0434\u0435\u043d\u044c", "\u043c\u0456\u0441\u044f\u0446\u044c", "\u0440\u0456\u043a", "\u043f\u0456\u0432\u0440\u043e\u043a\u0443", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u0440\u0456\u0447\u0447\u044f", "\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u043f\u0456\u0432\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f", "\u0442\u0438\u0441\u044f\u0447\u0435\u043b\u0456\u0442\u0442\u044f");
    public static final List<String> TIME_PLUS_LEMMAS = Arrays.asList("\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430", "\u0434\u0435\u043d\u044c", "\u0442\u0438\u0436\u0434\u0435\u043d\u044c", "\u043c\u0456\u0441\u044f\u0446\u044c", "\u0440\u0456\u043a", "\u043f\u0456\u0432\u0440\u043e\u043a\u0443", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u0440\u0456\u0447\u0447\u044f", "\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u043f\u0456\u0432\u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f", "\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f", "\u0442\u0438\u0441\u044f\u0447\u0435\u043b\u0456\u0442\u0442\u044f", "\u043c\u0456\u043b\u0456\u043c\u0435\u0442\u0440", "\u0441\u0430\u043d\u0442\u0438\u043c\u0435\u0442\u0440", "\u043c\u0435\u0442\u0440", "\u043a\u0456\u043b\u043e\u043c\u0435\u0442\u0440", "\u0432\u0456\u0434\u0441\u043e\u0442\u043e\u043a");
    public static final List<String> TIME_LEMMAS_SHORT = Arrays.asList("\u0441\u0435\u043a\u0443\u043d\u0434\u0430", "\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430", "\u0440\u0456\u043a");
    private static final Pattern QUOTES = Pattern.compile("[\u00ab\u00bb\u201e\u201c\u201c]");

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, List<String> lemmas) {
        List readings = analyzedTokenReadings.getReadings();
        return LemmaHelper.hasLemma(readings, lemmas);
    }

    public static boolean hasLemma(List<AnalyzedToken> readings, List<String> lemmas) {
        for (AnalyzedToken analyzedToken : readings) {
            if (!lemmas.contains(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, List<String> lemmas, String partPos) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            for (String lemma : lemmas) {
                if (!lemma.equals(analyzedToken.getLemma()) || analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().contains(partPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, List<String> lemmas, Pattern posRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            for (String lemma : lemmas) {
                if (!lemma.equals(analyzedToken.getLemma()) || analyzedToken.getPOSTag() == null || !posRegex.matcher(analyzedToken.getPOSTag()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedToken token, List<String> asList, String partPos) {
        return asList.contains(token.getLemma()) && token.getPOSTag() != null && token.getPOSTag().contains(partPos);
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, String lemmas) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            if (!lemmas.equals(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Pattern pattern) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            String lemma = analyzedToken.getLemma();
            if (lemma == null || !pattern.matcher(lemma).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLemma(AnalyzedTokenReadings analyzedTokenReadings, Pattern pattern, Pattern posTagRegex) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            String lemma = analyzedToken.getLemma();
            if (lemma == null || !pattern.matcher(lemma).matches() || posTagRegex == null || analyzedToken.getPOSTag() == null || !posTagRegex.matcher(analyzedToken.getPOSTag()).matches()) continue;
            return true;
        }
        return false;
    }

    static boolean reverseSearch(AnalyzedTokenReadings[] tokens, int pos, int depth, Pattern lemma, Pattern postag) {
        for (int i = pos; i > pos - depth && i >= 0; --i) {
            if (lemma != null && !LemmaHelper.hasLemma(tokens[i], lemma) || postag != null && !PosTagHelper.hasPosTag(tokens[i], postag)) continue;
            return true;
        }
        return false;
    }

    static boolean forwardPosTagSearch(AnalyzedTokenReadings[] tokens, int pos, String posTag, int maxSkip) {
        for (int i = pos; i < tokens.length && i <= pos + maxSkip; ++i) {
            if (!PosTagHelper.hasPosTagPart(tokens[i], posTag)) continue;
            return true;
        }
        return false;
    }

    static int tokenSearch(AnalyzedTokenReadings[] tokens, int pos, String posTag, Pattern token, Pattern posTagsToIgnore, Dir dir) {
        int step = dir == Dir.FORWARD ? 1 : -1;
        for (int i = pos; i < tokens.length && i > 0; i += step) {
            if ((posTag == null || PosTagHelper.hasPosTagPart(tokens[i], posTag)) && (token == null || token.matcher(tokens[i].getToken()).matches())) {
                return i;
            }
            if (!PosTagHelper.hasPosTag(tokens[i], posTagsToIgnore) && !QUOTES.matcher(tokens[i].getToken()).matches()) break;
        }
        return -1;
    }

    static int tokenSearch(AnalyzedTokenReadings[] tokens, int pos, Pattern posTag, Pattern token, Pattern posTagsToIgnore, Dir dir) {
        int step = dir == Dir.FORWARD ? 1 : -1;
        for (int i = pos; i < tokens.length && i > 0; i += step) {
            if ((posTag == null || PosTagHelper.hasPosTag(tokens[i], posTag)) && (token == null || token.matcher(tokens[i].getToken()).matches())) {
                return i;
            }
            if (!PosTagHelper.hasPosTag(tokens[i], posTagsToIgnore) && !QUOTES.matcher(tokens[i].getToken()).matches()) break;
        }
        return -1;
    }

    static boolean revSearch(AnalyzedTokenReadings[] tokens, int startPos, Pattern lemma, String postagRegex) {
        return LemmaHelper.revSearchIdx(tokens, startPos, lemma, postagRegex) != -1;
    }

    static int revSearchIdx(AnalyzedTokenReadings[] tokens, int startPos, Pattern lemma, String postagRegex) {
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "part.*")) {
            --startPos;
        }
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "adv(:.*)?|.*pron.*")) {
            --startPos;
        }
        if (startPos > 0 && PosTagHelper.hasPosTag(tokens[startPos], "part.*")) {
            --startPos;
        }
        if (startPos > 0) {
            if (lemma != null && !LemmaHelper.hasLemma(tokens[startPos], lemma)) {
                return -1;
            }
            if (postagRegex != null && !PosTagHelper.hasPosTag(tokens[startPos], postagRegex)) {
                return -1;
            }
            return startPos;
        }
        return -1;
    }

    public static boolean isAllUppercaseUk(String word) {
        int sz = word.length();
        for (int i = 0; i < sz; ++i) {
            char ch = word.charAt(i);
            if (ch == '-' || ch == '\u2013' || ch == '\'' || Character.isUpperCase(ch)) continue;
            return false;
        }
        return true;
    }

    public static String capitalizeProperName(String word) {
        char[] chars = new char[word.length()];
        int prevChar = 45;
        for (int i = 0; i < chars.length; ++i) {
            char ch = word.charAt(i);
            chars[i] = prevChar == 45 ? ch : Character.toLowerCase(ch);
            prevChar = ch == '\u2013' ? 45 : (int)ch;
        }
        return new String(chars);
    }

    static enum Dir {
        FORWARD,
        REVERSE;

    }
}

