/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.uk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;

class SimpleDisambiguator {
    final Map<String, TokenMatcher> DISAMBIG_REMOVE_MAP = SimpleDisambiguator.loadMap("/uk/disambig_remove.txt");

    SimpleDisambiguator() {
    }

    private static Map<String, TokenMatcher> loadMap(String path) {
        HashMap<String, TokenMatcher> result = new HashMap<String, TokenMatcher>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            line = line.replaceFirst(" *#.*", "");
            String[] parts = line.trim().split(" ", 2);
            String[] matchers = parts[1].split("\\|");
            ArrayList<MatcherEntry> matcherEntries = new ArrayList<MatcherEntry>();
            for (String string : matchers) {
                String[] matcherParts = string.split(" ");
                matcherEntries.add(new MatcherEntry(matcherParts[0], matcherParts[1]));
            }
            result.put(parts[0], new TokenMatcher(matcherEntries));
        }
        return result;
    }

    public void removeRareForms(AnalyzedSentence input) {
        AnalyzedTokenReadings[] tokens = input.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            int idx;
            String lowerToken;
            TokenMatcher tokenMatcher;
            String token = tokens[i].getToken();
            if (Character.isLowerCase(token.charAt(0))) {
                token = token.toLowerCase();
            }
            if ((tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(token)) == null && (tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(lowerToken = token.toLowerCase())) == null && (idx = token.lastIndexOf(45)) > 0 && token.matches(".*-(\u0442\u043e|\u043e\u0442|\u0442\u0430\u043a\u0438|\u0431\u043e|\u043d\u043e)")) {
                String mainToken = token.substring(0, idx);
                tokenMatcher = this.DISAMBIG_REMOVE_MAP.get(mainToken);
            }
            if (tokenMatcher == null) continue;
            List analyzedTokens = tokens[i].getReadings();
            for (int j = analyzedTokens.size() - 1; j >= 0; --j) {
                AnalyzedToken analyzedToken = (AnalyzedToken)analyzedTokens.get(j);
                if (!tokenMatcher.matches(analyzedToken)) continue;
                tokens[i].removeReading(analyzedToken, this.toString());
            }
        }
    }

    static class TokenMatcher {
        private final List<MatcherEntry> matchers;

        public TokenMatcher(List<MatcherEntry> matchers) {
            this.matchers = matchers;
        }

        public boolean matches(AnalyzedToken analyzedToken) {
            for (MatcherEntry matcher : this.matchers) {
                if (!matcher.matches(analyzedToken)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "TokenMatcher " + this.matchers;
        }
    }

    private static class MatcherEntry {
        private final String lemma;
        private final Pattern tagRegex;

        public MatcherEntry(String lemma, String tagRegex) {
            this.lemma = lemma;
            this.tagRegex = Pattern.compile(tagRegex);
        }

        public boolean matches(AnalyzedToken analyzedToken) {
            return this.lemma.equals(analyzedToken.getLemma()) && !analyzedToken.hasNoTag() && this.tagRegex.matcher(analyzedToken.getPOSTag()).matches();
        }

        public String toString() {
            return "MatcherEntry [lemma=" + this.lemma + ", tagRegex=" + this.tagRegex + "]";
        }
    }
}

