/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.uk.PosTagHelper;

public class CaseGovernmentHelper {
    static final Map<String, Set<String>> CASE_GOVERNMENT_MAP = CaseGovernmentHelper.loadMap("/uk/case_government.txt");

    private static Map<String, Set<String>> loadMap(String path) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            String[] parts = line.split(" ");
            String[] vidm = parts[1].split(":");
            result.put(parts[0], new LinkedHashSet<String>(Arrays.asList(vidm)));
        }
        return result;
    }

    public static boolean hasCaseGovernment(AnalyzedTokenReadings analyzedTokenReadings, String rvCase) {
        for (AnalyzedToken token : analyzedTokenReadings.getReadings()) {
            if (rvCase.equals("v_oru") && PosTagHelper.hasPosTagPart(token, "adjp:pasv")) {
                return true;
            }
            if (!CASE_GOVERNMENT_MAP.containsKey(token.getLemma()) || !CASE_GOVERNMENT_MAP.get(token.getLemma()).contains(rvCase)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getCaseGovernments(AnalyzedTokenReadings analyzedTokenReadings, String startPosTag) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        for (AnalyzedToken token : analyzedTokenReadings.getReadings()) {
            if (token.hasNoTag() || (token.getPOSTag() == null || !token.getPOSTag().startsWith(startPosTag)) && (!startPosTag.equals("prep") || token.getPOSTag() == null || !token.getPOSTag().equals("<prep>")) || !CASE_GOVERNMENT_MAP.containsKey(token.getLemma())) continue;
            Set<String> rvList = CASE_GOVERNMENT_MAP.get(token.getLemma());
            list.addAll(rvList);
            if (!token.getPOSTag().contains("adjp:pasv")) continue;
            rvList.add("v_oru");
        }
        return list;
    }

    static {
        CASE_GOVERNMENT_MAP.put("\u0437\u0433\u0456\u0434\u043d\u043e \u0437", new HashSet<String>(Arrays.asList("v_oru")));
    }
}

