/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

public enum IPOSTag {
    noun("noun"),
    adj("adj"),
    verb("verb"),
    adv("adv"),
    part("part"),
    intj("intj"),
    numr("numr"),
    number("number"),
    date("date"),
    time("time"),
    advp("advp"),
    prep("prep"),
    predic("predic"),
    insert("insert"),
    abbr("abbr"),
    bad("bad"),
    unknown("unknown"),
    onomat("onomat");

    private final String text;

    private IPOSTag(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public boolean match(String posTagPrefix) {
        return posTagPrefix != null && posTagPrefix.startsWith(this.name());
    }

    public static boolean isNum(String posTag) {
        return numr.match(posTag) || number.match(posTag);
    }

    public static boolean contains(String posTag, String postagMatch) {
        return posTag != null && posTag.contains(postagMatch);
    }

    public static boolean startsWith(String posTagPrefix, IPOSTag ... posTags) {
        if (posTagPrefix == null) {
            return false;
        }
        for (IPOSTag posTag : posTags) {
            if (!posTagPrefix.startsWith(posTag.getText())) continue;
            return true;
        }
        return false;
    }
}

