/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceSoftRule
extends AbstractSimpleReplaceRule {
    private static final String CONTEXT_PREFIX = "ctx:";
    private static final Map<String, List<String>> WRONG_WORDS = SimpleReplaceSoftRule.loadFromPath((String)"/uk/replace_soft.txt");

    protected Map<String, List<String>> getWrongWords() {
        return WRONG_WORDS;
    }

    public SimpleReplaceSoftRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE_SOFT";
    }

    public String getDescription() {
        return "\u041f\u043e\u0448\u0443\u043a \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0445 \u0441\u043b\u0456\u0432";
    }

    public String getShort() {
        return "\u041d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u0435 \u0441\u043b\u043e\u0432\u043e";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        ContextRepl repl = SimpleReplaceSoftRule.findContext(replacements);
        String replaceText = StringUtils.join(repl.replacements, (String)", ");
        replacements.retainAll(repl.replacements);
        if (repl.contexts.size() > 0) {
            return "\u00ab" + tokenStr + "\u00bb \u0432\u0436\u0438\u0432\u0430\u0454\u0442\u044c\u0441\u044f \u043b\u0438\u0448\u0435 \u0432 \u0442\u0430\u043a\u0438\u0445 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430\u0445: " + StringUtils.join(repl.contexts, (String)", ") + ", \u043c\u043e\u0436\u043b\u0438\u0432\u043e, \u0432\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456: " + replaceText + "?";
        }
        return tokenStr + " \u2014 \u043d\u0435\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u043e\u0432\u0430\u043d\u0435 \u0441\u043b\u043e\u0432\u043e, \u043a\u0440\u0430\u0449\u0438\u0439 \u0432\u0430\u0440\u0456\u0430\u043d\u0442: " + replaceText + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    private static ContextRepl findContext(List<String> replacements) {
        ContextRepl contextRepl = new ContextRepl();
        for (String replacement : replacements) {
            if (replacement.startsWith(CONTEXT_PREFIX)) {
                contextRepl.contexts.addAll(Arrays.asList(replacement.replace(CONTEXT_PREFIX, "").trim().split(", *")));
                continue;
            }
            contextRepl.replacements.add(replacement);
        }
        return contextRepl;
    }

    private static final class ContextRepl {
        final List<String> contexts = new ArrayList<String>();
        final List<String> replacements = new ArrayList<String>();

        private ContextRepl() {
        }
    }
}

