/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementNounVerbRule;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenAgreementNounVerbExceptionHelper {
    private static Logger logger = LoggerFactory.getLogger(TokenAgreementNounVerbExceptionHelper.class);
    private static final Set<String> MASC_FEM_SET = TokenAgreementNounVerbExceptionHelper.extendSet(ExtraDictionaryLoader.loadSet("/uk/masc_fem.txt"), "\u0435\u043a\u0441-");

    private TokenAgreementNounVerbExceptionHelper() {
    }

    private static boolean isCapitalized(String token) {
        return token != null && token.length() > 1 && Character.isUpperCase(token.charAt(0)) && Character.isLowerCase(token.charAt(1));
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int i, List<TokenAgreementNounVerbRule.Inflection> nounInflections, List<TokenAgreementNounVerbRule.Inflection> verbInflections, List<AnalyzedToken> nounTokenReadings, List<AnalyzedToken> verbTokenReadings) {
        int verbPos;
        int pos;
        Set<String> prepGovernedCases;
        if (TokenAgreementNounVerbExceptionHelper.isCapitalized(tokens[i].getToken()) && TokenAgreementNounVerbExceptionHelper.isCapitalized(tokens[i - 1].getToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && TokenAgreementNounVerbExceptionHelper.isCapitalized(tokens[i - 1].getToken()) && TokenAgreementNounVerbExceptionHelper.isCapitalized(tokens[i - 2].getToken()) && !Collections.disjoint(TokenAgreementNounVerbRule.getNounInflections(tokens[i - 2].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (StringUtils.isAllUpperCase((CharSequence)tokens[i].getToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && tokens[i - 2].getToken().equals("/")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && tokens[i - 1].getToken().equals("\u042f")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && tokens[i].getToken().equals("\u0434\u0430\u0432\u0430\u0439")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && tokens[i - 1].getToken().equals("\u0446\u0435") && tokens[i - 2].getToken().matches("[\u2014\u2013-]")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0432\u043e\u043d\u043e", "\u0440\u0435\u0448\u0442\u0430")) && PosTagHelper.hasPosTagPart(tokens[i], ":impers")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0413\u0430\u0437\u0430"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(verbTokenReadings, ".*:p(:.*|$)")) {
            int pos3;
            int pos0 = LemmaHelper.tokenSearch(tokens, i - 2, (String)null, TokenAgreementAdjNounExceptionHelper.CONJ_FOR_PLULAR_PATTERN, Pattern.compile("(noun|adj:.:v_naz|adv|part).*"), LemmaHelper.Dir.REVERSE);
            if (pos0 > 1) {
                if (pos0 > 2) {
                    if (pos0 < tokens.length - 1 && LemmaHelper.hasLemma(tokens[pos0 + 1], "\u0456\u043d\u0448\u0438\u0439") && LemmaHelper.hasLemma(tokens[pos0 - 1], "\u0442\u043e\u0439")) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (PosTagHelper.hasPosTagPart(tokens[pos0 - 1], "conj")) {
                        --pos0;
                    }
                    if (LemmaHelper.hasLemma(tokens[pos0 - 1], "\u043e\u0441\u043e\u0431\u0438\u0441\u0442\u043e")) {
                        --pos0;
                    }
                    if (tokens[pos0 - 1].getToken().equals(")")) {
                        TokenAgreementNounVerbExceptionHelper.logException();
                        return true;
                    }
                    if (i > 6 && PosTagHelper.hasPosTagPart(tokens[pos0 - 1], "adv") && PosTagHelper.hasPosTagPart(tokens[pos0 - 2], "conj")) {
                        pos0 -= 2;
                    }
                    while (pos0 > 2 && tokens[pos0 - 1].getToken().matches("[,\u00bb\u201c\u201d\"]")) {
                        --pos0;
                    }
                }
                if (PosTagHelper.hasPosTag(tokens[pos0 - 1], "noun.*") || TokenAgreementNounVerbExceptionHelper.isCapitalized(tokens[pos0 - 1].getToken())) {
                    TokenAgreementNounVerbExceptionHelper.logException();
                    return true;
                }
                if (PosTagHelper.hasPosTag(tokens[pos0 - 1], "adj:.:v_naz.*")) {
                    TokenAgreementNounVerbExceptionHelper.logException();
                    return true;
                }
            }
            if ((pos3 = LemmaHelper.tokenSearch(tokens, i - 2, (String)null, Pattern.compile("\u0442\u0430\u043a\u043e\u0436"), Pattern.compile("(noun|adj:.:v_naz|adv|part).*"), LemmaHelper.Dir.REVERSE)) > 1) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            int pos1 = LemmaHelper.tokenSearch(tokens, i - 2, (String)null, Pattern.compile(","), Pattern.compile("adj.*"), LemmaHelper.Dir.REVERSE);
            if (pos1 > 1 && PosTagHelper.hasPosTag(tokens[pos1 - 1], "noun.*:v_naz.*") || pos1 > 2 && PosTagHelper.hasPosTag(tokens[pos1 - 1], "noun.*:v_rod.*") && PosTagHelper.hasPosTag(tokens[pos1 - 2], "noun.*:v_naz.*")) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(tokens[i - 1], "numr") && !LemmaHelper.hasLemma(tokens[i - 1], "\u043e\u0434\u0438\u043d") || LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0441\u043e\u0442\u043d\u044f", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u0434\u0435\u0441\u044f\u0442\u043e\u043a"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (i > 2 && PosTagHelper.hasPosTagPart(tokens[i - 2], "number") && (!tokens[i - 2].getToken().endsWith("1") || tokens[i - 2].getToken().endsWith("11"))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            if (i > 2 && (tokens[i - 2].getToken().endsWith("+1") || LemmaHelper.tokenSearch(tokens, i - 2, (String)null, Pattern.compile("\u043f\u043b\u044e\u0441"), Pattern.compile("(numr|adj).*.:v_naz.*"), LemmaHelper.Dir.REVERSE) > 0)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (i > 3 && PosTagHelper.hasPosTagPart(tokens[i - 1], ":prop") && PosTagHelper.hasPosTag(tokens[i - 2], Pattern.compile("noun.*:v_rod.*")) && !Collections.disjoint(TokenAgreementNounVerbRule.getNounInflections(tokens[i - 3].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 3 && PosTagHelper.hasPosTagPart(tokens[i - 1], "v_naz:prop") && PosTagHelper.hasPosTag(tokens[i - 2], Pattern.compile("noun.*:v_(rod|zna|mis).*"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 4 && PosTagHelper.hasPosTagPart(tokens[i - 1], "v_naz:prop") && PosTagHelper.hasPosTag(tokens[i - 2], "adj:.:v_naz.*") && PosTagHelper.hasPosTag(tokens[i - 3], Pattern.compile("noun.*:v_(rod|zna|mis).*"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && PosTagHelper.hasPosTagPart(tokens[i - 1], ":prop") && PosTagHelper.hasPosTag(tokens[i], "verb.*:impers.*")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 4 && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("noun:inanim:.:v_naz:prop.*")) && PosTagHelper.hasPosTag(tokens[i - 2], Pattern.compile("noun:inanim:.*")) && PosTagHelper.hasPosTag(tokens[i - 3], Pattern.compile("adj:.*")) && PosTagHelper.hasPosTagPart(tokens[i - 4], "prep") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases = CaseGovernmentHelper.getCaseGovernments(tokens[i - 4], IPOSTag.prep.name()), tokens[i - 2]) && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases, tokens[i - 3])) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && tokens[i].getToken().equals("\u0431\u0443\u043b\u043e") && (pos = LemmaHelper.tokenSearch(tokens, i + 1, ":past", null, Pattern.compile("adv.*"), LemmaHelper.Dir.FORWARD)) >= 0 && !Collections.disjoint(TokenAgreementNounVerbRule.getNounInflections(tokens[i - 1].getReadings()), TokenAgreementNounVerbRule.getVerbInflections(tokens[pos].getReadings()))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[i - 1], ":prop") && tokens[i].getToken().equals("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[i + 1], "verb.*:impers.*")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 2 && PosTagHelper.hasPosTag(tokens[i - 2], Pattern.compile("noun:inanim:.:v_naz.*")) && !PosTagHelper.hasPosTagPart(tokens[i - 2], ":&pron") && !PosTagHelper.hasPosTag(tokens[i - 1], "noun.*pron.*") && !Collections.disjoint(TokenAgreementNounVerbRule.getNounInflections(tokens[i - 2].getReadings()), verbInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(nounTokenReadings, "noun:anim:m:v_naz") && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:f(:.*|$)") && TokenAgreementNounVerbExceptionHelper.hasMascFemLemma(nounTokenReadings)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043f\u043e\u0440\u0430").contains(tokens[i - 1].getToken().toLowerCase()) && Arrays.asList("\u0431\u0443\u043b\u043e").contains(tokens[i].getToken())) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u0440\u0435\u0448\u0442\u0430", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430", "\u0447\u0430\u0441\u0442\u043a\u0430", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430", "\u0442\u0440\u0435\u0442\u0438\u043d\u0430", "\u0447\u0432\u0435\u0440\u0442\u044c").contains(tokens[i - 1].getToken().toLowerCase()) && PosTagHelper.hasPosTag(verbTokenReadings, ".*:[pn](:.*|$)")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 3 && LemmaHelper.hasLemma(tokens[i - 3], "\u0440\u0435\u0448\u0442\u0430") && tokens[i - 2].getToken() != null && tokens[i - 2].getToken().matches(".+1") && PosTagHelper.hasPosTag(verbTokenReadings, ".*:p(:.*|$)")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 3 && LemmaHelper.hasLemma(tokens[i - 2], "\u043d\u0456\u0436")) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 2 && tokens[i].getToken().equals("\u0432\u0456\u0437\u044c\u043c\u0438") && LemmaHelper.hasLemma(tokens[i + 1], Arrays.asList("\u0456", "\u0439", "\u0442\u0430"))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        int vPos = i;
        if (i > 3 && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("noun:inanim:.:v_naz:prop.*"))) {
            Set<String> prepGovernedCases2;
            String token = tokens[i - 2].getToken();
            if (token.matches("[\u0410-\u042f\u0406\u0407\u0490][\u0430-\u044f\u0456\u0457\u0454\u0491'].*") && PosTagHelper.hasPosTagPart(tokens[i - 2], "adj:")) {
                --vPos;
            }
            if (PosTagHelper.hasPosTag(tokens[vPos - 2], Pattern.compile("noun:inanim:.*")) && PosTagHelper.hasPosTagPart(tokens[vPos - 3], "prep") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2 = CaseGovernmentHelper.getCaseGovernments(tokens[vPos - 3], IPOSTag.prep.name()), tokens[vPos - 2])) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if ((verbPos = LemmaHelper.tokenSearch(tokens, i - 2, "verb", null, Pattern.compile("(adv|part).*"), LemmaHelper.Dir.REVERSE)) != -1 && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && !Collections.disjoint(TokenAgreementNounVerbRule.getVerbInflections(tokens[verbPos].getReadings()), nounInflections)) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(tokens[i - 2], "adj") && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*") && CaseGovernmentHelper.hasCaseGovernment(tokens[i - 2], "v_inf") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[i - 2].getReadings()), InflectionHelper.getNounInflections(nounTokenReadings))) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(verbTokenReadings, "verb.*:inf.*")) {
            int verbPos2 = LemmaHelper.tokenSearch(tokens, i + 1, Pattern.compile("verb.*"), null, Pattern.compile("(adv|part|adj|noun|conj|part|prep).*"), LemmaHelper.Dir.FORWARD);
            if (verbPos2 != -1 && !Collections.disjoint(TokenAgreementNounVerbRule.getVerbInflections(tokens[verbPos2].getReadings()), nounInflections)) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
            int adjPos2 = LemmaHelper.tokenSearch(tokens, i + 1, "adj", null, Pattern.compile("(adv|part).*"), LemmaHelper.Dir.FORWARD);
            if (adjPos2 != -1 && CaseGovernmentHelper.hasCaseGovernment(tokens[adjPos2], "v_inf") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[adjPos2].getReadings()), InflectionHelper.getNounInflections(nounTokenReadings))) {
                TokenAgreementNounVerbExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTag(tokens[i - 1], "noun.*:v_naz.*") && LemmaHelper.tokenSearch(tokens, i - 2, (String)null, Pattern.compile("[\u042f\u044f]\u043a"), Pattern.compile("adj.*"), LemmaHelper.Dir.REVERSE) != -1) {
            TokenAgreementNounVerbExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static boolean hasMascFemLemma(List<AnalyzedToken> nounTokenReadings) {
        String token = nounTokenReadings.get(0).getToken();
        if (token.endsWith("\u043e\u043b\u043e\u0433") || token.endsWith("\u0437\u043d\u0430\u0432\u0435\u0446\u044c")) {
            return true;
        }
        for (AnalyzedToken analyzedToken : nounTokenReadings) {
            String lemma;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !posTag.contains("noun:anim:m:v_naz") || !TokenAgreementNounVerbExceptionHelper.isInMascFemSet(lemma = analyzedToken.getLemma()) && (!lemma.contains("-") || !TokenAgreementNounVerbExceptionHelper.isInMascFemSet(lemma.replaceFirst("-.*", "")))) continue;
            return true;
        }
        return false;
    }

    private static boolean isInMascFemSet(String lemma) {
        return MASC_FEM_SET.contains(lemma.replace('\u2018', '-'));
    }

    private static Set<String> extendSet(Set<String> loadSet, String string) {
        Set extraSet = loadSet.stream().map(line -> "\u0435\u043a\u0441-" + line).collect(Collectors.toSet());
        loadSet.addAll(extraSet);
        return loadSet;
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

