/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundTagger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tools.StringTools;

public class UkrainianTagger
extends BaseTagger {
    static final Pattern NUMBER = Pattern.compile("[+-\u00b1]?[\u20ac\u20b4\\$]?[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?(%|\u00b0\u0421?)?|\\d{1,3}([\\s\u00a0\u202f]\\d{3})+|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final Pattern DATE = Pattern.compile("[\\d]{2}\\.[\\d]{2}\\.[\\d]{4}");
    private static final Pattern TIME = Pattern.compile("([01]?[0-9]|2[0-3])[.:][0-5][0-9]");
    private static final Pattern ALT_DASHES_IN_WORD = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u04910-9a-z]\u2013[\u0430-\u044f\u0456\u0457\u0454\u0491]|[\u0430-\u044f\u0456\u0457\u0454\u0491]\u2013[0-9]", 66);
    private final CompoundTagger compoundTagger;

    public String getManualAdditionsFileName() {
        return "/uk/added.txt";
    }

    public UkrainianTagger() {
        super("/uk/ukrainian.dict", new Locale("uk", "UA"), false);
        this.compoundTagger = new CompoundTagger(this, this.wordTagger, this.conversionLocale);
    }

    public List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.number.getText(), word));
            return additionalTaggedTokens;
        }
        if (TIME.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.time.getText(), word));
            return additionalTaggedTokens;
        }
        if (DATE.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.date.getText(), word));
            return additionalTaggedTokens;
        }
        if (word.indexOf(45) > 0) {
            List<AnalyzedToken> guessedCompoundTags = this.compoundTagger.guessCompoundTag(word);
            return guessedCompoundTags;
        }
        return this.guessOtherTags(word);
    }

    private List<AnalyzedToken> guessOtherTags(String word) {
        if (word.length() > 7 && StringTools.isCapitalizedWord((String)word) && (word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0441\u0435") || word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0435"))) {
            return PosTagHelper.generateTokensForNv(word, "f", ":prop");
        }
        return null;
    }

    protected List<AnalyzedToken> getAnalyzedTokens(String word) {
        List<AnalyzedToken> tokens = super.getAnalyzedTokens(word);
        if (((AnalyzedToken)tokens.get(0)).getPOSTag() == null) {
            char otherHyphen = UkrainianTagger.getOtherHyphen(word);
            if (otherHyphen != '\u0000' && ALT_DASHES_IN_WORD.matcher(word).find()) {
                String newWord = word.replace(otherHyphen, '-');
                List<AnalyzedToken> newTokens = super.getAnalyzedTokens(newWord);
                if (!((AnalyzedToken)newTokens.get(0)).hasNoTag()) {
                    for (int i = 0; i < newTokens.size(); ++i) {
                        AnalyzedToken analyzedToken = (AnalyzedToken)newTokens.get(i);
                        if (!newWord.equals(analyzedToken.getToken())) continue;
                        String lemma = analyzedToken.getLemma();
                        AnalyzedToken newToken = new AnalyzedToken(word, analyzedToken.getPOSTag(), lemma);
                        newTokens.set(i, newToken);
                    }
                    tokens = newTokens;
                }
            } else if (StringUtils.isAllUpperCase((CharSequence)word)) {
                String newWord = StringUtils.capitalize((String)StringUtils.lowerCase((String)word));
                List<AnalyzedToken> newTokens = super.getAnalyzedTokens(newWord);
                if (!((AnalyzedToken)newTokens.get(0)).hasNoTag()) {
                    for (int i = 0; i < newTokens.size(); ++i) {
                        AnalyzedToken analyzedToken = (AnalyzedToken)newTokens.get(i);
                        String lemma = analyzedToken.getLemma();
                        AnalyzedToken newToken = new AnalyzedToken(word, analyzedToken.getPOSTag(), lemma);
                        newTokens.set(i, newToken);
                    }
                    tokens = newTokens;
                }
            } else if (word.endsWith("\u043c\u00b2") || word.endsWith("\u043c\u00b3")) {
                tokens = super.getAnalyzedTokens(word.substring(0, word.length() - 1));
            } else if (word.contains("\u0491")) {
                tokens = this.convertTokens(tokens, word, "\u0491", "\u0433", ":alt");
            } else if (word.contains("\u0456\u044f")) {
                tokens = this.convertTokens(tokens, word, "\u0456\u044f", "\u0456\u0430", ":alt");
            } else if (word.endsWith("\u0442\u0435\u0440")) {
                tokens = this.convertTokens(tokens, word, "\u0442\u0435\u0440", "\u0442\u0440", ":alt");
            }
        }
        return tokens;
    }

    private List<AnalyzedToken> convertTokens(List<AnalyzedToken> origTokens, String word, String str, String dictStr, String additionalTag) {
        String newWord = word.replace(str, dictStr);
        List newTokens = super.getAnalyzedTokens(newWord);
        if (((AnalyzedToken)newTokens.get(0)).hasNoTag()) {
            return origTokens;
        }
        for (int i = 0; i < newTokens.size(); ++i) {
            String lemma;
            AnalyzedToken analyzedToken = (AnalyzedToken)newTokens.get(i);
            String posTag = analyzedToken.getPOSTag();
            if (!PosTagHelper.hasPosTagPart(analyzedToken, additionalTag)) {
                posTag = posTag + additionalTag;
            }
            if ((lemma = analyzedToken.getLemma()) != null) {
                lemma = lemma.replace(dictStr, str);
            }
            AnalyzedToken newToken = new AnalyzedToken(word, posTag, lemma);
            newTokens.set(i, newToken);
        }
        return newTokens;
    }

    private static char getOtherHyphen(String word) {
        if (word.indexOf(8211) != -1) {
            return '\u2013';
        }
        return '\u0000';
    }

    List<AnalyzedToken> asAnalyzedTokenListForTaggedWordsInternal(String word, List<TaggedWord> taggedWords) {
        return super.asAnalyzedTokenListForTaggedWords(word, taggedWords);
    }

    public WordTagger getWordTagger() {
        return super.getWordTagger();
    }
}

