/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.uk.HiddenCharacterRule;
import org.languagetool.rules.uk.MixedAlphabetsRule;
import org.languagetool.rules.uk.MorfologikUkrainianSpellerRule;
import org.languagetool.rules.uk.SimpleReplaceRule;
import org.languagetool.rules.uk.SimpleReplaceSoftRule;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementNounVerbRule;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.UkrainianWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.uk.UkrainianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.uk.UkrainianHybridDisambiguator;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.uk.UkrainianWordTokenizer;

public class Ukrainian
extends Language {
    private static final List<String> RULE_FILES = Arrays.asList("grammar-spelling.xml", "grammar-grammar.xml", "grammar-barbarism.xml", "grammar-style.xml", "grammar-punctuation.xml");
    private Tagger tagger;
    private SRXSentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;

    public Pattern getIgnoredCharactersRegex() {
        return Pattern.compile("[\u00ad\u0301]");
    }

    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    public String getName() {
        return "Ukrainian";
    }

    public String getShortCode() {
        return "uk";
    }

    public String[] getCountries() {
        return new String[]{"UA"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new UkrainianTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new UkrainianSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new UkrainianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new UkrainianWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public SRXSentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin"), new Contributor("Maksym Davydov")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"\u041c\u0438 \u043e\u0431\u0456\u0434\u0430\u043b\u0438 \u0431\u043e\u0440\u0449\u0435\u043c<marker> ,</marker> \u043f\u043b\u043e\u0432\u043e\u043c \u0456 \u0441\u0430\u043b\u0430\u0442\u043e\u043c."), Example.fixed((String)"\u041c\u0438 \u043e\u0431\u0456\u0434\u0430\u043b\u0438 \u0431\u043e\u0440\u0449\u0435\u043c<marker>,</marker> \u043f\u043b\u043e\u0432\u043e\u043c \u0456 \u0441\u0430\u043b\u0430\u0442\u043e\u043c")), new MultipleWhitespaceRule(messages, (Language)this), new UkrainianWordRepeatRule(messages, this), new MorfologikUkrainianSpellerRule(messages, this), new TokenAgreementNounVerbRule(messages), new TokenAgreementAdjNounRule(messages), new TokenAgreementPrepNounRule(messages), new MixedAlphabetsRule(messages), new SimpleReplaceRule(messages), new SimpleReplaceSoftRule(messages), new HiddenCharacterRule(messages)});
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dirBase = dataBroker.getRulesDir() + "/" + this.getShortCode() + "/";
        for (String ruleFile : RULE_FILES) {
            ruleFileNames.add(dirBase + ruleFile);
        }
        return ruleFileNames;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

