/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;

public class TokenAgreementRule
extends Rule {
    private static final String NO_VIDMINOK_SUBSTR = ":nv";
    private static final String REQUIRE_VIDMINOK_SUBSTR = ":rv_";
    private static final String VIDMINOK_SUBSTR = ":v_";
    static final Pattern REQUIRE_VIDMINOK_REGEX = Pattern.compile(":r(v_[a-z]+)");
    private static final Pattern VIDMINOK_REGEX = Pattern.compile(":(v_[a-z]+)");
    private static final String reqAnimInanimRegex = ":r(?:in)?anim";
    private static final Pattern REQ_ANIM_INANIM_PATTERN = Pattern.compile(":r(?:in)?anim");
    private final Ukrainian ukrainian = new Ukrainian();
    private static final Set<String> STREETS = new HashSet<String>(Arrays.asList("\u0428\u0442\u0440\u0430\u0441\u0441\u0435", "\u0448\u0442\u0440\u0430\u0441\u0441\u0435", "\u0410\u0432\u0435\u043d\u044e", "\u0430\u0432\u0435\u043d\u044e", "\u0421\u0442\u0440\u0456\u0442", "\u0441\u0442\u0440\u0456\u0442", "\u0421\u044c\u043e\u0440\u043a\u043b", "\u0421\u043a\u0432\u0435\u0440"));
    private static final Set<String> NAMES = new HashSet<String>(Arrays.asList("\u0456\u043c'\u044f", "\u043f\u0440\u0456\u0437\u0432\u0438\u0449\u0435"));

    public TokenAgreementRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_TOKEN_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u0456";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u0456";
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        boolean insideMultiword = false;
        AnalyzedTokenReadings reqTokenReadings = null;
        for (int i = 0; i < tokens.length; ++i) {
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag == null || posTag.contains(IPOSTag.unknown.getText()) || posTag.equals("SENT_START")) {
                reqTokenReadings = null;
                continue;
            }
            String thisToken = tokenReadings.getToken();
            if (i > 1 && thisToken.length() == 1 && Character.isUpperCase(thisToken.charAt(0)) && tokenReadings.isWhitespaceBefore() && !tokens[i - 1].getToken().matches("[:\u2014\u2013-]")) {
                reqTokenReadings = null;
                continue;
            }
            AnalyzedToken multiwordReqToken = TokenAgreementRule.getMultiwordToken(tokenReadings);
            if (multiwordReqToken != null) {
                String mwPosTag = multiwordReqToken.getPOSTag();
                insideMultiword = !mwPosTag.startsWith("</");
                if (mwPosTag.startsWith("</") && mwPosTag.contains(REQUIRE_VIDMINOK_SUBSTR)) {
                    posTag = multiwordReqToken.getPOSTag();
                    reqTokenReadings = tokenReadings;
                    continue;
                }
                if (mwPosTag.contains("adv") || mwPosTag.contains("insert")) continue;
                reqTokenReadings = null;
                continue;
            }
            if (insideMultiword) continue;
            String token = tokenReadings.getAnalyzedToken(0).getToken();
            if (posTag.contains(REQUIRE_VIDMINOK_SUBSTR) && tokenReadings.getReadingsLength() == 1) {
                String prep = token;
                if (prep.equals("\u0437\u0430") && this.reverseSearch(tokens, i, "\u0449\u043e") || prep.equalsIgnoreCase("\u043f\u043e\u043d\u0430\u0434")) continue;
                if ((prep.equalsIgnoreCase("\u043e\u043a\u0440\u0456\u043c") || prep.equalsIgnoreCase("\u043a\u0440\u0456\u043c")) && tokens.length > i + 1 && tokens[i + 1].getAnalyzedToken(0).getToken().equalsIgnoreCase("\u044f\u043a")) {
                    reqTokenReadings = null;
                    continue;
                }
                reqTokenReadings = tokenReadings;
                continue;
            }
            if (reqTokenReadings == null) continue;
            ArrayList<String> posTagsToFind = new ArrayList<String>();
            String reqPosTag = reqTokenReadings.getAnalyzedToken(0).getPOSTag();
            String prep = reqTokenReadings.getAnalyzedToken(0).getLemma();
            if (prep.equalsIgnoreCase("\u0437\u0430\u043c\u0456\u0441\u0442\u044c")) {
                posTagsToFind.add("v_naz");
            }
            Matcher matcher = REQUIRE_VIDMINOK_REGEX.matcher(reqPosTag);
            while (matcher.find()) {
                posTagsToFind.add(matcher.group(1));
            }
            for (AnalyzedToken readingToken : tokenReadings) {
                if (!IPOSTag.numr.match(readingToken.getPOSTag())) continue;
                posTagsToFind.add("v_naz");
                break;
            }
            if (!TokenAgreementRule.hasVidmPosTag(posTagsToFind, tokenReadings)) {
                if (this.isTokenToSkip(tokenReadings)) continue;
                if ((prep.equalsIgnoreCase("\u0432") || prep.equalsIgnoreCase("\u0443") || prep.equals("\u043c\u0435\u0436\u0438") || prep.equals("\u043c\u0456\u0436") || prep.equals("\u043d\u0430")) && PosTagHelper.hasPosTag(tokenReadings, "noun:anim.*:p:v_naz[^&]*")) {
                    reqTokenReadings = null;
                    continue;
                }
                if (prep.equalsIgnoreCase("\u043d\u0430")) {
                    if (Character.isUpperCase(token.charAt(0)) && posTag.matches("noun.*?:.:v_rod.*") || posTag.matches(".*[fl]name.*") && (i > 1 && NAMES.contains(tokens[i - 2].getAnalyzedToken(0).getToken()) || i > 2 && NAMES.contains(tokens[i - 3].getAnalyzedToken(0).getLemma()))) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if (token.equals("\u043c\u0430\u043d\u0435\u0440")) {
                        reqTokenReadings = null;
                        continue;
                    }
                }
                if (prep.equalsIgnoreCase("\u0437") && token.equals("\u0440\u0430\u043d\u0430")) {
                    reqTokenReadings = null;
                    continue;
                }
                if (prep.equalsIgnoreCase("\u0432\u0456\u0434")) {
                    if (token.equalsIgnoreCase("\u0430") || token.equals("\u0440\u0430\u043d\u0430") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u043c\u0430\u043b\u0430")) {
                        reqTokenReadings = null;
                        continue;
                    }
                } else if (prep.equalsIgnoreCase("\u0434\u043e") && (token.equalsIgnoreCase("\u044f") || token.equals("\u043a\u043e\u0440\u043a\u0438") || token.equals("\u0432\u0435\u043b\u0438\u043a\u0430"))) {
                    reqTokenReadings = null;
                    continue;
                }
                if (tokens.length > i + 1) {
                    if (TokenAgreementRule.isCapitalized(token) && STREETS.contains(tokens[i + 1].getAnalyzedToken(0).getToken())) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if (PosTagHelper.hasPosTag(tokens[i + 1], "num.*") && (token.equals("\u043c\u0456\u043d\u0443\u0441") || token.equals("\u043f\u043b\u044e\u0441") || token.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c") || token.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c"))) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if (PosTagHelper.hasPosTag(tokenReadings, "noun.*?:.:v_oru.*") && tokens[i + 1].hasPartialPosTag("adjp")) continue;
                    if ((prep.equalsIgnoreCase("\u0447\u0435\u0440\u0435\u0437") || prep.equalsIgnoreCase("\u043d\u0430")) && (posTag.startsWith("noun:inanim:p:v_naz") || posTag.startsWith("noun:inanim:p:v_rod")) && IPOSTag.isNum(tokens[i + 1].getAnalyzedToken(0).getPOSTag())) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if ((token.equals("\u0432\u0430\u043c\u0438") || token.equals("\u0442\u043e\u0431\u043e\u044e") || token.equals("\u0457\u043c\u0438")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u0436") || (token.equals("\u0441\u043e\u0431\u0456") || token.equals("\u0439\u043e\u043c\u0443") || token.equals("\u0457\u043c")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u043f\u043e\u0434\u0456\u0431\u043d") || (token.equals("\u0443\u0441\u0456\u043c") || token.equals("\u0432\u0441\u0456\u043c")) && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u0432\u0456\u0434\u043e\u043c")) continue;
                    if (prep.equalsIgnoreCase("\u0434\u043e") && token.equals("\u0441\u0445\u0456\u0434") && tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u0441\u043e\u043d\u0446\u044f")) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if (tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u00ab") && tokens[i].getAnalyzedToken(0).getPOSTag().contains(":abbr")) {
                        reqTokenReadings = null;
                        continue;
                    }
                    if (tokens.length > i + 2) {
                        if (PosTagHelper.hasPosTag(tokenReadings, "adj.*:[mfn]:v_rod.*")) {
                            String genders = PosTagHelper.getGenders(tokenReadings, "adj.*:[mfn]:v_rod.*");
                            if (PosTagHelper.hasPosTag(tokens[i + 1], "noun.*:[" + genders + "]:v_rod.*")) {
                                ++i;
                                continue;
                            }
                        }
                        if ((token.equals("\u043d\u0456\u043a\u043e\u043c\u0443") || token.equals("\u043d\u0456\u043a\u0438\u043c") || token.equals("\u043d\u0456\u0447\u0438\u043c") || token.equals("\u043d\u0456\u0447\u043e\u043c\u0443")) && tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u043d\u0435")) continue;
                    }
                }
                RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, reqTokenReadings, posTagsToFind);
                ruleMatches.add(potentialRuleMatch);
            }
            reqTokenReadings = null;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean isCapitalized(String token) {
        return token.length() > 1 && Character.isUpperCase(token.charAt(0)) && Character.isLowerCase(token.charAt(1));
    }

    private boolean reverseSearch(AnalyzedTokenReadings[] tokens, int pos, String string) {
        for (int i = pos - 1; i >= 0 && i > pos - 4; --i) {
            if (!tokens[i].getAnalyzedToken(0).getToken().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenToSkip(AnalyzedTokenReadings tokenReadings) {
        for (AnalyzedToken token : tokenReadings) {
            if (!IPOSTag.adv.match(token.getPOSTag()) && !IPOSTag.contains(token.getPOSTag(), "adv>") && !IPOSTag.insert.match(token.getPOSTag())) continue;
            return true;
        }
        return false;
    }

    static boolean hasVidmPosTag(Collection<String> posTagsToFind, AnalyzedTokenReadings tokenReadings) {
        boolean vidminokFound = false;
        for (AnalyzedToken token : tokenReadings) {
            String posTag = token.getPOSTag();
            if (posTag == null) {
                if (tokenReadings.getReadingsLength() != 1) continue;
                return true;
            }
            if (posTag.contains(NO_VIDMINOK_SUBSTR)) {
                return true;
            }
            if (!posTag.contains(VIDMINOK_SUBSTR)) continue;
            vidminokFound = true;
            for (String posTagToFind : posTagsToFind) {
                if (!posTag.contains(posTagToFind)) continue;
                return true;
            }
        }
        return !vidminokFound;
    }

    /*
     * WARNING - void declaration
     */
    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, AnalyzedTokenReadings reqTokenReadings, List<String> posTagsToFind) {
        void var10_17;
        String tokenString = tokenReadings.getToken();
        Synthesizer ukrainianSynthesizer = this.ukrainian.getSynthesizer();
        ArrayList<String> suggestions = new ArrayList<String>();
        String requiredPostTagsRegEx = ":(" + String.join((CharSequence)"|", posTagsToFind) + ")";
        for (Object analyzedToken : tokenReadings.getReadings()) {
            String string = analyzedToken.getPOSTag();
            if (string == null) continue;
            String requiredPostTagsRegExToApply = requiredPostTagsRegEx;
            Matcher matcher = REQ_ANIM_INANIM_PATTERN.matcher(string);
            requiredPostTagsRegExToApply = matcher.find() ? requiredPostTagsRegExToApply + matcher.group(0) : requiredPostTagsRegExToApply + "(?::r(?:in)?anim)?";
            String posTag = string.replaceFirst(":v_[a-z]+", requiredPostTagsRegExToApply);
            try {
                String[] synthesized = ukrainianSynthesizer.synthesize((AnalyzedToken)analyzedToken, posTag, true);
                suggestions.addAll(Arrays.asList(synthesized));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (suggestions.size() > 0) {
            suggestions = new ArrayList(new LinkedHashSet(suggestions));
        }
        ArrayList<String> reqVidminkyNames = new ArrayList<String>();
        for (String string : posTagsToFind) {
            reqVidminkyNames.add(PosTagHelper.VIDMINKY_MAP.get(string));
        }
        ArrayList<String> foundVidminkyNames = new ArrayList<String>();
        for (AnalyzedToken token : tokenReadings) {
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !posTag2.contains(VIDMINOK_SUBSTR)) continue;
            String vidmName = PosTagHelper.VIDMINKY_MAP.get(posTag2.replaceFirst("^.*" + VIDMINOK_REGEX + ".*$", "$1"));
            if (foundVidminkyNames.contains(vidmName)) {
                if (!posTag2.contains(":p:")) continue;
                vidmName = vidmName + " (\u043c\u043d.)";
                foundVidminkyNames.add(vidmName);
                continue;
            }
            foundVidminkyNames.add(vidmName);
        }
        String string = MessageFormat.format("\u041f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab{0}\u00bb \u0432\u0438\u043c\u0430\u0433\u0430\u0454 \u0456\u043d\u0448\u043e\u0433\u043e \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0430: {1}, \u0430 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e: {2}", reqTokenReadings.getToken(), String.join((CharSequence)", ", reqVidminkyNames), String.join((CharSequence)", ", foundVidminkyNames));
        if (tokenString.equals("\u0457\u0445") && requiredPostTagsRegEx != null) {
            String string2 = string + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e \u0442\u0443\u0442 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u0456\u0439\u043d\u0438\u0439 \u0437\u0430\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab\u0457\u0445\u043d\u0456\u0439\u00bb?";
            try {
                String newYihPostag = "adj:p" + requiredPostTagsRegEx + ".*";
                String[] synthesized = ukrainianSynthesizer.synthesize(new AnalyzedToken("\u0457\u0445\u043d\u0456\u0439", "adj:m:v_naz:&pron:pos", "\u0457\u0445\u043d\u0456\u0439"), newYihPostag, true);
                suggestions.addAll(Arrays.asList(synthesized));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (reqTokenReadings.getToken().equalsIgnoreCase("\u043e")) {
            for (AnalyzedToken token : tokenReadings.getReadings()) {
                String posTag2 = token.getPOSTag();
                if (!posTag2.matches("noun:anim.*:v_naz.*")) continue;
                String string3 = string + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e \u0442\u0443\u0442 \u00ab\u043e\u00bb \u2014 \u0446\u0435 \u0432\u0438\u0433\u0443\u043a \u0456 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e \u043a\u043b\u0438\u0447\u043d\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a?";
                try {
                    String[] synthesized;
                    String newPostag = posTag2.replace("v_naz", "v_kly");
                    for (String string4 : synthesized = ukrainianSynthesizer.synthesize(token, newPostag, false)) {
                        if (string4.equals(token.getToken()) || suggestions.contains(string4)) continue;
                        suggestions.add(string4);
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, tokenReadings.getStartPos(), tokenReadings.getEndPos(), (String)var10_17, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(suggestions);
        return potentialRuleMatch;
    }

    @Nullable
    private static AnalyzedToken getMultiwordToken(AnalyzedTokenReadings analyzedTokenReadings) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings) {
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !posTag.startsWith("<")) continue;
            return analyzedToken;
        }
        return null;
    }

    public void reset() {
    }
}

