/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.TokenAgreementRule;
import org.languagetool.tagging.uk.PosTagHelper;

public class TokenInflectionAgreementRule
extends Rule {
    private static final List<String> CONJ_FOR_PLURAL = Arrays.asList("\u0456", "\u0439", "\u0442\u0430", "\u0447\u0438", "\u0430\u0431\u043e");
    private static final String NO_VIDMINOK_SUBSTR = ":nv";
    private static final Pattern ADJ_INFLECTION_PATTERN = Pattern.compile(":([mfnp]):(v_...)(:r(in)?anim)?");
    private static final Pattern NOUN_INFLECTION_PATTERN = Pattern.compile(":((?:[iu]n)?anim):([mfnp]):(v_...)");
    private static final Map<String, Set<String>> inflectionControl = TokenInflectionAgreementRule.loadMap("/uk/case_government.txt");

    public TokenInflectionAgreementRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setDefaultOff();
    }

    public final String getId() {
        return "UK_ADJ_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0456\u0432/\u0447\u0438\u0441\u043b\u0430/\u0440\u043e\u0434\u0443 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0456\u0432 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0456\u0432";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0456\u0432 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0456\u0432";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        ArrayList<AnalyzedToken> adjTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings adjAnalyzedTokenReadins = null;
        boolean adjpPresent = false;
        boolean numrPresent = false;
        boolean pronPresent = false;
        block0: for (int i = 0; i < tokens.length; ++i) {
            List<Inflection> slaveInflections;
            Iterator token2;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag == null || posTag.equals("SENT_START")) {
                adjTokenReadings.clear();
                continue;
            }
            if (adjTokenReadings.isEmpty()) {
                if (i == tokens.length - 1) continue;
                adjpPresent = false;
                numrPresent = false;
                pronPresent = false;
                for (Iterator token2 : tokenReadings) {
                    String adjPosTag = token2.getPOSTag();
                    if (adjPosTag == null) {
                        System.err.println("Null tag: " + tokenReadings);
                        continue;
                    }
                    if (adjPosTag.startsWith("adj") && !adjPosTag.contains(NO_VIDMINOK_SUBSTR)) {
                        adjTokenReadings.add((AnalyzedToken)token2);
                        adjAnalyzedTokenReadins = tokenReadings;
                        if (adjPosTag.contains("&pron")) {
                            pronPresent = true;
                        }
                        if (adjPosTag.startsWith("<")) {
                            adjTokenReadings.clear();
                            continue block0;
                        }
                        if (Arrays.asList("\u0434\u0435\u0441\u044f\u0442\u0438\u0439", "\u0441\u043e\u0442\u0438\u0439", "\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439").contains(token2.getLemma().toLowerCase()) && adjPosTag.matches(".*:[fp]:.*")) {
                            adjTokenReadings.clear();
                            continue block0;
                        }
                        if (i > 1 && Arrays.asList("\u044f\u043a\u0438\u0439", "\u043a\u043e\u0442\u0440\u0438\u0439").contains(token2.getLemma()) && this.reverseConjFind(tokens, i - 1, 3)) {
                            adjTokenReadings.clear();
                            continue block0;
                        }
                        if (i > 1 && adjPosTag.contains(":p:v_rod") && tokens[i - 1].getAnalyzedToken(0).getLemma() != null && tokens[i - 1].getAnalyzedToken(0).getLemma().matches(".*[2-4]|\u0434\u0432\u0430|\u0442\u0440\u0438|\u0447\u043e\u0442\u0438\u0440\u0438") && PosTagHelper.hasPosTag(tokens[i + 1], ".*:p:v_naz.*")) {
                            adjTokenReadings.clear();
                            continue block0;
                        }
                        if (Arrays.asList("\u0441\u0430\u043c", "\u0441\u0430\u043c\u0435").contains(token2.getToken().toLowerCase())) {
                            adjTokenReadings.clear();
                            continue block0;
                        }
                        if (i > 0 && PosTagHelper.hasPosTag(tokens[i - 1], "(</)?prep.*") && Arrays.asList("\u044f\u043a\u0438\u0439", "\u044f\u043a\u0438\u0439\u0441\u044c", "\u0442\u0430\u043a\u0438\u0439", "\u043a\u043e\u0442\u0440\u0438\u0439", "\u0443\u0432\u0435\u0441\u044c", "\u0432\u0435\u0441\u044c", "\u043e\u0441\u0442\u0430\u043d\u043d\u0456\u0439").contains(token2.getLemma())) {
                            Collection<String> governedCases = this.getPrepGovernedCases(tokens[i - 1]);
                            boolean boo = false;
                            for (String governedCase : governedCases) {
                                if (!token2.getPOSTag().contains(governedCase)) continue;
                                boo = true;
                                break;
                            }
                            if (boo) {
                                adjTokenReadings.clear();
                                continue block0;
                            }
                        }
                        if (adjPosTag.contains("adjp:pasv")) {
                            adjpPresent = true;
                        }
                        if (adjPosTag.contains(":&numr")) {
                            if (token2.getLemma().matches("([12][0-9])?[0-9][0-9]-.*")) {
                                adjTokenReadings.clear();
                                continue block0;
                            }
                            if (i > 0 && Arrays.asList("\u043d\u0430", "\u0432", "\u0443", "\u0437\u0430", "\u043e").contains(tokens[i - 1].getAnalyzedToken(0).getLemma())) {
                                adjTokenReadings.clear();
                                continue block0;
                            }
                            numrPresent = true;
                        }
                        if (i <= 0 || !adjPosTag.contains(":v_oru") || !TokenInflectionAgreementRule.hasButyLemma(tokens[i - 1])) continue;
                        adjTokenReadings.clear();
                        continue block0;
                    }
                    if (adjPosTag.equals("SENT_END")) continue;
                    adjTokenReadings.clear();
                    continue block0;
                }
                continue;
            }
            ArrayList<AnalyzedToken> slaveTokenReadings = new ArrayList<AnalyzedToken>();
            token2 = tokenReadings.iterator();
            while (token2.hasNext()) {
                AnalyzedToken token3 = (AnalyzedToken)token2.next();
                String posTag2 = token3.getPOSTag();
                if (posTag2 == null) {
                    System.err.println("Null tag: " + tokenReadings);
                    continue;
                }
                if (posTag2.startsWith("noun") && !posTag2.contains(NO_VIDMINOK_SUBSTR)) {
                    if (posTag2.contains("&pron")) {
                        slaveTokenReadings.clear();
                        break;
                    }
                    if (token3.getToken().equals("\u0456\u043c.")) {
                        adjTokenReadings.clear();
                        break;
                    }
                    if (token3.getToken().equals("\u0432\u0456\u043a\u043e\u043c") && adjAnalyzedTokenReadins.getAnalyzedToken(0).getToken().matches(".*\u0441\u0442\u0430\u0440\u0448\u0438\u0439|.*\u043c\u043e\u043b\u043e\u0434\u0448\u0438\u0439")) {
                        adjTokenReadings.clear();
                        break;
                    }
                    if (posTag2.startsWith("</")) {
                        adjTokenReadings.clear();
                        break;
                    }
                    if (adjpPresent && posTag2.contains("v_oru")) {
                        slaveTokenReadings.clear();
                        break;
                    }
                    if (numrPresent && Arrays.asList("\u0440\u0430\u043d\u043e\u043a", "\u0432\u0435\u0447\u0456\u0440", "\u043d\u0456\u0447").contains(token3.getLemma())) {
                        slaveTokenReadings.clear();
                        break;
                    }
                    if (pronPresent && token3.getLemma().equals("\u0440\u0435\u0448\u0442\u0430")) {
                        slaveTokenReadings.clear();
                        break;
                    }
                    slaveTokenReadings.add(token3);
                    continue;
                }
                if (posTag2.equals("SENT_END")) continue;
                slaveTokenReadings.clear();
                break;
            }
            if (slaveTokenReadings.isEmpty()) {
                adjTokenReadings.clear();
                continue;
            }
            List<Inflection> masterInflections = this.getAdjInflections(adjTokenReadings);
            if (Collections.disjoint(masterInflections, slaveInflections = this.getNounInflections(slaveTokenReadings))) {
                if (i < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadins, "adj:p:.*") && this.forwardConjFind(tokens, i + 1, 2) && !this.disjointIgnoreGender(masterInflections, slaveInflections)) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (i > 1 && PosTagHelper.hasPosTag(tokenReadings, "noun:.*:p:(v_naz|v_zna).*") && Arrays.asList("\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438").contains(tokens[i - 2].getAnalyzedToken(0).getLemma()) && PosTagHelper.hasPosTag(adjAnalyzedTokenReadins, "adj.*:p:v_rod.*")) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (i > 1 && PosTagHelper.hasPosTag(tokens[i - 2], "noun:.*") && !Collections.disjoint(masterInflections, this.getNounInflections(tokens[i - 2].getReadings()))) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (i > 2 && PosTagHelper.hasPosTag(tokenReadings, "noun:.*:p:.*") && this.reverseConjFind(tokens, i - 2, 2) && !this.disjointIgnoreGender(masterInflections, slaveInflections)) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (i > 2 && PosTagHelper.hasPosTag(tokenReadings, "noun:.*:p:.*") && Arrays.asList("\u0430\u043d\u0456", "\u0442\u0430\u043a\u043e\u0436").contains(tokens[i - 2].getAnalyzedToken(0).getLemma()) && !this.disjointIgnoreGender(masterInflections, slaveInflections)) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (i > 1 && PosTagHelper.hasPosTag(tokens[i - 2], "verb:.*") && PosTagHelper.hasPosTag(tokens[i - 1], "adj.*:v_oru.*") && PosTagHelper.hasPosTag(tokens[i], "noun:.*:v_zna.*") && this.genderMatches(masterInflections, slaveInflections, "v_oru", "v_zna")) {
                    adjTokenReadings.clear();
                    continue;
                }
                if (this.inflectionControlMatches(adjTokenReadings, slaveInflections)) {
                    adjTokenReadings.clear();
                    continue;
                }
                String msg = String.format("\u041d\u0435\u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u0456 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c: \"%s\" (%s) \u0456 \"%s\" (%s)", adjTokenReadings.get(0).getToken(), masterInflections, slaveTokenReadings.get(0).getToken(), slaveInflections);
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, adjAnalyzedTokenReadins.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                ruleMatches.add(potentialRuleMatch);
            }
            adjTokenReadings.clear();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean hasButyLemma(AnalyzedTokenReadings analyzedTokenReadings) {
        for (AnalyzedToken analyzedToken : analyzedTokenReadings.getReadings()) {
            if (!"\u0431\u0443\u0442\u0438".equalsIgnoreCase(analyzedToken.getLemma())) continue;
            return true;
        }
        return false;
    }

    private boolean genderMatches(List<Inflection> masterInflections, List<Inflection> slaveInflections, String masterCaseFilter, String slaveCaseFilter) {
        for (Inflection masterInflection : masterInflections) {
            for (Inflection slaveInflection : slaveInflections) {
                if (!masterInflection._case.equals(masterCaseFilter) || !slaveInflection._case.equals(slaveCaseFilter) || !slaveInflection.gender.equals(masterInflection.gender)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<String> getPrepGovernedCases(AnalyzedTokenReadings analyzedTokenReadings) {
        ArrayList<String> reqCases = new ArrayList<String>();
        for (AnalyzedToken reading : analyzedTokenReadings.getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.contains("rv_")) continue;
            Matcher matcher = TokenAgreementRule.REQUIRE_VIDMINOK_REGEX.matcher(posTag);
            while (matcher.find()) {
                reqCases.add(matcher.group(1));
            }
            break block0;
        }
        return reqCases;
    }

    private boolean reverseConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i > pos - depth && i >= 0; --i) {
            if (!CONJ_FOR_PLURAL.contains(tokens[i].getAnalyzedToken(0).getLemma()) && !tokens[i].getAnalyzedToken(0).getToken().equals(",")) continue;
            return true;
        }
        return false;
    }

    private boolean forwardConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i < tokens.length && i <= pos + depth; ++i) {
            if (!CONJ_FOR_PLURAL.contains(tokens[i].getAnalyzedToken(0).getLemma()) && !tokens[i].getAnalyzedToken(0).getToken().equals(",")) continue;
            return true;
        }
        return false;
    }

    private boolean inflectionControlMatches(List<AnalyzedToken> adjTokenReadings, List<Inflection> slaveInflections) {
        return adjTokenReadings.stream().map(p -> p.getLemma()).distinct().anyMatch(item -> {
            Set<String> inflections = inflectionControl.get(item);
            if (inflections != null) {
                for (Inflection inflection : slaveInflections) {
                    if (!inflections.contains(inflection._case)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private List<Inflection> getAdjInflections(List<AnalyzedToken> adjTokenReadings) {
        ArrayList<Inflection> masterInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : adjTokenReadings) {
            String posTag2 = token.getPOSTag();
            Matcher matcher = ADJ_INFLECTION_PATTERN.matcher(posTag2);
            matcher.find();
            String gen = matcher.group(1);
            String vidm = matcher.group(2);
            String animTag = null;
            if (matcher.group(3) != null) {
                animTag = matcher.group(3).substring(2);
            }
            masterInflections.add(new Inflection(gen, vidm, animTag));
        }
        return masterInflections;
    }

    private List<Inflection> getNounInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> slaveInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            String posTag2 = token.getPOSTag();
            Matcher matcher = NOUN_INFLECTION_PATTERN.matcher(posTag2);
            if (!matcher.find()) continue;
            String gen = matcher.group(2);
            String vidm = matcher.group(3);
            String animTag = matcher.group(1);
            slaveInflections.add(new Inflection(gen, vidm, animTag));
        }
        return slaveInflections;
    }

    private boolean disjointIgnoreGender(List<Inflection> masterInflections, List<Inflection> slaveInflections) {
        for (Inflection mInflection : masterInflections) {
            for (Inflection sInflection : slaveInflections) {
                if (!mInflection.equalsIgnoreGender(sInflection)) continue;
                return false;
            }
        }
        return true;
    }

    public void reset() {
    }

    /*
     * Exception decompiling
     */
    private static Map<String, Set<String>> loadMap(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class Inflection {
        final String gender;
        final String _case;
        final String animTag;

        public Inflection(String gender, String _case, String animTag) {
            this.gender = gender;
            this._case = _case;
            this.animTag = animTag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._case == null ? 0 : this._case.hashCode());
            result = 31 * result + (this.animTag == null ? 0 : this.animTag.hashCode());
            result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Inflection other = (Inflection)obj;
            return this.gender.equals(other.gender) && this._case.equals(other._case) && (this.animTag == null || other.animTag == null || !this.animMatters() || !other.isAnimalSensitive() || this.animTag.equals(other.animTag));
        }

        public boolean equalsIgnoreGender(Inflection other) {
            return this._case.equals(other._case) && (this.animTag == null || other.animTag == null || !this.animMatters() || this.animTag.equals(other.animTag));
        }

        private boolean animMatters() {
            return this._case.equals("v_zna") && this.isAnimalSensitive();
        }

        private boolean isAnimalSensitive() {
            return "mp".contains(this.gender);
        }

        public String toString() {
            return ":" + this.gender + ":" + this._case + (this.animMatters() ? "_" + this.animTag : "");
        }
    }
}

