/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.uk.IPOSTag;

public final class MorfologikUkrainianSpellerRule
extends MorfologikSpellerRule {
    private static final String ABBREVIATION_CHAR = ".";
    private static final String RESOURCE_FILENAME = "/uk/hunspell/uk_UA.dict";
    private static final Pattern UKRAINIAN_LETTERS = Pattern.compile(".*[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490].*");

    public MorfologikUkrainianSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_UK_UA";
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (word.endsWith("\u00b2") || word.endsWith("\u00b3")) {
            word = word.substring(0, word.length() - 1);
        }
        return super.isMisspelled(speller, word);
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        String word = tokens[idx].getToken();
        if (!UKRAINIAN_LETTERS.matcher(word).matches()) {
            return true;
        }
        if (super.ignoreToken(tokens, idx)) {
            return true;
        }
        if (idx < tokens.length - 1 && tokens[idx + 1].getToken().equals(ABBREVIATION_CHAR)) {
            if (super.ignoreWord(word + ABBREVIATION_CHAR)) {
                return true;
            }
            if (word.matches("[\u0410-\u042f\u0406\u0407\u0404\u0490]")) {
                return true;
            }
        }
        if (word.contains("-") || word.contains("\u2011") || word.endsWith(ABBREVIATION_CHAR)) {
            return this.hasGoodTag(tokens[idx]);
        }
        return false;
    }

    private boolean hasGoodTag(AnalyzedTokenReadings tokens) {
        for (AnalyzedToken analyzedToken : tokens) {
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || posTag.equals("SENT_START") || posTag.equals("SENT_END") || posTag.contains(IPOSTag.bad.getText()) || posTag.contains(":inanim") && posTag.contains(":v_kly")) continue;
            return true;
        }
        return false;
    }
}

