/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.uk.HiddenCharacterRule;
import org.languagetool.rules.uk.MixedAlphabetsRule;
import org.languagetool.rules.uk.MorfologikUkrainianSpellerRule;
import org.languagetool.rules.uk.SimpleReplaceRule;
import org.languagetool.rules.uk.SimpleReplaceSoftRule;
import org.languagetool.rules.uk.TokenAgreementRule;
import org.languagetool.rules.uk.UkrainianWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.uk.UkrainianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.uk.UkrainianHybridDisambiguator;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.uk.UkrainianWordTokenizer;

public class Ukrainian
extends Language {
    private static final List<String> RULE_FILES = Arrays.asList("grammar-spelling.xml", "grammar-grammar.xml", "grammar-barbarism.xml", "grammar-style.xml", "grammar-punctuation.xml");
    private Tagger tagger;
    private SRXSentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;

    public Pattern getIgnoredCharactersRegex() {
        return Pattern.compile("[\u00ad\u0301]");
    }

    public Locale getLocale() {
        return new Locale(this.getShortName());
    }

    public String getName() {
        return "Ukrainian";
    }

    public String getShortName() {
        return "uk";
    }

    public String[] getCountries() {
        return new String[]{"UA"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new UkrainianTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new UkrainianSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new UkrainianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new UkrainianWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public SRXSentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin"), new Contributor("Maksym Davydov")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new MorfologikUkrainianSpellerRule(messages, this), new MixedAlphabetsRule(messages), new MultipleWhitespaceRule(messages, (Language)this), new UkrainianWordRepeatRule(messages, this), new SimpleReplaceRule(messages), new SimpleReplaceSoftRule(messages), new TokenAgreementRule(messages), new HiddenCharacterRule(messages)});
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dirBase = dataBroker.getRulesDir() + "/" + this.getShortName() + "/";
        for (String ruleFile : RULE_FILES) {
            ruleFileNames.add(dirBase + ruleFile);
        }
        return ruleFileNames;
    }
}

