/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class MixedAlphabetsRule
extends Rule {
    private static final Pattern LIKELY_LATIN_NUMBER = Pattern.compile("[XVI\u0425\u0406]{2,8}");
    private static final Pattern LATIN_NUMBER_WITH_CYRILLICS = Pattern.compile("\u0425{1,3}\u0406{1,3}|\u0406{1,3}\u0425{1,3}|\u0425{2,3}|\u0406{2,3}");
    private static final Pattern MIXED_ALPHABETS = Pattern.compile(".*([a-zA-Z]'?[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490]|[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490]'?[a-zA-Z]).*");
    private static final Pattern CYRILLIC_ONLY = Pattern.compile(".*[\u0431\u0432\u0433\u0491\u0434\u0454\u0436\u0437\u0439\u0457\u043b\u043d\u043f\u0444\u0446\u0447\u0448\u0449\u044c\u044e\u044f\u0411\u0413\u0490\u0414\u0404\u0416\u0417\u0418\u0419\u0407\u041b\u041f\u0424\u0426\u0427\u0428\u0429\u042c\u042e\u042f].*");
    private static final Pattern LATIN_ONLY = Pattern.compile(".*[bdfghjlqrsvzDFGLNQRSUVZ].*");
    private static final Map<Character, Character> toLatMap = new HashMap<Character, Character>();
    private static final Map<Character, Character> toCyrMap = new HashMap<Character, Character>();
    private static final String cyrChars = "\u0430\u0435\u0456\u043a\u043c\u043e\u0440\u0441\u0442\u0443\u0445\u0410\u0412\u0415\u0406\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425";
    private static final String latChars = "aeikmopctyxABEIKMHOPCTYX";

    public MixedAlphabetsRule(ResourceBundle messages) throws IOException {
        super.setCategory(new Category(messages.getString("category_misc")));
    }

    public final String getId() {
        return "UK_MIXED_ALPHABETS";
    }

    public String getDescription() {
        return "\u0417\u043c\u0456\u0448\u0443\u0432\u0430\u043d\u043d\u044f \u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0456 \u0439 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0456";
    }

    public String getShort() {
        return "\u041c\u0456\u0448\u0430\u043d\u0438\u043d\u0430 \u0440\u043e\u0437\u043a\u043b\u0430\u0434\u043e\u043a";
    }

    public String getSuggestion(String word) {
        String highlighted = word.replaceAll("([a-zA-Z])([\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490])", "$1/$2");
        highlighted = highlighted.replaceAll("([\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490])([a-zA-Z])", "$1/$2");
        return " \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u0441\u0443\u043c\u0456\u0448 \u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0456 \u0442\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0456: \u00ab" + highlighted + "\u00bb, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: ";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            RuleMatch potentialRuleMatch;
            ArrayList<String> replacements;
            String tokenString = tokenReadings.getToken();
            if (MIXED_ALPHABETS.matcher(tokenString).matches()) {
                replacements = new ArrayList<String>();
                if (!LATIN_ONLY.matcher(tokenString).matches() && !LIKELY_LATIN_NUMBER.matcher(tokenString).matches()) {
                    replacements.add(MixedAlphabetsRule.toCyrillic(tokenString));
                }
                if (!CYRILLIC_ONLY.matcher(tokenString).matches() || LIKELY_LATIN_NUMBER.matcher(tokenString).matches()) {
                    replacements.add(MixedAlphabetsRule.toLatin(tokenString));
                }
                if (replacements.size() <= 0) continue;
                potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements);
                ruleMatches.add(potentialRuleMatch);
                continue;
            }
            if (!LATIN_NUMBER_WITH_CYRILLICS.matcher(tokenString).matches()) continue;
            replacements = new ArrayList();
            replacements.add(MixedAlphabetsRule.toLatin(tokenString));
            potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, List<String> replacements) {
        String tokenString = tokenReadings.getToken();
        String msg = tokenString + this.getSuggestion(tokenString) + StringUtils.join(replacements, (String)", ");
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + tokenString.length(), msg, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    public void reset() {
    }

    private static String toCyrillic(String word) {
        for (Map.Entry<Character, Character> entry : toCyrMap.entrySet()) {
            word = word.replace(entry.getKey().charValue(), entry.getValue().charValue());
        }
        return word;
    }

    private static String toLatin(String word) {
        for (Map.Entry<Character, Character> entry : toLatMap.entrySet()) {
            word = word.replace(entry.getKey().charValue(), entry.getValue().charValue());
        }
        return word;
    }

    static {
        for (int i = 0; i < cyrChars.length(); ++i) {
            toLatMap.put(Character.valueOf(cyrChars.charAt(i)), Character.valueOf(latChars.charAt(i)));
            toCyrMap.put(Character.valueOf(latChars.charAt(i)), Character.valueOf(cyrChars.charAt(i)));
        }
    }
}

