/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.uk.IPOSTag;

public class UkrainianTagger
extends BaseTagger {
    private static final Pattern NUMBER = Pattern.compile("[+-]?[0-9]+(,[0-9]+)?");
    public static final Map<String, String> VIDMINKY_MAP;

    public final String getFileName() {
        return "/uk/ukrainian.dict";
    }

    public UkrainianTagger() {
        this.setLocale(new Locale("uk", "UA"));
        this.dontTagLowercaseWithUppercase();
    }

    public List<AnalyzedToken> additionalTags(String word) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.number.getText(), word));
            return additionalTaggedTokens;
        }
        return null;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("v_naz", "\u043d\u0430\u0437\u0438\u0432\u043d\u0438\u0439");
        map.put("v_rod", "\u0440\u043e\u0434\u043e\u0432\u0438\u0439");
        map.put("v_dav", "\u0434\u0430\u0432\u0430\u043b\u044c\u043d\u0438\u0439");
        map.put("v_zna", "\u0437\u043d\u0430\u0445\u0456\u0434\u043d\u0438\u0439");
        map.put("v_oru", "\u043e\u0440\u0443\u0434\u043d\u0438\u0439");
        map.put("v_mis", "\u043c\u0456\u0441\u0446\u0435\u0432\u0438\u0439");
        map.put("v_kly", "\u043a\u043b\u0438\u0447\u043d\u0438\u0439");
        VIDMINKY_MAP = Collections.unmodifiableMap(map);
    }
}

