/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Ukrainian;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.UkrainianTagger;

public class TokenAgreementRule
extends Rule {
    private static final String NO_VIDMINOK_SUBSTR = ":nv";
    private static final String REQUIRE_VIDMINOK_SUBSTR = ":rv_";
    private static final String VIDMINOK_SUBSTR = ":v_";
    private static final Pattern REQUIRE_VIDMINOK_REGEX = Pattern.compile(":r(v_[a-z]+)");
    private static final Pattern VIDMINOK_REGEX = Pattern.compile(":(v_[a-z]+)");
    private final Ukrainian ukrainian = new Ukrainian();
    private static final Set<String> STREETS = new HashSet<String>(Arrays.asList("\u0428\u0442\u0440\u0430\u0441\u0441\u0435", "\u0410\u0432\u0435\u043d\u044e", "\u0421\u0442\u0440\u0456\u0442"));

    public TokenAgreementRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
    }

    public final String getId() {
        return "UK_TOKEN_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u0456";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0441\u043b\u0456\u0432 \u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u0456";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        AnalyzedTokenReadings reqTokenReadings = null;
        int i = -1;
        for (AnalyzedTokenReadings tokenReadings : tokens) {
            ++i;
            String posTag = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag == null || posTag.equals(IPOSTag.todo.getText()) || posTag.equals("SENT_START")) {
                reqTokenReadings = null;
                continue;
            }
            String token = tokenReadings.getAnalyzedToken(0).getToken();
            if (posTag.contains(REQUIRE_VIDMINOK_SUBSTR) && tokenReadings.getReadingsLength() == 1) {
                String prep = token;
                if (prep.equals("\u0437\u0430") && this.reverseSearch(tokens, i, "\u0449\u043e") || prep.equalsIgnoreCase("\u043f\u043e\u043d\u0430\u0434")) continue;
                if ((prep.equalsIgnoreCase("\u043e\u043a\u0440\u0456\u043c") || prep.equalsIgnoreCase("\u043a\u0440\u0456\u043c")) && tokens.length > i + 1 && tokens[i + 1].getAnalyzedToken(0).getToken().equalsIgnoreCase("\u044f\u043a")) {
                    reqTokenReadings = null;
                    continue;
                }
                reqTokenReadings = tokenReadings;
                continue;
            }
            if (reqTokenReadings == null) continue;
            ArrayList<String> posTagsToFind = new ArrayList<String>();
            if (reqTokenReadings.getAnalyzedToken(0).getToken().equalsIgnoreCase("\u043f\u043e\u043d\u0430\u0434")) {
                posTagsToFind.add("v_naz");
            }
            String reqPosTag = reqTokenReadings.getAnalyzedToken(0).getPOSTag();
            Matcher matcher = REQUIRE_VIDMINOK_REGEX.matcher(reqPosTag);
            while (matcher.find()) {
                posTagsToFind.add(matcher.group(1));
            }
            for (AnalyzedToken readingToken : tokenReadings) {
                if (!IPOSTag.numr.match(readingToken.getPOSTag())) continue;
                posTagsToFind.add("v_naz");
                break;
            }
            if (!this.hasRequiredPosTag(posTagsToFind, tokenReadings)) {
                if (this.isTokenToSkip(tokenReadings)) continue;
                String prep = reqTokenReadings.getAnalyzedToken(0).getToken();
                if ((prep.equalsIgnoreCase("\u0432") || prep.equalsIgnoreCase("\u0443")) && this.hasRequiredPosTag(Arrays.asList("p:v_naz"), tokenReadings)) {
                    reqTokenReadings = null;
                    continue;
                }
                if (TokenAgreementRule.isCapitalized(token) && tokens.length > i + 1 && STREETS.contains(tokens[i + 1].getAnalyzedToken(0).getToken())) {
                    reqTokenReadings = null;
                    continue;
                }
                if (tokens.length > i + 1 && IPOSTag.numr.match(tokens[i + 1].getAnalyzedToken(0).getPOSTag()) && token.equals("\u043c\u0456\u043d\u0443\u0441") || token.equals("\u043f\u043b\u044e\u0441")) {
                    reqTokenReadings = null;
                    continue;
                }
                if (reqTokenReadings.getAnalyzedToken(0).getToken().equalsIgnoreCase("\u0447\u0435\u0440\u0435\u0437") && token.equals("\u0440\u043e\u043a\u0456\u0432") && tokens.length > i + 1 && IPOSTag.numr.match(tokens[i + 1].getAnalyzedToken(0).getPOSTag())) {
                    reqTokenReadings = null;
                    continue;
                }
                if ((token.equals("\u0441\u043e\u0431\u0456") || token.equals("\u0439\u043e\u043c\u0443")) && tokens.length > i + 1 && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u043f\u043e\u0434\u0456\u0431\u043d") || (token.equals("\u0443\u0441\u0456\u043c") || token.equals("\u0432\u0441\u0456\u043c")) && tokens.length > i + 1 && tokens[i + 1].getAnalyzedToken(0).getToken().startsWith("\u0432\u0456\u0434\u043e\u043c") || tokens.length > i + 2 && (token.equals("\u043d\u0456\u043a\u043e\u043c\u0443") || token.equals("\u043d\u0456\u043a\u0438\u043c") || token.equals("\u043d\u0456\u0447\u0438\u043c") || token.equals("\u043d\u0456\u0447\u043e\u043c\u0443")) && tokens[i + 1].getAnalyzedToken(0).getToken().equals("\u043d\u0435")) continue;
                RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, reqTokenReadings, posTagsToFind);
                ruleMatches.add(potentialRuleMatch);
            }
            reqTokenReadings = null;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean isCapitalized(String token) {
        return token.length() > 1 && Character.isUpperCase(token.charAt(0)) && Character.isLowerCase(token.charAt(1));
    }

    private boolean reverseSearch(AnalyzedTokenReadings[] tokens, int pos, String string) {
        for (int i = pos - 1; i >= 0 && i > pos - 4; --i) {
            if (!tokens[i].getAnalyzedToken(0).getToken().equalsIgnoreCase("\u0449\u043e")) continue;
            return true;
        }
        return false;
    }

    private boolean isTokenToSkip(AnalyzedTokenReadings tokenReadings) {
        for (AnalyzedToken token : tokenReadings) {
            if (!IPOSTag.adv.match(token.getPOSTag()) && !IPOSTag.insert_sl.match(token.getPOSTag())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredPosTag(Collection<String> posTagsToFind, AnalyzedTokenReadings tokenReadings) {
        boolean vidminokFound = false;
        for (AnalyzedToken token : tokenReadings) {
            String posTag = token.getPOSTag();
            if (posTag == null || posTag.contains(NO_VIDMINOK_SUBSTR)) {
                return true;
            }
            if (!posTag.contains(VIDMINOK_SUBSTR)) continue;
            vidminokFound = true;
            for (String posTagToFind : posTagsToFind) {
                if (!posTag.contains(posTagToFind)) continue;
                return true;
            }
        }
        return !vidminokFound;
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, AnalyzedTokenReadings reqTokenReadings, List<String> posTagsToFind) {
        String tokenString = tokenReadings.getToken();
        Synthesizer ukrainianSynthesizer = this.ukrainian.getSynthesizer();
        ArrayList<String> suggestions = new ArrayList<String>();
        String oldPosTag = tokenReadings.getAnalyzedToken(0).getPOSTag();
        String requiredPostTagsRegEx = ":(" + StringUtils.join(posTagsToFind, (String)"|") + ")";
        String posTag = oldPosTag.replaceFirst(":v_[a-z]+", requiredPostTagsRegEx);
        try {
            String[] synthesized = ukrainianSynthesizer.synthesize(tokenReadings.getAnalyzedToken(0), posTag, true);
            suggestions.addAll(Arrays.asList(synthesized));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> reqVidminkyNames = new ArrayList<String>();
        for (String vidm : posTagsToFind) {
            reqVidminkyNames.add(UkrainianTagger.VIDMINKY_MAP.get(vidm));
        }
        ArrayList<String> foundVidminkyNames = new ArrayList<String>();
        for (AnalyzedToken token : tokenReadings) {
            String posTag2 = token.getPOSTag();
            if (!posTag2.contains(VIDMINOK_SUBSTR)) continue;
            foundVidminkyNames.add(UkrainianTagger.VIDMINKY_MAP.get(posTag2.replaceFirst("^.*" + VIDMINOK_REGEX + ".*$", "$1")));
        }
        String msg = MessageFormat.format("\u041f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u00ab{0}\u00bb \u0432\u0438\u043c\u0430\u0433\u0430\u0454 \u0456\u043d\u0448\u043e\u0433\u043e \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0430: {1}, \u0430 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e: {2}", reqTokenReadings.getToken(), StringUtils.join(reqVidminkyNames, (String)", "), StringUtils.join(foundVidminkyNames, (String)", "));
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + tokenString.length(), msg, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(suggestions);
        return potentialRuleMatch;
    }

    public void reset() {
    }
}

