/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.uk.MixedAlphabetsRule;
import org.languagetool.rules.uk.MorfologikUkrainianSpellerRule;
import org.languagetool.rules.uk.SimpleReplaceRule;
import org.languagetool.rules.uk.TokenAgreementRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.uk.UkrainianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.uk.UkrainianHybridDisambiguator;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.uk.UkrainianWordTokenizer;

public class Ukrainian
extends Language {
    private static final List<String> RULE_FILES = Arrays.asList("grammar-spelling.xml", "grammar-grammar.xml", "grammar-barbarism.xml", "grammar-style.xml", "grammar-punctuation.xml");
    private Tagger tagger;
    private SRXSentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;

    public Locale getLocale() {
        return new Locale(this.getShortName());
    }

    public String getName() {
        return "Ukrainian";
    }

    public String getShortName() {
        return "uk";
    }

    public String[] getCountries() {
        return new String[]{"UA"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201e", "\u00ab", "\u00bb"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201c", "\u00bb", "\u00ab"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new UkrainianTagger();
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new UkrainianSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new UkrainianHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public final Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new UkrainianWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public SRXSentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin"), new Contributor("Maksym Davydov")};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, MorfologikUkrainianSpellerRule.class, MixedAlphabetsRule.class, WhitespaceRule.class, SimpleReplaceRule.class, TokenAgreementRule.class);
    }

    public List<String> getRuleFileNames() {
        List ruleFileNames = super.getRuleFileNames();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        String dirBase = dataBroker.getRulesDir() + "/" + this.getShortName() + "/";
        for (String ruleFile : RULE_FILES) {
            ruleFileNames.add(dirBase + ruleFile);
        }
        return ruleFileNames;
    }
}

