/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.Tagger;

public class UkrainianMyspellTagger
implements Tagger {
    private static final String RESOURCE_FILENAME = "/uk/ukrainian.dict";
    private HashMap<String, String[]> wordsToPos;

    public final List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        if (this.wordsToPos == null) {
            String line;
            this.wordsToPos = new HashMap();
            InputStream resourceFile = JLanguageTool.getDataBroker().getFromResourceDirAsStream(RESOURCE_FILENAME);
            BufferedReader input = new BufferedReader(new InputStreamReader(resourceFile, Charset.forName("UTF-8")));
            Pattern pattern1 = Pattern.compile("[abcdefghijklmnop]+");
            Pattern pattern2 = Pattern.compile("[ABCDEFGHIJKLMN]+");
            Pattern pattern3 = Pattern.compile("[BDFHJLN]+");
            Pattern pattern4 = Pattern.compile("[UV]+");
            while ((line = input.readLine()) != null) {
                String[] wrd;
                if ((line = line.trim()).matches("^[0-9]") || line.length() == 0 || (wrd = line.split("/")).length <= 1) continue;
                String flags = wrd[1];
                ArrayList<String> posTags = new ArrayList<String>();
                if (pattern1.matcher(flags).matches()) {
                    posTags.add("noun");
                    if (flags.equals("b")) {
                        posTags.add("plural");
                    }
                } else if (pattern2.matcher(flags).matches()) {
                    posTags.add("verb");
                    if (pattern3.matcher(flags).matches()) {
                        posTags.add("refl");
                    }
                } else if (pattern4.matcher(flags).matches()) {
                    posTags.add("adj");
                }
                if (posTags.size() <= 0) continue;
                this.wordsToPos.put(wrd[0], posTags.toArray(new String[0]));
            }
            input.close();
        }
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> analyzedTokens = new ArrayList<AnalyzedToken>();
            String[] posTags = this.wordsToPos.get(word);
            String[] lowerPosTags = null;
            if (posTags != null) {
                for (String posTag : posTags) {
                    analyzedTokens.add(new AnalyzedToken(word, posTag, word));
                }
            } else {
                String lowerWord = word.toLowerCase();
                if (!word.equals(lowerWord) && (lowerPosTags = this.wordsToPos.get(lowerWord)) != null) {
                    for (String lowerPosTag : lowerPosTags) {
                        analyzedTokens.add(new AnalyzedToken(word, lowerPosTag, lowerWord));
                    }
                }
            }
            if (posTags == null && lowerPosTags == null) {
                analyzedTokens.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(analyzedTokens.toArray(new AnalyzedToken[analyzedTokens.size()]), pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }
}

