/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.uk.MorfologikUkrainianSpellerRule;
import org.languagetool.rules.uk.SimpleReplaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Ukrainian
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;

    public String getName() {
        return "Ukrainian";
    }

    public String getShortName() {
        return "uk";
    }

    public String[] getCountryVariants() {
        return new String[]{"UA"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201e", "\u00ab", "\u00bb"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201c", "\u00bb", "\u00ab"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new UkrainianTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin"), new Contributor("Maksym Davydov")};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, MorfologikUkrainianSpellerRule.class, UppercaseSentenceStartRule.class, WhitespaceRule.class, SimpleReplaceRule.class);
    }
}

