/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.tl.TagalogTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Tagalog
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Tagger tagger;
    private String name = "Tagalog";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "tl";
    }

    public String[] getCountries() {
        return new String[]{"PH"};
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new TagalogTagger();
        }
        return this.tagger;
    }

    public Contributor[] getMaintainers() {
        Contributor contributor1 = new Contributor("Nathaniel Oco");
        contributor1.setUrl("http://www.dlsu.edu.ph/research/centers/adric/nlp/");
        Contributor contributor2 = new Contributor("Allan Borra");
        contributor2.setUrl("http://www.dlsu.edu.ph/research/centers/adric/nlp/faculty/borra.asp");
        return new Contributor[]{contributor1, contributor2};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, (Language)this), new HunspellRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this));
    }
}

