/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.language.tagging.TamilTagger;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Tamil
extends Language {
    public String getName() {
        return "Tamil";
    }

    public String getShortCode() {
        return "ta";
    }

    public String[] getCountries() {
        return new String[]{"IN"};
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new TamilTagger();
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Elanjelian Venugopal")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 50), new SentenceWhitespaceRule(messages));
    }
}

