/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.tagging.TamilTagger;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Tamil
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Tagger tagger;

    public String getName() {
        return "Tamil";
    }

    public String getShortCode() {
        return "ta";
    }

    public String[] getCountries() {
        return new String[]{"IN"};
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new TamilTagger();
        }
        return this.tagger;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Elanjelian Venugopal")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new SentenceWhitespaceRule(messages));
    }
}

