/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.sv;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

public class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/sv/coherency.txt");

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.addExamplePair(Example.wrong((String)"Det \u00e4r en blandning av <marker>mejl</marker> och <marker>mail</marker> i det du skriver."), Example.fixed((String)"Om du anv\u00e4nder enbart <marker>mejl</marker> n\u00e4r du skriver <marker>mejl</marker> blir det mer konsekvent."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "Anv\u00e4nd endast en av stavningsvarianterna '" + word1 + "' och '" + word2 + "' i en och samma text.";
    }

    public String getId() {
        return "SV_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Enhetlig och konsekvent stavning av ord n\u00e4r det finns stavningsvarianter att v\u00e4lja p\u00e5.";
    }
}

