/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Russian;
import org.languagetool.rules.PartialPosTagFilter;

public class RussianPartialPosTagFilter
extends PartialPosTagFilter {
    protected List<AnalyzedTokenReadings> tag(String token) {
        try {
            Russian russianLanguage = Russian.getInstance();
            List tags = russianLanguage.getTagger().tag(Collections.singletonList(token));
            AnalyzedTokenReadings[] atr = tags.toArray(new AnalyzedTokenReadings[tags.size()]);
            AnalyzedSentence disambiguated = russianLanguage.getDisambiguator().disambiguate(new AnalyzedSentence(atr));
            return Arrays.asList(disambiguated.getTokens());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag and disambiguate '" + token + "'", e);
        }
    }
}

