/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikRussianYOSpellerRule
extends MorfologikSpellerRule {
    public static final String RULE_ID = "MORFOLOGIK_RULE_RU_RU_YO";
    private static final String RESOURCE_FILENAME = "/ru/hunspell/ru_RU_yo.dict";
    private static final Pattern RUSSIAN_LETTERS = Pattern.compile("[-\u0430-\u044f\u0451\u043e\u0301\u0430\u0301\u0435\u0301\u0443\u0301\u0438\u0301\u044b\u0301\u044d\u0301\u044e\u0301\u044f\u0301\u043e\u0300\u0430\u0300\u0435\u0300\u0443\u0300\u045d\u044b\u0300\u044d\u0300\u044e\u0300\u044f\u0300\u02bc\u0410-\u042f\u0401]*");
    private static final int DEFAULT_MIN_RU_VALUE = 0;
    private int conf_ru_Value = 0;
    private static final Set<String> lcDoNotSuggestWords = new HashSet<String>(Arrays.asList("\u0431\u043b\u043e\u0433\u0433\u0435\u0440", "\u0435\u043b\u043a\u0430", "\u0434\u0440\u043e\u0447\u0438\u043c", "\u0430\u043d\u0430\u043b\u044c\u043d\u044b\u0439", "\u043e\u0440\u043e\u0447\u0435\u043c"));

    public MorfologikRussianYOSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        Object[] cf;
        this.setDefaultOff();
        this.addExamplePair(Example.wrong((String)"\u0412\u0441\u0435 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u0435 \u0441\u0435\u043c\u044c\u0438 \u043f\u043e\u0445\u043e\u0436\u0438 \u0434\u0440\u0443\u0433 \u043d\u0430 \u0434\u0440\u0443\u0433\u0430, <marker>\u043a\u0430\u0436\u0434\u044f</marker> \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430\u044f \u0441\u0435\u043c\u044c\u044f \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430 \u043f\u043e-\u0441\u0432\u043e\u0435\u043c\u0443."), Example.fixed((String)"\u0412\u0441\u0435 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u0435 \u0441\u0435\u043c\u044c\u0438 \u043f\u043e\u0445\u043e\u0436\u0438 \u0434\u0440\u0443\u0433 \u043d\u0430 \u0434\u0440\u0443\u0433\u0430, <marker>\u043a\u0430\u0436\u0434\u0430\u044f</marker> \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430\u044f \u0441\u0435\u043c\u044c\u044f \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430 \u043f\u043e-\u0441\u0432\u043e\u0435\u043c\u0443."));
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null) {
            this.conf_ru_Value = (Integer)cf[0];
        }
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return RULE_ID;
    }

    protected List<SuggestedReplacement> filterNoSuggestWords(List<SuggestedReplacement> l) {
        return l.stream().filter(k -> !lcDoNotSuggestWords.contains(k.getReplacement().toLowerCase())).collect(Collectors.toList());
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        String word = tokens[idx].getToken();
        if (this.conf_ru_Value != 1 && !RUSSIAN_LETTERS.matcher(word).matches()) {
            return true;
        }
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }

    public String getDescription() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u0438. \u0422\u043e\u043b\u044c\u043a\u043e \u00ab\u0401\u00bb (\u044d\u043a\u0441\u043f\u0435\u0440\u0438\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e).";
    }

    protected boolean isLatinScript() {
        return false;
    }

    public String getConfigureText() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u0441\u043b\u043e\u0432\u0430 \u043d\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0435, \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u0440\u043c\u0438\u043d\u044b (0/1)";
    }

    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption((Object)0, this.getConfigureText(), (Object)0, (Object)1)};
        return ruleOptions;
    }
}

