/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.tools.StringTools;

class DateFilterHelper {
    DateFilterHelper() {
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.forLanguageTag("ru"));
    }

    protected int getDayOfWeek(String dayStr) {
        String day = StringTools.trimSpecialCharacters((String)dayStr).toLowerCase();
        if (day.startsWith("\u0441\u0443\u0431")) {
            return 7;
        }
        if (day.startsWith("\u0432\u0441")) {
            return 1;
        }
        if (day.startsWith("\u0432\u043e\u0441")) {
            return 1;
        }
        if (day.startsWith("\u043f\u043d")) {
            return 2;
        }
        if (day.startsWith("\u043f\u043e\u043d")) {
            return 2;
        }
        if (day.startsWith("\u0432\u0442")) {
            return 3;
        }
        if (day.startsWith("\u0441\u0440")) {
            return 4;
        }
        if (day.startsWith("\u0447\u0442")) {
            return 5;
        }
        if (day.startsWith("\u0447\u0435\u0442")) {
            return 5;
        }
        if (day.startsWith("\u043f\u0442")) {
            return 6;
        }
        if (day.startsWith("\u043f\u044f\u0442")) {
            return 6;
        }
        if (day.startsWith("\u0441\u0431")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        return date.getDisplayName(7, 2, Locale.forLanguageTag("ru"));
    }

    protected int getMonth(String monthStr) {
        String mon = StringTools.trimSpecialCharacters((String)monthStr).toLowerCase();
        if (mon.startsWith("\u044f\u043d\u0432")) {
            return 1;
        }
        if (mon.startsWith("\u0444\u0435\u0432")) {
            return 2;
        }
        if (mon.startsWith("\u043c\u0430\u0440")) {
            return 3;
        }
        if (mon.startsWith("\u0430\u043f\u0440")) {
            return 4;
        }
        if (mon.startsWith("\u043c\u0430\u0439")) {
            return 5;
        }
        if (mon.startsWith("\u043c\u0430\u044f")) {
            return 5;
        }
        if (mon.startsWith("\u0438\u044e\u043d")) {
            return 6;
        }
        if (mon.startsWith("\u0438\u044e\u043b")) {
            return 7;
        }
        if (mon.startsWith("\u0430\u0432\u0433")) {
            return 8;
        }
        if (mon.startsWith("\u0441\u0435\u043d")) {
            return 9;
        }
        if (mon.startsWith("\u043e\u043a\u0442")) {
            return 10;
        }
        if (mon.startsWith("\u043d\u043e\u044f")) {
            return 11;
        }
        if (mon.startsWith("\u0434\u0435\u043a")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

