/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class RussianSpecificCaseRule
extends Rule {
    private static final Set<String> phrases = new THashSet(RussianSpecificCaseRule.loadPhrases("/ru/specific_case.txt"));
    private static int maxLen;
    private static final Map<String, String> lcToProperSpelling;

    private static List<String> loadPhrases(String path) {
        ArrayList<String> l = new ArrayList<String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            int parts = line.split(" ").length;
            maxLen = Math.max(parts, maxLen);
            l.add(line.trim());
        }
        return l;
    }

    public RussianSpecificCaseRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"\u0420\u0435\u043a\u0430 <marker>\u0440\u044b\u0442\u044b\u0439 \u0431\u0430\u043d\u043a</marker> \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u041f\u0440\u0438\u043a\u0430\u0441\u043f\u0438\u0439\u0441\u043a\u043e\u0439 \u043d\u0438\u0437\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u0438."), Example.fixed((String)"\u0420\u0435\u043a\u0430 <marker>\u0420\u044b\u0442\u044b\u0439 \u0411\u0430\u043d\u043a</marker> \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u041f\u0440\u0438\u043a\u0430\u0441\u043f\u0438\u0439\u0441\u043a\u043e\u0439 \u043d\u0438\u0437\u043c\u0435\u043d\u043d\u043e\u0441\u0442\u0438"));
    }

    public final String getId() {
        return "RU_SPECIFIC_CASE";
    }

    public String getDescription() {
        return "\u041d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0439 \u0432 \u0432\u0435\u0440\u0445\u043d\u0435\u043c \u0438\u043b\u0438 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList<String> l = new ArrayList<String>();
            int j = 0;
            while (l.size() < maxLen && i + j < tokens.length) {
                l.add(tokens[i + j].getToken());
                ++j;
                String phrase = String.join((CharSequence)" ", l);
                String lcPhrase = phrase.toLowerCase();
                String properSpelling = lcToProperSpelling.get(lcPhrase);
                if (properSpelling == null || StringTools.isAllUppercase((String)phrase) || phrase.equals(properSpelling) || i > 0 && tokens[i - 1].isSentenceStart() && !StringTools.startsWithUppercase((String)properSpelling)) continue;
                String msg = this.allWordsUppercase(properSpelling) ? "\u0414\u043b\u044f \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0439 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0443\u044e \u0437\u0430\u0433\u043b\u0430\u0432\u043d\u0443\u044e \u0431\u0443\u043a\u0432\u0443." : "\u0414\u043b\u044f \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0439 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0435 \u043d\u0430\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u043b\u0430\u0432\u043d\u044b\u0445 \u0438 \u0441\u0442\u0440\u043e\u0447\u043d\u044b\u0445 \u0431\u0443\u043a\u0432.";
                RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[i].getStartPos(), tokens[i + j - 1].getEndPos(), msg);
                match.setSuggestedReplacement(properSpelling);
                matches.add(match);
            }
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean allWordsUppercase(String s) {
        return Arrays.stream(s.split(" ")).allMatch(StringTools::startsWithUppercase);
    }

    static {
        lcToProperSpelling = new THashMap();
        for (String phrase : phrases) {
            lcToProperSpelling.put(phrase.toLowerCase(), phrase);
        }
    }
}

