/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ru;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Example;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikRussianSpellerRule
extends MorfologikSpellerRule {
    public static final String RULE_ID = "MORFOLOGIK_RULE_RU_RU";
    private static final String RESOURCE_FILENAME = "/ru/hunspell/ru_RU.dict";
    private static final Pattern RUSSIAN_LETTERS = Pattern.compile(".*[\u0430-\u044f\u0451\u0410-\u042f\u0401].*");

    public MorfologikRussianSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.addExamplePair(Example.wrong((String)"\u0412\u0441\u0435 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u0435 \u0441\u0435\u043c\u044c\u0438 \u043f\u043e\u0445\u043e\u0436\u0438 \u0434\u0440\u0443\u0433 \u043d\u0430 \u0434\u0440\u0443\u0433\u0430, <marker>\u043a\u0430\u0436\u0434\u044f</marker> \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430\u044f \u0441\u0435\u043c\u044c\u044f \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430 \u043f\u043e-\u0441\u0432\u043e\u0435\u043c\u0443."), Example.fixed((String)"\u0412\u0441\u0435 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u0435 \u0441\u0435\u043c\u044c\u0438 \u043f\u043e\u0445\u043e\u0436\u0438 \u0434\u0440\u0443\u0433 \u043d\u0430 \u0434\u0440\u0443\u0433\u0430, <marker>\u043a\u0430\u0436\u0434\u0430\u044f</marker> \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430\u044f \u0441\u0435\u043c\u044c\u044f \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u0430 \u043f\u043e-\u0441\u0432\u043e\u0435\u043c\u0443."));
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return RULE_ID;
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        String word = tokens[idx].getToken();
        if (!RUSSIAN_LETTERS.matcher(word).matches()) {
            return true;
        }
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }
}

