/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.ro.CompoundRule;
import org.languagetool.rules.ro.MorfologikRomanianSpellerRule;
import org.languagetool.rules.ro.RomanianWordRepeatBeginningRule;
import org.languagetool.rules.ro.SimpleReplaceRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ro.RomanianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.ro.RomanianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ro.RomanianWordTokenizer;

public class Romanian
extends Language {
    private Tagger tagger;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private Tokenizer wordTokenizer;
    private SentenceTokenizer sentenceTokenizer;

    public String getName() {
        return "Romanian";
    }

    public String getShortCode() {
        return "ro";
    }

    public String[] getCountries() {
        return new String[]{"RO"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new RomanianTagger();
        }
        return this.tagger;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ionu\u021b P\u0103duraru", "http://www.archeus.ro")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u00ab", "\u00bb"), Arrays.asList("]", ")", "}", "\u201d", "\u00bb", "\u00ab")), new WordRepeatRule(messages, (Language)this), new MorfologikRomanianSpellerRule(messages, this), new RomanianWordRepeatBeginningRule(messages, this), new SimpleReplaceRule(messages), new CompoundRule(messages)});
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new RomanianSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new Romanian());
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new RomanianWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }
}

