/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Romanian;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tools.StringTools;

public class SimpleReplaceRule
extends Rule {
    public static final String ROMANIAN_SIMPLE_REPLACE_RULE = "RO_SIMPLE_REPLACE";
    private static final String FILE_NAME = "/ro/replace.txt";
    private static final String FILE_ENCODING = "utf-8";
    private static final Locale RO_LOCALE = new Locale("ro");
    private final List<Map<String, String>> wrongWords;
    private final Language romanian = new Romanian();

    public final String getFileName() {
        return FILE_NAME;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.wrongWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFileName()));
    }

    public final String getId() {
        return ROMANIAN_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Cuvinte sau grupuri de cuvinte incorecte sau ie\u0219ite din uz";
    }

    public String getShort() {
        return "Cuv\u00e2nt incorect sau ie\u0219it din uz";
    }

    public String getSuggestion() {
        return " este incorect sau ie\u0219it din uz, folosi\u021bi ";
    }

    public String getSuggestionsSeparator() {
        return " sau ";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return RO_LOCALE;
    }

    public String getEncoding() {
        return FILE_ENCODING;
    }

    protected Tokenizer getWordTokenizer() {
        return this.romanian.getWordTokenizer();
    }

    public List<Map<String, String>> getWrongWords() {
        return this.wrongWords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> loadWords(InputStream file) throws IOException {
        ArrayList list = new ArrayList();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = new InputStreamReader(file, this.getEncoding());
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                String[] stringArray;
                if ((line = line.trim()).length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFileName()) + ", line: " + line);
                }
                for (String wrongForm : stringArray = parts[0].split("\\|")) {
                    int wordCount = 0;
                    List tokens = this.getWordTokenizer().tokenize(wrongForm);
                    for (String token : tokens) {
                        if (StringTools.isWhitespace((String)token)) continue;
                        ++wordCount;
                    }
                    for (int i = list.size(); i < wordCount; ++i) {
                        list.add(new HashMap());
                    }
                    ((Map)list.get(wordCount - 1)).put(wrongForm, parts[1]);
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        ArrayList result = new ArrayList();
        for (Map map : list) {
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    private void addToQueue(AnalyzedTokenReadings token, Queue<AnalyzedTokenReadings> prevTokens) {
        boolean inserted = prevTokens.offer(token);
        if (!inserted) {
            prevTokens.poll();
            prevTokens.offer(token);
        }
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(this.wrongWords.size());
        block0: for (int i = 1; i < tokens.length; ++i) {
            this.addToQueue(tokens[i], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> variants = new ArrayList<String>();
            List<AnalyzedTokenReadings> prevTokensList = Arrays.asList(prevTokens.toArray(new AnalyzedTokenReadings[prevTokens.size()]));
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && prevTokensList.get(j + 1).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, prevTokensList.get(j).getToken());
                variants.add(0, sb.toString());
            }
            int len = variants.size();
            for (int j = 0; j < len; ++j) {
                String crtMatch;
                String crt = (String)variants.get(j);
                int crtWordCount = len - j;
                String string = crtMatch = this.isCaseSensitive() ? this.wrongWords.get(crtWordCount - 1).get(crt) : this.wrongWords.get(crtWordCount - 1).get(crt.toLowerCase(this.getLocale()));
                if (crtMatch == null) continue;
                List<String> replacements = Arrays.asList(crtMatch.split("\\|"));
                String msg = crt + this.getSuggestion();
                for (int k = 0; k < replacements.size(); ++k) {
                    if (k > 0) {
                        msg = msg + (k == replacements.size() - 1 ? this.getSuggestionsSeparator() : ", ");
                    }
                    msg = msg + "<suggestion>" + replacements.get(k) + "</suggestion>";
                }
                int startPos = prevTokensList.get(len - crtWordCount).getStartPos();
                int endPos = prevTokensList.get(len - 1).getStartPos() + prevTokensList.get(len - 1).getToken().length();
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, startPos, endPos, msg, this.getShort());
                if (!this.isCaseSensitive() && StringTools.startsWithUppercase((String)crt)) {
                    for (int k = 0; k < replacements.size(); ++k) {
                        replacements.set(k, StringTools.uppercaseFirstChar((String)replacements.get(k)));
                    }
                }
                potentialRuleMatch.setSuggestedReplacements(replacements);
                ruleMatches.add(potentialRuleMatch);
                continue block0;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public void reset() {
    }
}

