/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class PortugueseOrthographyReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String PORTUGUESE_SIMPLE_REPLACE_ORTHOGRAPHY_RULE = "PT_SIMPLE_REPLACE_ORTHOGRAPHY";
    private static final Map<String, List<String>> wrongWords = PortugueseOrthographyReplaceRule.loadFromPath((String)"/pt/replace_orthography.txt");
    private static final Locale PT_LOCALE = new Locale("pt");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PortugueseOrthographyReplaceRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.useSubRuleSpecificIds();
    }

    public String getId() {
        return PORTUGUESE_SIMPLE_REPLACE_ORTHOGRAPHY_RULE;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }

    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public String getShort() {
        return this.messages.getString("desc_spelling_short");
    }

    public String getMessage(String token, List<String> replacements) {
        return this.messages.getString("spelling");
    }
}

