/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;

class ConfusionPairsDataLoader {
    private static final String FILE_ENCODING = "utf-8";

    ConfusionPairsDataLoader() {
    }

    Map<String, AnalyzedTokenReadings> loadWords(List<String> filepaths) {
        HashMap<String, AnalyzedTokenReadings> map = new HashMap<String, AnalyzedTokenReadings>();
        for (String filepath : filepaths) {
            InputStream inputStream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(filepath);
            try (Scanner scanner = new Scanner(inputStream, FILE_ENCODING);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    String[] parts = line.split(";");
                    if (parts.length != 3) {
                        throw new RuntimeException("Format error in file " + filepath + ", line: " + line + ", expected 3 semicolon-separated parts, got " + parts.length);
                    }
                    AnalyzedToken analyzedToken = new AnalyzedToken(parts[1], parts[2], null);
                    if (!map.containsKey(parts[0])) {
                        map.put(parts[0], new AnalyzedTokenReadings(analyzedToken, 0));
                        continue;
                    }
                    AnalyzedTokenReadings atrs = (AnalyzedTokenReadings)map.get(parts[0]);
                    atrs.addReading(analyzedToken, "");
                    map.replace(parts[0], atrs);
                }
            }
        }
        return map;
    }
}

