/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.WrongWordInContextRule;

public class PortugueseWrongWordInContextRule
extends WrongWordInContextRule {
    public PortugueseWrongWordInContextRule(ResourceBundle messages, Language lang) {
        super(messages, lang);
        super.setCategory(Categories.SEMANTICS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"O acidente <marker>infringiu</marker> grandes danos."), Example.fixed((String)"O acidente <marker>infligiu</marker> grandes danos."));
    }

    protected String getCategoryString() {
        return "Confus\u00e3o de Palavras: $match";
    }

    public String getId() {
        return "PORTUGUESE_WRONG_WORD_IN_CONTEXT";
    }

    public String getDescription() {
        return "Confus\u00e3o de palavra dentro do contexto (p.ex. infligir/infringir, etc.)";
    }

    protected String getFilename() {
        return "/pt/wrongWordInContext.txt";
    }

    protected String getMessageString() {
        return "Pretende dizer <suggestion>$SUGGESTION</suggestion> em vez de $WRONGWORD?";
    }

    protected String getShortMessageString() {
        return "Poss\u00edvel confus\u00e3o de termos. Verifique.";
    }

    protected String getLongMessageString() {
        return "Considere <suggestion>$SUGGESTION</suggestion>, i.e. $EXPLANATION_SUGGESTION, em vez de '$WRONGWORD', i.e. $EXPLANATION_WRONGWORD?";
    }
}

