/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseAgreementReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String PORTUGUESE_AGREEMENT_REPLACE_RULE = "PT_AGREEMENT_REPLACE";
    private static final Map<String, List<String>> wrongWords = PortugueseAgreementReplaceRule.loadFromPath((String)"/pt/AOreplace.txt");
    private static final Locale PT_LOCALE = new Locale("pt");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public PortugueseAgreementReplaceRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"<marker>abstracto</marker>"), Example.fixed((String)"<marker>abstrato</marker>"));
        this.useSubRuleSpecificIds();
    }

    public String getId() {
        return PORTUGUESE_AGREEMENT_REPLACE_RULE;
    }

    public String getDescription() {
        return "Palavras alteradas pelo Acordo Ortogr\u00e1fico de 90";
    }

    public String getShort() {
        return "Forma do Acordo Ortogr\u00e1fico de 45.";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "'" + tokenStr + "' \u00e9 uma forma do antigo acordo ortogr\u00e1fico. No novo acordo ortogr\u00e1fico, a palavra escreve-se assim: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Lista_das_altera\u00e7\u00f5es_previstas_pelo_acordo_ortogr\u00e1fico_de_1990");
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

