/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.Rule;
import org.languagetool.rules.pt.BrazilianPortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseArchaismsRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.pt.PostReformPortugueseDashRule;

public class BrazilianPortuguese
extends Portuguese {
    private static final String LANGUAGE_SHORT_CODE = "pt-BR";
    private static volatile Throwable instantiationTrace;

    public BrazilianPortuguese() {
        this(false);
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected BrazilianPortuguese(boolean fakeValue) {
        super(fakeValue);
    }

    @Override
    public String getName() {
        return "Portuguese (Brazil)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new PostReformPortugueseCompoundRule(messages, (Language)this, userConfig));
        rules.add((Rule)new PostReformPortugueseDashRule(messages));
        rules.add((Rule)new BrazilianPortugueseReplaceRule(messages, "/pt/pt-BR/replace.txt", (Language)this));
        rules.add((Rule)new PortugueseBarbarismsRule(messages, "/pt/pt-BR/barbarisms.txt", (Language)this));
        rules.add((Rule)new PortugueseArchaismsRule(messages, "/pt/pt-BR/archaisms.txt", (Language)this));
        rules.add((Rule)new PortugueseClicheRule(messages, "/pt/pt-BR/cliches.txt", (Language)this));
        rules.add((Rule)new PortugueseRedundancyRule(messages, "/pt/pt-BR/redundancies.txt", (Language)this));
        rules.add((Rule)new PortugueseWordinessRule(messages, "/pt/pt-BR/wordiness.txt", (Language)this));
        rules.add((Rule)new PortugueseWikipediaRule(messages, "/pt/pt-BR/wikipedia.txt", (Language)this));
        return rules;
    }

    @Override
    public String[] getCountries() {
        return new String[]{"BR"};
    }

    @NotNull
    public static Portuguese getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Portuguese) {
            Portuguese brazilianPortuguese = (Portuguese)language;
            return brazilianPortuguese;
        }
        throw new RuntimeException("BrazilianPortuguese language expected, got " + language);
    }
}

